/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;

public class UrlValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length != 1) {
            throw new FunctionEvaluationException();
        }
        CSSValue cSSValue = FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]);
        if (cSSValue instanceof CSSResourceValue) {
            CSSResourceValue cSSResourceValue = (CSSResourceValue)cSSValue;
            Resource resource = cSSResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (!(cSSValue instanceof CSSStringValue)) {
            throw new FunctionEvaluationException("Not even remotely an URI: " + cSSValue);
        }
        CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
        CSSResourceValue cSSResourceValue = FunctionUtilities.loadResource(layoutProcess, cSSStringValue.getValue());
        Resource resource = cSSResourceValue.getValue();
        return new ResourceContentToken(resource);
    }
}

