/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "ALWAYS_APPLICABLE", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "kotlin-compiler"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    private static final HashSet<FqName> ALWAYS_APPLICABLE;
    public static final FileClassAnnotationsChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        boolean bl;
        ClassDescriptor classDescriptor;
        ArrayList<Pair> fileAnnotationsToCheck;
        block6: {
            Intrinsics.checkParameterIsNotNull(entries, "entries");
            Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            fileAnnotationsToCheck = CollectionsKt.arrayListOf(new Pair[0]);
            for (KtAnnotationEntry pair : entries) {
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = pair.getUseSiteTarget();
                if (Intrinsics.areEqual((Object)(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null), (Object)AnnotationUseSiteTarget.FILE) ^ true) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, pair) == null) {
                    continue;
                }
                if (TypeUtils.getClassDescriptor(descriptor2.getType()) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor2);
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair<KtAnnotationEntry, ClassDescriptor>(pair, classDescriptor));
            }
            Iterable iterable = fileAnnotationsToCheck;
            for (KtAnnotationEntry element$iv : iterable) {
                Pair it = (Pair)((Object)element$iv);
                if (!Intrinsics.areEqual(DescriptorUtilsKt.getClassId((ClassDescriptor)it.getSecond()).asSingleFqName(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (!bl) {
            return;
        }
        for (Pair pair : fileAnnotationsToCheck) {
            KtAnnotationEntry entry = (KtAnnotationEntry)pair.component1();
            classDescriptor = (ClassDescriptor)pair.component2();
            FqName classFqName = DescriptorUtilsKt.getClassId(classDescriptor).asSingleFqName();
            if (ALWAYS_APPLICABLE.contains(classFqName) || !(Intrinsics.areEqual((Object)DescriptorUtilsKt.getAnnotationRetention(classDescriptor), (Object)KotlinRetention.SOURCE) ^ true)) continue;
            trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
        }
    }

    private FileClassAnnotationsChecker() {
        INSTANCE = this;
        ALWAYS_APPLICABLE = SetsKt.hashSetOf(JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS());
    }

    static {
        new FileClassAnnotationsChecker();
    }
}

