/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.NOperandInstr;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RefinedCachingCallSite;

public abstract class CallBase
extends NOperandInstr
implements ClosureAcceptingInstr {
    private static long callSiteCounter = 1L;
    public final transient long callSiteId = callSiteCounter++;
    private final CallType callType;
    protected String name;
    protected transient CallSite callSite;
    protected transient int argsCount;
    protected transient boolean hasClosure;
    private transient boolean flagsComputed;
    private transient boolean canBeEval;
    private transient boolean targetRequiresCallersBinding;
    private transient boolean targetRequiresCallersFrame;
    private transient boolean dontInline;
    private transient boolean[] splatMap;
    private transient boolean procNew;
    private boolean potentiallyRefined;
    private static final int REQUIRED_OPERANDS = 1;

    protected CallBase(Operation op, CallType callType, String name2, Operand receiver2, Operand[] args2, Operand closure, boolean potentiallyRefined) {
        super(op, CallBase.arrayifyOperands(receiver2, args2, closure));
        this.argsCount = args2.length;
        this.hasClosure = closure != null;
        this.name = name2;
        this.callType = callType;
        this.callSite = CallBase.getCallSiteFor(callType, name2, potentiallyRefined);
        this.splatMap = IRRuntimeHelpers.buildSplatMap(args2);
        this.flagsComputed = false;
        this.canBeEval = true;
        this.targetRequiresCallersBinding = true;
        this.targetRequiresCallersFrame = true;
        this.dontInline = false;
        this.procNew = false;
        this.potentiallyRefined = potentiallyRefined;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getCallType().ordinal());
        e.encode(this.getName());
        e.encode(this.getReceiver());
        e.encode(this.calculateArity());
        for (Operand arg2 : this.getCallArgs()) {
            e.encode(arg2);
        }
        if (this.hasClosure) {
            e.encode(this.getClosureArg(null));
        }
    }

    private int calculateArity() {
        return this.hasClosure ? -1 * (this.argsCount + 1) : this.argsCount;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Operand getClosureArg() {
        return this.hasClosure ? this.operands[this.argsCount + 1] : null;
    }

    public Operand getClosureArg(Operand ifUnspecified) {
        return this.hasClosure ? this.getClosureArg() : ifUnspecified;
    }

    public Operand getReceiver() {
        return this.operands[0];
    }

    public Operand getArg1() {
        return this.operands[1];
    }

    public int getArgsCount() {
        return this.argsCount;
    }

    public Operand[] getCallArgs() {
        Operand[] callArgs = new Operand[this.argsCount];
        System.arraycopy(this.operands, 1, callArgs, 0, this.argsCount);
        return callArgs;
    }

    public CallSite getCallSite() {
        return this.callSite;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public boolean[] splatMap() {
        return this.splatMap;
    }

    public void setProcNew(boolean procNew) {
        this.procNew = procNew;
    }

    public void blockInlining() {
        this.dontInline = true;
    }

    public boolean inliningBlocked() {
        return this.dontInline;
    }

    private static CallSite getCallSiteFor(CallType callType, String name2, boolean potentiallyRefined) {
        assert (callType != null) : "Calltype should never be null";
        if (potentiallyRefined) {
            return new RefinedCachingCallSite(name2, callType);
        }
        switch (callType) {
            case NORMAL: {
                return MethodIndex.getCallSite(name2);
            }
            case FUNCTIONAL: {
                return MethodIndex.getFunctionalCallSite(name2);
            }
            case VARIABLE: {
                return MethodIndex.getVariableCallSite(name2);
            }
            case SUPER: {
                return MethodIndex.getSuperCallSite();
            }
        }
        return null;
    }

    public boolean hasLiteralClosure() {
        return this.getClosureArg() instanceof WrappedIRClosure;
    }

    public static boolean isAllFixnums(Operand[] args2) {
        for (Operand argument : args2) {
            if (argument instanceof Fixnum) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllFloats(Operand[] args2) {
        for (Operand argument : args2) {
            if (argument instanceof Float) continue;
            return false;
        }
        return true;
    }

    public boolean isPotentiallyRefined() {
        return this.potentiallyRefined;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        Operand meth;
        String mname;
        boolean modifiedScope = false;
        if (this.targetRequiresCallersBinding()) {
            modifiedScope = true;
            scope.getFlags().add(IRFlags.BINDING_HAS_ESCAPED);
        }
        if (this.targetRequiresCallersFrame()) {
            modifiedScope = true;
            scope.getFlags().add(IRFlags.REQUIRES_FRAME);
        }
        if (this.canBeEval()) {
            modifiedScope = true;
            scope.getFlags().add(IRFlags.USES_EVAL);
            scope.getFlags().add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
            if (scope.getFlags().contains((Object)IRFlags.RECEIVES_CLOSURE_ARG) && this.argsCount > 1) {
                scope.getFlags().add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
            }
        }
        if ((mname = this.getName()).equals("local_variables")) {
            scope.getFlags().add(IRFlags.REQUIRES_DYNSCOPE);
        } else if (CallBase.potentiallySend(mname) && this.argsCount >= 1 && (meth = this.getArg1()) instanceof StringLiteral && "local_variables".equals(((StringLiteral)meth).getString())) {
            scope.getFlags().add(IRFlags.REQUIRES_DYNSCOPE);
        }
        if (this.potentiallyRefined) {
            scope.getFlags().add(IRFlags.REQUIRES_DYNSCOPE);
        }
        return modifiedScope;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        super.simplifyOperands(valueMap, force);
        this.splatMap = IRRuntimeHelpers.buildSplatMap(this.getCallArgs());
        this.flagsComputed = false;
    }

    public Operand[] cloneCallArgs(CloneInfo ii) {
        Operand[] clonedArgs = new Operand[this.argsCount];
        for (int i2 = 0; i2 < this.argsCount; ++i2) {
            clonedArgs[i2] = this.operands[i2 + 1].cloneForInlining(ii);
        }
        return clonedArgs;
    }

    private boolean computeEvalFlag() {
        String mname = this.getName();
        if ((mname.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval")) && this.getArgsCount() != 0) {
            return true;
        }
        if (CallBase.potentiallySend(mname) && this.argsCount >= 1) {
            Operand meth = this.getArg1();
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            String name2 = ((StringLiteral)meth).getString();
            return name2.equals("call") || name2.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval") || name2.equals("send") || name2.equals("__send__");
        }
        return false;
    }

    private boolean computeRequiresCallersBindingFlag() {
        if (this.canBeEval()) {
            return true;
        }
        if (this.hasLiteralClosure()) {
            return true;
        }
        String mname = this.getName();
        if (MethodIndex.SCOPE_AWARE_METHODS.contains(mname)) {
            return true;
        }
        if (CallBase.potentiallySend(mname) && this.argsCount >= 1) {
            Operand meth = this.getArg1();
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            return MethodIndex.SCOPE_AWARE_METHODS.contains(((StringLiteral)meth).getString());
        }
        return false;
    }

    private boolean computeRequiresCallersFrameFlag() {
        if (this.canBeEval()) {
            return true;
        }
        if (this.hasLiteralClosure()) {
            return true;
        }
        if (this.procNew) {
            return true;
        }
        String mname = this.getName();
        if (MethodIndex.FRAME_AWARE_METHODS.contains(mname)) {
            return true;
        }
        if (CallBase.potentiallySend(mname) && this.argsCount >= 1) {
            Operand meth = this.getArg1();
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            return MethodIndex.FRAME_AWARE_METHODS.contains(((StringLiteral)meth).getString());
        }
        return false;
    }

    private static boolean potentiallySend(String name2) {
        return name2.equals("send") || name2.equals("__send__");
    }

    private void computeFlags() {
        this.flagsComputed = true;
        this.canBeEval = this.computeEvalFlag();
        this.targetRequiresCallersBinding = this.canBeEval || this.computeRequiresCallersBindingFlag();
        this.targetRequiresCallersFrame = this.canBeEval || this.computeRequiresCallersFrameFlag();
    }

    public boolean canBeEval() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.canBeEval;
    }

    public boolean targetRequiresCallersBinding() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.targetRequiresCallersBinding;
    }

    public boolean targetRequiresCallersFrame() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.targetRequiresCallersFrame;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"n:" + this.getName(), "t:" + this.callType.toString().substring(0, 2), "cl:" + this.hasClosure};
    }

    public static boolean containsArgSplat(Operand[] arguments) {
        for (Operand argument : arguments) {
            if (!(argument instanceof Splat)) continue;
            return true;
        }
        return false;
    }

    private static Operand[] arrayifyOperands(Operand receiver2, Operand[] callArgs, Operand closure) {
        Operand[] allArgs = new Operand[callArgs.length + 1 + (closure != null ? 1 : 0)];
        assert (receiver2 != null) : "RECEIVER is null";
        allArgs[0] = receiver2;
        for (int i2 = 0; i2 < callArgs.length; ++i2) {
            assert (callArgs[i2] != null) : "ARG " + i2 + " is null";
            allArgs[i2 + 1] = callArgs[i2];
        }
        if (closure != null) {
            allArgs[callArgs.length + 1] = closure;
        }
        return allArgs;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self2, currScope, dynamicScope, temp);
        Block preparedBlock = this.prepareBlock(context, self2, currScope, dynamicScope, temp);
        return this.callSite.call(context, self2, object, values2, preparedBlock);
    }

    protected IRubyObject[] prepareArguments(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope dynamicScope, Object[] temp) {
        return this.splatMap != null ? this.prepareArgumentsComplex(context, self2, currScope, dynamicScope, temp) : this.prepareArgumentsSimple(context, self2, currScope, dynamicScope, temp);
    }

    protected IRubyObject[] prepareArgumentsSimple(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject[] newArgs = new IRubyObject[this.argsCount];
        for (int i2 = 0; i2 < this.argsCount; ++i2) {
            newArgs[i2] = (IRubyObject)this.operands[i2 + 1].retrieve(context, self2, currScope, currDynScope, temp);
        }
        return newArgs;
    }

    protected IRubyObject[] prepareArgumentsComplex(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return IRRuntimeHelpers.splatArguments(this.prepareArgumentsSimple(context, self2, currScope, currDynScope, temp), this.splatMap);
    }

    public Block prepareBlock(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        if (this.getClosureArg() == null) {
            return Block.NULL_BLOCK;
        }
        return IRRuntimeHelpers.getBlockFromObject(context, this.getClosureArg().retrieve(context, self2, currScope, currDynScope, temp));
    }
}

