/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.ascan.AllCategoryTableModel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class PolicyAllCategoryPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PolicyAllCategoryPanel.class);
    private ZapTextField policyName = null;
    private JTable tableTest = null;
    private JScrollPane jScrollPane = null;
    private AllCategoryTableModel allCategoryTableModel = null;
    private JComboBox<String> policySelector = null;
    private JComboBox<String> comboThreshold = null;
    private JLabel labelThresholdNotes = null;
    private JComboBox<String> comboStrength = null;
    private JLabel labelStrengthNotes = null;
    private JComboBox<String> applyToThreshold = null;
    private JComboBox<String> applyToStrength = null;
    private JComboBox<String> applyToThresholdTarget = null;
    private JComboBox<String> applyToStrengthTarget = null;
    private ExtensionActiveScan extension;
    private ScanPolicy policy;
    private String currentName;
    private boolean switchable = false;
    private static final int[] width = new int[]{300, 100, 100};

    public PolicyAllCategoryPanel(Window window, ExtensionActiveScan extensionActiveScan, ScanPolicy scanPolicy) {
        this(window, extensionActiveScan, scanPolicy, false);
    }

    public PolicyAllCategoryPanel(Window window, ExtensionActiveScan extensionActiveScan, ScanPolicy scanPolicy, boolean bl) {
        this.extension = extensionActiveScan;
        this.policy = scanPolicy;
        this.currentName = scanPolicy.getName();
        this.switchable = bl;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setSize(375, 205);
        this.setName("categoryPanel");
        int n = 0;
        this.add((Component)new JLabel(Constant.messages.getString("ascan.policy.name.label")), LayoutHelper.getGBC(0, n, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        if (this.switchable) {
            this.add(this.getPolicySelector(), LayoutHelper.getGBC(1, n, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        } else {
            this.add((Component)this.getPolicyName(), LayoutHelper.getGBC(1, n, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        }
        this.add((Component)new JLabel(Constant.messages.getString("ascan.options.level.label")), LayoutHelper.getGBC(0, ++n, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add(this.getComboThreshold(), LayoutHelper.getGBC(1, n, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)this.getThresholdNotes(), LayoutHelper.getGBC(2, n, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)new JLabel(Constant.messages.getString("ascan.options.strength.label")), LayoutHelper.getGBC(0, ++n, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add(this.getComboStrength(), LayoutHelper.getGBC(1, n, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        this.add((Component)this.getStrengthNotes(), LayoutHelper.getGBC(2, n, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.apply.label")), LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        jPanel.add(this.getApplyToThreshold(), LayoutHelper.getGBC(1, 0, 1, 0.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.thresholdTo.label")), LayoutHelper.getGBC(2, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        jPanel.add(this.getApplyToThresholdTarget(), LayoutHelper.getGBC(3, 0, 1, 0.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.rules.label")), LayoutHelper.getGBC(4, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        JButton jButton = new JButton(Constant.messages.getString("ascan.options.go.button"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PolicyAllCategoryPanel.this.applyThreshold(PolicyAllCategoryPanel.this.strToThreshold((String)PolicyAllCategoryPanel.this.getApplyToThreshold().getSelectedItem()), (String)PolicyAllCategoryPanel.this.getApplyToThresholdTarget().getSelectedItem());
                PolicyAllCategoryPanel.this.getAllCategoryTableModel().fireTableDataChanged();
            }
        });
        jPanel.add((Component)jButton, LayoutHelper.getGBC(5, 0, 1, 0.0));
        jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(6, 0, 1, 1.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.apply.label")), LayoutHelper.getGBC(0, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        jPanel.add(this.getApplyToStrength(), LayoutHelper.getGBC(1, 1, 1, 0.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.strengthTo.label")), LayoutHelper.getGBC(2, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        jPanel.add(this.getApplyToStrengthTarget(), LayoutHelper.getGBC(3, 1, 1, 0.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.options.rules.label")), LayoutHelper.getGBC(4, 1, 1, 0.0, new Insets(2, 2, 2, 2)));
        JButton jButton2 = new JButton(Constant.messages.getString("ascan.options.go.button"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PolicyAllCategoryPanel.this.applyStrength(PolicyAllCategoryPanel.this.strToStrength((String)PolicyAllCategoryPanel.this.getApplyToStrength().getSelectedItem()), (String)PolicyAllCategoryPanel.this.getApplyToStrengthTarget().getSelectedItem());
                PolicyAllCategoryPanel.this.getAllCategoryTableModel().fireTableDataChanged();
            }
        });
        jPanel.add((Component)jButton2, LayoutHelper.getGBC(5, 1, 1, 0.0));
        jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(6, 1, 1, 1.0));
        this.add((Component)jPanel, LayoutHelper.getGBC(0, ++n, 3, 0.0, 0.0, 1, new Insets(0, 0, 0, 0)));
        this.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, ++n, 3, 1.0, 1.0, 1, new Insets(0, 0, 0, 0)));
        this.setThreshold(this.policy.getDefaultThreshold());
        this.setStrength(this.policy.getDefaultStrength());
    }

    public void initialise(ScanPolicy scanPolicy) {
        this.getPolicyName().setText(scanPolicy.getName());
    }

    private ZapTextField getPolicyName() {
        if (this.policyName == null) {
            this.policyName = new ZapTextField();
            this.policyName.setText(this.policy.getName());
        }
        return this.policyName;
    }

    private JComboBox<String> getPolicySelector() {
        if (this.policySelector == null) {
            this.policySelector = new JComboBox();
            for (String string : this.extension.getPolicyManager().getAllPolicyNames()) {
                this.policySelector.addItem(string);
            }
            this.policySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)PolicyAllCategoryPanel.this.policySelector.getSelectedItem();
                    if (string == null) {
                        return;
                    }
                    try {
                        ScanPolicy scanPolicy = PolicyAllCategoryPanel.this.extension.getPolicyManager().getPolicy(string);
                        if (scanPolicy != null) {
                            PolicyAllCategoryPanel.this.setScanPolicy(scanPolicy);
                            PolicyAllCategoryPanel.this.fireScanPolicyChanged(scanPolicy);
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                    }
                }
            });
        }
        return this.policySelector;
    }

    public void reloadPolicies(String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string2 : this.extension.getPolicyManager().getAllPolicyNames()) {
            defaultComboBoxModel.addElement(string2);
        }
        this.getPolicySelector().setModel(defaultComboBoxModel);
        this.getPolicySelector().setSelectedItem(string);
    }

    public void reloadPolicies() {
        Object object = this.getPolicySelector().getSelectedItem();
        this.reloadPolicies((String)object);
    }

    private Plugin.AlertThreshold strToThreshold(String string) {
        if (string.equals(Constant.messages.getString("ascan.options.level.off"))) {
            return Plugin.AlertThreshold.OFF;
        }
        if (string.equals(Constant.messages.getString("ascan.options.level.low"))) {
            return Plugin.AlertThreshold.LOW;
        }
        if (string.equals(Constant.messages.getString("ascan.options.level.medium"))) {
            return Plugin.AlertThreshold.MEDIUM;
        }
        if (string.equals(Constant.messages.getString("ascan.options.level.high"))) {
            return Plugin.AlertThreshold.HIGH;
        }
        return Plugin.AlertThreshold.DEFAULT;
    }

    private JComboBox<String> getApplyToThreshold() {
        if (this.applyToThreshold == null) {
            this.applyToThreshold = new JComboBox();
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.default"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.off"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.low"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.medium"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.high"));
        }
        return this.applyToThreshold;
    }

    private JComboBox<String> getApplyToThresholdTarget() {
        if (this.applyToThresholdTarget == null) {
            this.applyToThresholdTarget = this.createStatusComboBox();
        }
        return this.applyToThresholdTarget;
    }

    private JComboBox<String> createStatusComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Constant.messages.getString("ascan.policy.table.quality.all"));
        View view = View.getSingleton();
        jComboBox.addItem(view.getStatusUI(AddOn.Status.release).toString());
        jComboBox.addItem(view.getStatusUI(AddOn.Status.beta).toString());
        jComboBox.addItem(view.getStatusUI(AddOn.Status.alpha).toString());
        return jComboBox;
    }

    private void applyThreshold(Plugin.AlertThreshold alertThreshold, String string) {
        for (Plugin plugin : this.policy.getPluginFactory().getAllPlugin()) {
            if (!this.hasSameStatus(plugin, string)) continue;
            plugin.setAlertThreshold(alertThreshold);
        }
    }

    private boolean hasSameStatus(Plugin plugin, String string) {
        if (string.equals(Constant.messages.getString("ascan.policy.table.quality.all"))) {
            return true;
        }
        return string.equals(View.getSingleton().getStatusUI(plugin.getStatus()).toString());
    }

    private Plugin.AttackStrength strToStrength(String string) {
        if (string.equals(Constant.messages.getString("ascan.options.strength.low"))) {
            return Plugin.AttackStrength.LOW;
        }
        if (string.equals(Constant.messages.getString("ascan.options.strength.medium"))) {
            return Plugin.AttackStrength.MEDIUM;
        }
        if (string.equals(Constant.messages.getString("ascan.options.strength.high"))) {
            return Plugin.AttackStrength.HIGH;
        }
        if (string.equals(Constant.messages.getString("ascan.options.strength.insane"))) {
            return Plugin.AttackStrength.INSANE;
        }
        return Plugin.AttackStrength.DEFAULT;
    }

    private JComboBox<String> getApplyToStrength() {
        if (this.applyToStrength == null) {
            this.applyToStrength = new JComboBox();
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.default"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.low"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.medium"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.high"));
            this.applyToStrength.addItem(Constant.messages.getString("ascan.options.strength.insane"));
        }
        return this.applyToStrength;
    }

    private JComboBox<String> getApplyToStrengthTarget() {
        if (this.applyToStrengthTarget == null) {
            this.applyToStrengthTarget = this.createStatusComboBox();
        }
        return this.applyToStrengthTarget;
    }

    private void applyStrength(Plugin.AttackStrength attackStrength, String string) {
        for (Plugin plugin : this.policy.getPluginFactory().getAllPlugin()) {
            if (!this.hasSameStatus(plugin, string)) continue;
            plugin.setAttackStrength(attackStrength);
        }
    }

    private void setThreshold(Plugin.AlertThreshold alertThreshold) {
        this.getComboThreshold().setSelectedItem(Constant.messages.getString("ascan.options.level." + alertThreshold.name().toLowerCase()));
        this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level." + alertThreshold.name().toLowerCase() + ".label"));
    }

    private void setStrength(Plugin.AttackStrength attackStrength) {
        this.getComboStrength().setSelectedItem(Constant.messages.getString("ascan.options.strength." + attackStrength.name().toLowerCase()));
        this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength." + attackStrength.name().toLowerCase() + ".label"));
    }

    private JTable getTableTest() {
        if (this.tableTest == null) {
            Object object;
            this.tableTest = new JTable();
            this.tableTest.setModel(this.getAllCategoryTableModel());
            this.tableTest.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableTest.setIntercellSpacing(new Dimension(1, 1));
            this.tableTest.setAutoCreateRowSorter(true);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.tableTest.getRowSorter().setSortKeys(arrayList);
            for (int i = 0; i < this.tableTest.getColumnCount() - 1; ++i) {
                object = this.tableTest.getColumnModel().getColumn(i);
                ((TableColumn)object).setPreferredWidth(width[i]);
            }
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem("");
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                jComboBox.addItem(Constant.messages.getString("ascan.policy.level." + alertThreshold.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
            object = new JComboBox();
            ((JComboBox)object).addItem("");
            for (Plugin.AttackStrength attackStrength : Plugin.AttackStrength.values()) {
                ((JComboBox)object).addItem(Constant.messages.getString("ascan.policy.level." + attackStrength.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor((JComboBox<?>)object));
        }
        return this.tableTest;
    }

    public void setScanPolicy(ScanPolicy scanPolicy) {
        if (!this.switchable) {
            throw new InvalidParameterException("Cannot change policy if the panel has not been defined as switchable");
        }
        this.policy = scanPolicy;
        this.getPolicySelector().setSelectedItem(scanPolicy.getName());
        this.setThreshold(scanPolicy.getDefaultThreshold());
        this.setStrength(scanPolicy.getDefaultStrength());
        this.getAllCategoryTableModel().setPluginFactory(scanPolicy.getPluginFactory());
    }

    @Override
    public void initParam(Object object) {
    }

    @Override
    public void validateParam(Object object) throws Exception {
        String string = this.getPolicyName().getText();
        if (string.length() == 0) {
            throw new Exception(Constant.messages.getString("ascan.policy.warn.noname"));
        }
        if (!this.extension.getPolicyManager().isLegalPolicyName(string)) {
            throw new Exception(Constant.messages.getString("ascan.policy.warn.badname", "/`?*\\<>|\":\t\n\r"));
        }
        if (!string.equals(this.currentName) && this.extension.getPolicyManager().getAllPolicyNames().contains(string)) {
            throw new Exception(Constant.messages.getString("ascan.policy.warn.exists"));
        }
    }

    @Override
    public void saveParam(Object object) throws Exception {
        this.policy.setName(this.getPolicyName().getText());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableTest());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private AllCategoryTableModel getAllCategoryTableModel() {
        if (this.allCategoryTableModel == null) {
            this.allCategoryTableModel = new AllCategoryTableModel(this);
            this.allCategoryTableModel.setPluginFactory(this.policy.getPluginFactory());
        }
        return this.allCategoryTableModel;
    }

    private JLabel getThresholdNotes() {
        if (this.labelThresholdNotes == null) {
            this.labelThresholdNotes = new JLabel();
        }
        return this.labelThresholdNotes;
    }

    private JComboBox<String> getComboThreshold() {
        if (this.comboThreshold == null) {
            this.comboThreshold = new JComboBox();
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.low"));
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.medium"));
            this.comboThreshold.addItem(Constant.messages.getString("ascan.options.level.high"));
            this.comboThreshold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PolicyAllCategoryPanel.this.comboThreshold.getSelectedItem().equals(Constant.messages.getString("ascan.options.level.low"))) {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.low.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.LOW);
                    } else if (PolicyAllCategoryPanel.this.comboThreshold.getSelectedItem().equals(Constant.messages.getString("ascan.options.level.medium"))) {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.medium.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
                    } else {
                        PolicyAllCategoryPanel.this.getThresholdNotes().setText(Constant.messages.getString("ascan.options.level.high.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultThreshold(Plugin.AlertThreshold.HIGH);
                    }
                }
            });
        }
        return this.comboThreshold;
    }

    private JLabel getStrengthNotes() {
        if (this.labelStrengthNotes == null) {
            this.labelStrengthNotes = new JLabel();
        }
        return this.labelStrengthNotes;
    }

    private JComboBox<String> getComboStrength() {
        if (this.comboStrength == null) {
            this.comboStrength = new JComboBox();
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.low"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.medium"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.high"));
            this.comboStrength.addItem(Constant.messages.getString("ascan.options.strength.insane"));
            this.comboStrength.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.low"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.low.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.LOW);
                    } else if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.medium"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.medium.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
                    } else if (PolicyAllCategoryPanel.this.comboStrength.getSelectedItem().equals(Constant.messages.getString("ascan.options.strength.high"))) {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.high.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.HIGH);
                    } else {
                        PolicyAllCategoryPanel.this.getStrengthNotes().setText(Constant.messages.getString("ascan.options.strength.insane.label"));
                        PolicyAllCategoryPanel.this.policy.setDefaultStrength(Plugin.AttackStrength.INSANE);
                    }
                }
            });
        }
        return this.comboStrength;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicy";
    }

    public void addScanPolicyChangedEventListener(ScanPolicyChangedEventListener scanPolicyChangedEventListener) {
        this.listenerList.add(ScanPolicyChangedEventListener.class, scanPolicyChangedEventListener);
    }

    public void removeScanPolicyChangedEventListener(ScanPolicyChangedEventListener scanPolicyChangedEventListener) {
        this.listenerList.remove(ScanPolicyChangedEventListener.class, scanPolicyChangedEventListener);
    }

    private void fireScanPolicyChanged(ScanPolicy scanPolicy) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ScanPolicyChangedEventListener.class) continue;
            ((ScanPolicyChangedEventListener)objectArray[i + 1]).scanPolicyChanged(scanPolicy);
        }
    }

    public static interface ScanPolicyChangedEventListener
    extends EventListener {
        public void scanPolicyChanged(ScanPolicy var1);
    }
}

