/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuAlert
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PopupMenuAlert.class);
    private ExtensionHistory extension = null;

    public PopupMenuAlert(String string) {
        super(string);
    }

    @Override
    public void performAction(HistoryReference historyReference) {
        PopupMenuItemHttpMessageContainer.Invoker invoker = this.getInvoker();
        if (invoker == PopupMenuItemHttpMessageContainer.Invoker.ACTIVE_SCANNER_PANEL) {
            try {
                this.getExtensionHistory().showAlertAddDialog(historyReference.getHttpMessage(), 3);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        } else if (invoker == PopupMenuItemHttpMessageContainer.Invoker.FUZZER_PANEL) {
            try {
                this.getExtensionHistory().showAlertAddDialog(historyReference.getHttpMessage(), 8);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.getExtensionHistory().showAlertAddDialog(historyReference);
        }
    }

    private ExtensionHistory getExtensionHistory() {
        if (this.extension == null) {
            this.extension = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return this.extension;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        if (this.getExtensionHistory() == null) {
            return false;
        }
        switch (invoker) {
            case ALERTS_PANEL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        if (historyReference != null) {
            switch (this.getInvoker()) {
                case ACTIVE_SCANNER_PANEL: 
                case FUZZER_PANEL: {
                    return true;
                }
            }
            return historyReference.getHistoryType() != 0;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

