#ifndef _EFL_EVENT_EO_H_
#define _EFL_EVENT_EO_H_

#ifndef _EFL_EVENT_EO_CLASS_TYPE
#define _EFL_EVENT_EO_CLASS_TYPE

typedef Eo Efl_Event;

#endif

#ifndef _EFL_EVENT_EO_TYPES
#define _EFL_EVENT_EO_TYPES


#endif
/**
 * @brief Represents a generic event data.
 *
 * @note Most Eo Events do not carry Eo objects, rather simple data structures.
 * This class is intended to carry more complex event data, such as pointer
 * events.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event
 */
#define EFL_EVENT_INTERFACE efl_event_interface_get()

EWAPI const Eo_Class *efl_event_interface_get(void);

/**
 * @brief The time at which an event was generated.
 *
 * If the event is generated by a server (eg. X.org or Wayland), then the time
 * may be set by the server. Usually this time will be based on the monotonic
 * clock, if available, but this class can not guarantee it.
 *
 * @return Time in milliseconds when the event happened.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event
 */
EOAPI double efl_event_timestamp_get(const Eo *obj);

/**
 * @brief The time at which an event was generated.
 *
 * If the event is generated by a server (eg. X.org or Wayland), then the time
 * may be set by the server. Usually this time will be based on the monotonic
 * clock, if available, but this class can not guarantee it.
 *
 * Call this when generating events manually.
 *
 * @param[in] ms Time in milliseconds when the event happened.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event
 */
EOAPI void efl_event_timestamp_set(Eo *obj, double ms);

/** Resets the internal data to 0 or default values.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event
 */
EOAPI void efl_event_reset(Eo *obj);

/** Creates a copy of this event.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event
 */
EOAPI Efl_Event *efl_event_dup(Eo *obj);

#ifdef EFL_EVENT_PROTECTED
EOAPI Efl_Event *efl_event_instance_get(const Eo *obj, Eo_Base *owner, void **priv);
#endif


#endif
