#ifndef EFL_MODEL_EO_HH
#define EFL_MODEL_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_model.eo.h"
#include "eo_base.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "eo_base.eo.hh"
namespace efl { 
struct Model;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Model> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { 
struct Model {
   ::efl::eolian::return_traits<  ::efl::eina::range_array< ::efl::eina::string_view>>::type properties_get() const;
   ::efl::eolian::return_traits< ::efl::eina::future< ::efl::eina::value_view>>::type property_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type property) const;
   ::efl::eolian::return_traits< ::efl::eina::future< ::efl::eina::accessor< ::eo::Base>>>::type children_slice_get( ::efl::eolian::in_traits< unsigned int>::type start,  ::efl::eolian::in_traits< unsigned int>::type count) const;
   ::efl::eolian::return_traits< ::efl::eina::future< unsigned int>>::type children_count_get() const;
   ::efl::eolian::return_traits< ::eo::Base>::type child_add() const;
   ::efl::eolian::return_traits<void>::type child_del( ::efl::eolian::in_traits< ::eo::Base>::type child) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_MODEL_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Model() const;
   operator ::efl::Model&();
   operator ::efl::Model const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Model> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Model const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Model : ::efl::eo::concrete
{
   explicit Model( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Model(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Model(Model const& other) = default;
   Model(Model&& other) = default;
   Model& operator=(Model const& other) = default;
   Model& operator=(Model&& other) = default;
   Model()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Model( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Model(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<  ::efl::eina::range_array< ::efl::eina::string_view>>::type properties_get() const;
   ::efl::eolian::return_traits< ::efl::eina::future< ::efl::eina::value_view>>::type property_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type property) const;
   ::efl::eolian::return_traits< ::efl::eina::future< ::efl::eina::accessor< ::eo::Base>>>::type children_slice_get( ::efl::eolian::in_traits< unsigned int>::type start,  ::efl::eolian::in_traits< unsigned int>::type count) const;
   ::efl::eolian::return_traits< ::efl::eina::future< unsigned int>>::type children_count_get() const;
   ::efl::eolian::return_traits< ::eo::Base>::type child_add() const;
   ::efl::eolian::return_traits<void>::type child_del( ::efl::eolian::in_traits< ::eo::Base>::type child) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_MODEL_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct properties_changed_event
   {
      static Eo_Event_Description const* description()
      { return EFL_MODEL_EVENT_PROPERTIES_CHANGED; }
      typedef Efl_Model_Property_Event parameter_type;
   } const properties_changed_event;
   static struct child_added_event
   {
      static Eo_Event_Description const* description()
      { return EFL_MODEL_EVENT_CHILD_ADDED; }
      typedef void parameter_type;
   } const child_added_event;
   static struct child_removed_event
   {
      static Eo_Event_Description const* description()
      { return EFL_MODEL_EVENT_CHILD_REMOVED; }
      typedef void parameter_type;
   } const child_removed_event;
   static struct children_count_changed_event
   {
      static Eo_Event_Description const* description()
      { return EFL_MODEL_EVENT_CHILDREN_COUNT_CHANGED; }
      typedef void parameter_type;
   } const children_count_changed_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Model> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Model const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Model) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Model>::value, "");
} 
#include "efl_model.eo.impl.hh"
#endif
