-- EFL LuaJIT bindings: elm_slideshow.eo (class Elm.Slideshow)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_slideshow_class_get()
    eo.class_register("Elm_Slideshow", {"Elm_Layout"}, {"Elm_Interface_Atspi_Widget_Action"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_slideshow_class_get(void);
    void elm_obj_slideshow_cache_after_set(int count);
    int elm_obj_slideshow_cache_after_get(void);
    void elm_obj_slideshow_cache_before_set(int count);
    int elm_obj_slideshow_cache_before_get(void);
    void elm_obj_slideshow_layout_set(const char * layout);
    const char *elm_obj_slideshow_layout_get(void);
    void elm_obj_slideshow_transition_set(const char * transition);
    const char *elm_obj_slideshow_transition_get(void);
    void elm_obj_slideshow_loop_set(Eina_Bool loop);
    Eina_Bool elm_obj_slideshow_loop_get(void);
    void elm_obj_slideshow_timeout_set(double timeout);
    double elm_obj_slideshow_timeout_get(void);
    const Eina_List *elm_obj_slideshow_items_get(void);
    const Eina_List *elm_obj_slideshow_transitions_get(void);
    unsigned int elm_obj_slideshow_count_get(void);
    Elm_Widget_Item *elm_obj_slideshow_item_current_get(void);
    const Eina_List *elm_obj_slideshow_layouts_get(void);
    void elm_obj_slideshow_previous(void);
    Elm_Widget_Item *elm_obj_slideshow_item_nth_get(unsigned int nth);
    void elm_obj_slideshow_next(void);
    void elm_obj_slideshow_clear(void);
    Elm_Widget_Item *elm_obj_slideshow_item_add(const Elm_Slideshow_Item_Class * itc, const void * data);
    Elm_Widget_Item *elm_obj_slideshow_item_sorted_insert(const Elm_Slideshow_Item_Class * itc, const void * data, Eina_Compare_Cb func);
    extern const Eo_Event_Description _ELM_SLIDESHOW_EVENT_CHANGED;
    extern const Eo_Event_Description _ELM_SLIDESHOW_EVENT_TRANSITION_END;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    cache_after_set = function(self, count)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_cache_after_set(count)
        eo.__do_end()
    end,

    cache_after_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_cache_after_get()
        eo.__do_end()
        return tonumber(v)
    end,

    cache_before_set = function(self, count)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_cache_before_set(count)
        eo.__do_end()
    end,

    cache_before_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_cache_before_get()
        eo.__do_end()
        return tonumber(v)
    end,

    layout_set = function(self, layout)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_layout_set(layout)
        eo.__do_end()
    end,

    layout_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_layout_get()
        eo.__do_end()
        return v
    end,

    transition_set = function(self, transition)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_transition_set(transition)
        eo.__do_end()
    end,

    transition_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_transition_get()
        eo.__do_end()
        return v
    end,

    loop_set = function(self, loop)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_loop_set(loop)
        eo.__do_end()
    end,

    loop_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_loop_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    timeout_set = function(self, timeout)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_timeout_set(timeout)
        eo.__do_end()
    end,

    timeout_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_timeout_get()
        eo.__do_end()
        return tonumber(v)
    end,

    items_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_items_get()
        eo.__do_end()
    end,

    transitions_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_transitions_get()
        eo.__do_end()
    end,

    count_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_count_get()
        eo.__do_end()
    end,

    item_current_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_item_current_get()
        eo.__do_end()
    end,

    layouts_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_layouts_get()
        eo.__do_end()
    end,

    previous = function(self)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_previous()
        eo.__do_end()
    end,

    item_nth_get = function(self, nth)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_item_nth_get(nth)
        eo.__do_end()
        return v
    end,

    next = function(self)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_next()
        eo.__do_end()
    end,

    clear = function(self)
        eo.__do_start(self, __class)
        __lib.elm_obj_slideshow_clear()
        eo.__do_end()
    end,

    item_add = function(self, itc, data)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_item_add(itc, data)
        eo.__do_end()
        return v
    end,

    item_sorted_insert = function(self, itc, data, func)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_slideshow_item_sorted_insert(itc, data, func)
        eo.__do_end()
        return v
    end,

    __events = {
        ["changed"] = __lib._ELM_SLIDESHOW_EVENT_CHANGED,
        ["transition,end"] = __lib._ELM_SLIDESHOW_EVENT_TRANSITION_END
    },

    __properties = {
        ["transitions"] = { 0, 0, 1, 0, true, false },
        ["timeout"] = { 0, 0, 1, 1, true, true },
        ["loop"] = { 0, 0, 1, 1, true, true },
        ["layout"] = { 0, 0, 1, 1, true, true },
        ["items"] = { 0, 0, 1, 0, true, false },
        ["item_current"] = { 0, 0, 1, 0, true, false },
        ["layouts"] = { 0, 0, 1, 0, true, false },
        ["cache_after"] = { 0, 0, 1, 1, true, true },
        ["count"] = { 0, 0, 1, 0, true, false },
        ["transition"] = { 0, 0, 1, 1, true, true },
        ["cache_before"] = { 0, 0, 1, 1, true, true }
    }
}

M.Slideshow = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Slideshow").__eo_ctor,
                            1, ...)
end

return M
