/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor;

import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorUIConfRepository;

public class MonitorPreferencesContainer
extends JSplitPane
implements Observer {
    private int _rightPanelWidth;

    MonitorPreferencesContainer(JPanel left, JPanel right) {
        super(1);
        this.setBorder(null);
        this.setLeftComponent(left);
        this.setRightComponent(right);
    }

    void hidePreferences() {
        this._rightPanelWidth = this.getDividerLocation();
        this.getRightComponent().setVisible(false);
    }

    void showPreferences() {
        this.getRightComponent().setVisible(true);
        this.setDividerLocation(this._rightPanelWidth);
    }

    void toggle(int width) {
        boolean show;
        boolean bl = show = !this.getRightComponent().isVisible();
        if (!show) {
            FileMonitorUIConfRepository.getUiConf().setPreferencesSize(this.getDividerLocation());
        }
        this.getRightComponent().setVisible(show);
        this.setDividerLocation(show ? FileMonitorUIConfRepository.getUiConf().getPreferencesSize() : width);
    }

    void pack() {
        this.setDividerLocation(FileMonitorUIConfRepository.getUiConf().getDividerLocation());
        this._rightPanelWidth = FileMonitorUIConfRepository.getUiConf().getPreferencesSize();
        this.getRightComponent().setVisible(FileMonitorUIConfRepository.getUiConf().isShowPreferences());
    }

    int getLocationPosition() {
        return this.getRightComponent().isVisible() ? this.getDividerLocation() : this._rightPanelWidth;
    }

    @Override
    public void update(Observer.NOTIFY notify, Object ... params) {
        if (notify == Observer.NOTIFY.START) {
            this.hidePreferences();
        } else if (notify == Observer.NOTIFY.STOP) {
            this.showPreferences();
        } else if (notify == Observer.NOTIFY.TOGGLE) {
            this.toggle((Integer)params[0]);
        } else if (notify == Observer.NOTIFY.CLOSE) {
            boolean visible = this.getRightComponent().isVisible();
            FileMonitorUIConfRepository.getUiConf().setShowPreferences(visible);
            if (visible) {
                FileMonitorUIConfRepository.getUiConf().setPreferencesSize(this.getLocationPosition());
            }
        }
    }
}

