/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetSnapshotsRequest
extends MasterNodeRequest<GetSnapshotsRequest> {
    public static final String ALL_SNAPSHOTS = "_all";
    public static final String CURRENT_SNAPSHOT = "_current";
    private String repository;
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;

    public GetSnapshotsRequest() {
    }

    public GetSnapshotsRequest(String repository, String[] snapshots) {
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public GetSnapshotsRequest(String repository) {
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        return validationException;
    }

    public GetSnapshotsRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public GetSnapshotsRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public GetSnapshotsRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            this.ignoreUnavailable = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeBoolean(this.ignoreUnavailable);
        }
    }
}

