/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.fieldstats.IndexConstraint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public abstract class FieldStats<T extends Comparable<T>>
implements Streamable,
ToXContent {
    private byte type;
    private long maxDoc;
    private long docCount;
    private long sumDocFreq;
    private long sumTotalTermFreq;
    protected T minValue;
    protected T maxValue;

    protected FieldStats() {
    }

    protected FieldStats(int type, long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq) {
        this.type = (byte)type;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumDocFreq = sumDocFreq;
        this.sumTotalTermFreq = sumTotalTermFreq;
    }

    byte getType() {
        return this.type;
    }

    public long getMaxDoc() {
        return this.maxDoc;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public int getDensity() {
        if (this.docCount < 0L || this.maxDoc <= 0L) {
            return -1;
        }
        return (int)(this.docCount * 100L / this.maxDoc);
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public abstract String getMinValueAsString();

    public abstract String getMaxValueAsString();

    protected abstract T valueOf(String var1, String var2);

    public void append(FieldStats stats) {
        this.maxDoc += stats.maxDoc;
        if (stats.docCount == -1L) {
            this.docCount = -1L;
        } else if (this.docCount != -1L) {
            this.docCount += stats.docCount;
        }
        if (stats.sumDocFreq == -1L) {
            this.sumDocFreq = -1L;
        } else if (this.sumDocFreq != -1L) {
            this.sumDocFreq += stats.sumDocFreq;
        }
        if (stats.sumTotalTermFreq == -1L) {
            this.sumTotalTermFreq = -1L;
        } else if (this.sumTotalTermFreq != -1L) {
            this.sumTotalTermFreq += stats.sumTotalTermFreq;
        }
    }

    public boolean match(IndexConstraint constraint) {
        int cmp;
        T value = this.valueOf(constraint.getValue(), constraint.getOptionalFormat());
        if (constraint.getProperty() == IndexConstraint.Property.MIN) {
            cmp = this.minValue.compareTo(value);
        } else if (constraint.getProperty() == IndexConstraint.Property.MAX) {
            cmp = this.maxValue.compareTo(value);
        } else {
            throw new IllegalArgumentException("Unsupported property [" + (Object)((Object)constraint.getProperty()) + "]");
        }
        switch (constraint.getComparison()) {
            case GT: {
                return cmp > 0;
            }
            case GTE: {
                return cmp >= 0;
            }
            case LT: {
                return cmp < 0;
            }
            case LTE: {
                return cmp <= 0;
            }
        }
        throw new IllegalArgumentException("Unsupported comparison [" + (Object)((Object)constraint.getComparison()) + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.MAX_DOC, this.maxDoc);
        builder.field(Fields.DOC_COUNT, this.docCount);
        builder.field(Fields.DENSITY, this.getDensity());
        builder.field(Fields.SUM_DOC_FREQ, this.sumDocFreq);
        builder.field(Fields.SUM_TOTAL_TERM_FREQ, this.sumTotalTermFreq);
        this.toInnerXContent(builder);
        builder.endObject();
        return builder;
    }

    protected void toInnerXContent(XContentBuilder builder) throws IOException {
        builder.field(Fields.MIN_VALUE, (Object)this.getMinValue());
        builder.field(Fields.MIN_VALUE_AS_STRING, this.getMinValueAsString());
        builder.field(Fields.MAX_VALUE, (Object)this.getMaxValue());
        builder.field(Fields.MAX_VALUE_AS_STRING, this.getMaxValueAsString());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.maxDoc = in.readVLong();
        this.docCount = in.readLong();
        this.sumDocFreq = in.readLong();
        this.sumTotalTermFreq = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeVLong(this.maxDoc);
        out.writeLong(this.docCount);
        out.writeLong(this.sumDocFreq);
        out.writeLong(this.sumTotalTermFreq);
    }

    public static FieldStats read(StreamInput in) throws IOException {
        FieldStats stats;
        byte type = in.readByte();
        switch (type) {
            case 0: {
                stats = new Long();
                break;
            }
            case 1: {
                stats = new Float();
                break;
            }
            case 2: {
                stats = new Double();
                break;
            }
            case 3: {
                stats = new Text();
                break;
            }
            case 4: {
                stats = new Date();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type [" + type + "]");
            }
        }
        stats.type = type;
        stats.readFrom(in);
        return stats;
    }

    private static final class Fields {
        static final XContentBuilderString MAX_DOC = new XContentBuilderString("max_doc");
        static final XContentBuilderString DOC_COUNT = new XContentBuilderString("doc_count");
        static final XContentBuilderString DENSITY = new XContentBuilderString("density");
        static final XContentBuilderString SUM_DOC_FREQ = new XContentBuilderString("sum_doc_freq");
        static final XContentBuilderString SUM_TOTAL_TERM_FREQ = new XContentBuilderString("sum_total_term_freq");
        static final XContentBuilderString MIN_VALUE = new XContentBuilderString("min_value");
        static final XContentBuilderString MIN_VALUE_AS_STRING = new XContentBuilderString("min_value_as_string");
        static final XContentBuilderString MAX_VALUE = new XContentBuilderString("max_value");
        static final XContentBuilderString MAX_VALUE_AS_STRING = new XContentBuilderString("max_value_as_string");

        private Fields() {
        }
    }

    public static final class Date
    extends Long {
        private FormatDateTimeFormatter dateFormatter;

        public Date() {
        }

        public Date(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, long minValue, long maxValue, FormatDateTimeFormatter dateFormatter) {
            super(4, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, minValue, maxValue);
            this.dateFormatter = dateFormatter;
        }

        @Override
        public String getMinValueAsString() {
            return this.dateFormatter.printer().print(((java.lang.Long)this.minValue).longValue());
        }

        @Override
        public String getMaxValueAsString() {
            return this.dateFormatter.printer().print(((java.lang.Long)this.maxValue).longValue());
        }

        @Override
        protected java.lang.Long valueOf(String value, String optionalFormat) {
            FormatDateTimeFormatter dateFormatter = this.dateFormatter;
            if (optionalFormat != null) {
                dateFormatter = Joda.forPattern(optionalFormat);
            }
            return dateFormatter.parser().parseMillis(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.dateFormatter = Joda.forPattern(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.dateFormatter.format());
        }
    }

    public static final class Text
    extends FieldStats<BytesRef> {
        public Text() {
        }

        public Text(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, BytesRef minValue, BytesRef maxValue) {
            super(3, maxDoc, docCount, sumDocFreq, sumTotalTermFreq);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public String getMinValueAsString() {
            return ((BytesRef)this.minValue).utf8ToString();
        }

        @Override
        public String getMaxValueAsString() {
            return ((BytesRef)this.maxValue).utf8ToString();
        }

        @Override
        public void append(FieldStats stats) {
            super.append(stats);
            Text other = (Text)stats;
            if (((BytesRef)other.minValue).compareTo((BytesRef)this.minValue) < 0) {
                this.minValue = other.minValue;
            }
            if (((BytesRef)other.maxValue).compareTo((BytesRef)this.maxValue) > 0) {
                this.maxValue = other.maxValue;
            }
        }

        @Override
        protected BytesRef valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return new BytesRef((CharSequence)value);
        }

        @Override
        protected void toInnerXContent(XContentBuilder builder) throws IOException {
            builder.field(Fields.MIN_VALUE, this.getMinValueAsString());
            builder.field(Fields.MAX_VALUE, this.getMaxValueAsString());
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.minValue = in.readBytesRef();
            this.maxValue = in.readBytesRef();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBytesRef((BytesRef)this.minValue);
            out.writeBytesRef((BytesRef)this.maxValue);
        }
    }

    public static final class Double
    extends FieldStats<java.lang.Double> {
        public Double() {
        }

        public Double(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, double minValue, double maxValue) {
            super(2, maxDoc, docCount, sumDocFreq, sumTotalTermFreq);
            this.minValue = java.lang.Double.valueOf(minValue);
            this.maxValue = java.lang.Double.valueOf(maxValue);
        }

        @Override
        public String getMinValueAsString() {
            return String.valueOf((java.lang.Double)this.minValue);
        }

        @Override
        public String getMaxValueAsString() {
            return String.valueOf((java.lang.Double)this.maxValue);
        }

        @Override
        public void append(FieldStats stats) {
            super.append(stats);
            Double other = (Double)stats;
            this.minValue = java.lang.Double.valueOf(Math.min((java.lang.Double)other.minValue, (java.lang.Double)this.minValue));
            this.maxValue = java.lang.Double.valueOf(Math.max((java.lang.Double)other.maxValue, (java.lang.Double)this.maxValue));
        }

        @Override
        protected java.lang.Double valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return java.lang.Double.valueOf(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.minValue = java.lang.Double.valueOf(in.readDouble());
            this.maxValue = java.lang.Double.valueOf(in.readDouble());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble((java.lang.Double)this.minValue);
            out.writeDouble((java.lang.Double)this.maxValue);
        }
    }

    public static final class Float
    extends FieldStats<java.lang.Float> {
        public Float() {
        }

        public Float(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, float minValue, float maxValue) {
            super(1, maxDoc, docCount, sumDocFreq, sumTotalTermFreq);
            this.minValue = java.lang.Float.valueOf(minValue);
            this.maxValue = java.lang.Float.valueOf(maxValue);
        }

        @Override
        public String getMinValueAsString() {
            return String.valueOf(((java.lang.Float)this.minValue).floatValue());
        }

        @Override
        public String getMaxValueAsString() {
            return String.valueOf(((java.lang.Float)this.maxValue).floatValue());
        }

        @Override
        public void append(FieldStats stats) {
            super.append(stats);
            Float other = (Float)stats;
            this.minValue = java.lang.Float.valueOf(Math.min(((java.lang.Float)other.minValue).floatValue(), ((java.lang.Float)this.minValue).floatValue()));
            this.maxValue = java.lang.Float.valueOf(Math.max(((java.lang.Float)other.maxValue).floatValue(), ((java.lang.Float)this.maxValue).floatValue()));
        }

        @Override
        protected java.lang.Float valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return java.lang.Float.valueOf(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.minValue = java.lang.Float.valueOf(in.readFloat());
            this.maxValue = java.lang.Float.valueOf(in.readFloat());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeFloat(((java.lang.Float)this.minValue).floatValue());
            out.writeFloat(((java.lang.Float)this.maxValue).floatValue());
        }
    }

    public static class Long
    extends FieldStats<java.lang.Long> {
        public Long() {
        }

        public Long(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, long minValue, long maxValue) {
            this(0, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, minValue, maxValue);
        }

        protected Long(int type, long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, long minValue, long maxValue) {
            super(type, maxDoc, docCount, sumDocFreq, sumTotalTermFreq);
            this.minValue = java.lang.Long.valueOf(minValue);
            this.maxValue = java.lang.Long.valueOf(maxValue);
        }

        @Override
        public String getMinValueAsString() {
            return String.valueOf((java.lang.Long)this.minValue);
        }

        @Override
        public String getMaxValueAsString() {
            return String.valueOf((java.lang.Long)this.maxValue);
        }

        @Override
        public void append(FieldStats stats) {
            super.append(stats);
            Long other = (Long)stats;
            this.minValue = java.lang.Long.valueOf(Math.min((java.lang.Long)other.minValue, (java.lang.Long)this.minValue));
            this.maxValue = java.lang.Long.valueOf(Math.max((java.lang.Long)other.maxValue, (java.lang.Long)this.maxValue));
        }

        @Override
        protected java.lang.Long valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return java.lang.Long.valueOf(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.minValue = java.lang.Long.valueOf(in.readLong());
            this.maxValue = java.lang.Long.valueOf(in.readLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong((java.lang.Long)this.minValue);
            out.writeLong((java.lang.Long)this.maxValue);
        }
    }
}

