/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.util.Callback;

public class HelpPrinter {
    private static final String HELP_FILE_EXT = ".help";

    public void print(CliToolConfig config, Terminal terminal) {
        HelpPrinter.print(config.toolType(), config.name(), terminal);
    }

    public void print(String toolName, CliToolConfig.Cmd cmd, Terminal terminal) {
        HelpPrinter.print(cmd.cmdType(), toolName + "-" + cmd.name(), terminal);
    }

    private static void print(Class clazz, String name, final Terminal terminal) {
        terminal.println(Terminal.Verbosity.SILENT);
        try (InputStream input = clazz.getResourceAsStream(name + HELP_FILE_EXT);){
            Streams.readAllLines(input, new Callback<String>(){

                @Override
                public void handle(String line) {
                    terminal.println(Terminal.Verbosity.SILENT, line, new Object[0]);
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace(terminal.writer());
        }
        terminal.println();
    }
}

