/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceRangeQuery;
import org.apache.lucene.spatial.util.GeoDistanceUtils;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.GeoDistanceQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.geo.GeoDistanceRangeQuery;

public class GeoDistanceRangeQueryParser
implements QueryParser {
    public static final String NAME = "geo_distance_range";
    protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(BaseGeoPointFieldMapper.class));

    @Inject
    public GeoDistanceRangeQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoDistanceRange"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        GeoDistanceRangeQuery query;
        MappedFieldType fieldType;
        Double to;
        Double from;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint();
        String fieldName = null;
        Object vFrom = null;
        Object vTo = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        String optimizeBbox = "memory";
        boolean indexCreatedBeforeV2_0 = parseContext.indexVersionCreated().before(Version.V_2_0_0);
        boolean indexCreatedBeforeV2_2 = parseContext.indexVersionCreated().before(Version.V_2_2_0);
        boolean coerce = false;
        boolean ignoreMalformed = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                GeoUtils.parseGeoPoint(parser, point);
                fieldName = currentFieldName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                GeoUtils.parseGeoPoint(parser, point);
                continue;
            }
            if (!token.isValue()) continue;
            if (currentFieldName.equals("from")) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vFrom = parser.text();
                    continue;
                }
                vFrom = parser.numberValue();
                continue;
            }
            if (currentFieldName.equals("to")) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vTo = parser.text();
                    continue;
                }
                vTo = parser.numberValue();
                continue;
            }
            if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if ("gt".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = false;
                continue;
            }
            if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = true;
                continue;
            }
            if ("lt".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = false;
                continue;
            }
            if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = true;
                continue;
            }
            if (currentFieldName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentFieldName.equals("distance_type") || currentFieldName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser.doubleValue());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, GeoDistanceQueryParser.OPTIMIZE_BBOX_FIELD)) {
                if (indexCreatedBeforeV2_2) {
                    optimizeBbox = parser.textOrNull();
                    continue;
                }
                deprecationLogger.deprecated("geo_distance_range parameter [{}] is deprecated", GeoDistanceQueryParser.OPTIMIZE_BBOX_FIELD);
                continue;
            }
            if ("coerce".equals(currentFieldName) || indexCreatedBeforeV2_0 && "normalize".equals(currentFieldName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if ("ignore_malformed".equals(currentFieldName) && !coerce) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            point.resetFromString(parser.text());
            fieldName = currentFieldName;
        }
        if (!indexCreatedBeforeV2_0 && !ignoreMalformed) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new QueryParsingException(parseContext, "illegal latitude value [{}] for [{}]", point.lat(), NAME);
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new QueryParsingException(parseContext, "illegal longitude value [{}] for [{}]", point.lon(), NAME);
            }
        }
        if (!indexCreatedBeforeV2_2 || coerce) {
            GeoUtils.normalizePoint(point, coerce, coerce);
        }
        if (vFrom != null) {
            from = vFrom instanceof Number ? Double.valueOf(unit.toMeters(((Number)vFrom).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vFrom, unit, DistanceUnit.DEFAULT));
            if (indexCreatedBeforeV2_2) {
                from = geoDistance.normalize(from, DistanceUnit.DEFAULT);
            }
        } else {
            from = new Double(0.0);
        }
        if (vTo != null) {
            to = vTo instanceof Number ? Double.valueOf(unit.toMeters(((Number)vTo).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)vTo, unit, DistanceUnit.DEFAULT));
            if (indexCreatedBeforeV2_2) {
                to = geoDistance.normalize(to, DistanceUnit.DEFAULT);
            }
        } else {
            to = GeoDistanceUtils.maxRadialDistanceMeters((double)point.lon(), (double)point.lat());
        }
        if ((fieldType = parseContext.fieldMapper(fieldName)) == null) {
            throw new QueryParsingException(parseContext, "failed to find geo_point field [" + fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryParsingException(parseContext, "field [" + fieldName + "] is not a geo_point field", new Object[0]);
        }
        BaseGeoPointFieldMapper.GeoPointFieldType geoFieldType = (BaseGeoPointFieldMapper.GeoPointFieldType)fieldType;
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(fieldType);
        if (from == null) {
            from = new Double(0.0);
        }
        if (to == null) {
            to = new Double(SloppyMath.haversin((double)point.lat(), (double)point.lon(), (double)point.lat(), (double)((180.0 + point.lon()) % 360.0))) * 1000.0;
        }
        if (indexCreatedBeforeV2_2) {
            query = new GeoDistanceRangeQuery(point, from, to, includeLower, includeUpper, geoDistance, geoFieldType, indexFieldData, optimizeBbox);
        } else {
            GeoPointField.TermEncoding encoding = parseContext.indexVersionCreated().before(Version.V_2_3_0) ? GeoPointField.TermEncoding.NUMERIC : GeoPointField.TermEncoding.PREFIX;
            query = new GeoPointDistanceRangeQuery(indexFieldData.getFieldNames().indexName(), encoding, point.lon(), point.lat(), includeLower ? from : from + 1.0E-6, includeUpper ? to : to - 1.0E-6);
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

