/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.AcknowledgedRestListener;

public class RestIndicesAliasesAction
extends BaseRestHandler {
    @Inject
    public RestIndicesAliasesAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        try (XContentParser parser = XContentFactory.xContent(request.content()).createParser(request.content());){
            indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                throw new IllegalArgumentException("No action is specified");
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.START_ARRAY) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    AliasAction.Type type;
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    String action = parser.currentName();
                    if ("add".equals(action)) {
                        type = AliasAction.Type.ADD;
                    } else if ("remove".equals(action)) {
                        type = AliasAction.Type.REMOVE;
                    } else {
                        throw new IllegalArgumentException("Alias action [" + action + "] not supported");
                    }
                    String[] indices = null;
                    String[] aliases = null;
                    Map<String, Object> filter = null;
                    String routing = null;
                    boolean routingSet = false;
                    String indexRouting = null;
                    boolean indexRoutingSet = false;
                    String searchRouting = null;
                    boolean searchRoutingSet = false;
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if ("index".equals(currentFieldName)) {
                                indices = new String[]{parser.text()};
                                continue;
                            }
                            if ("alias".equals(currentFieldName)) {
                                aliases = new String[]{parser.text()};
                                continue;
                            }
                            if ("routing".equals(currentFieldName)) {
                                routing = parser.textOrNull();
                                routingSet = true;
                                continue;
                            }
                            if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                                indexRouting = parser.textOrNull();
                                indexRoutingSet = true;
                                continue;
                            }
                            if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                            searchRouting = parser.textOrNull();
                            searchRoutingSet = true;
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if ("indices".equals(currentFieldName)) {
                                ArrayList<String> indexNames = new ArrayList<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    String index = parser.text();
                                    indexNames.add(index);
                                }
                                indices = indexNames.toArray(new String[indexNames.size()]);
                            }
                            if (!"aliases".equals(currentFieldName)) continue;
                            ArrayList<String> aliasNames = new ArrayList<String>();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                String alias = parser.text();
                                aliasNames.add(alias);
                            }
                            aliases = aliasNames.toArray(new String[aliasNames.size()]);
                            continue;
                        }
                        if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                        filter = parser.mapOrdered();
                    }
                    if (type == AliasAction.Type.ADD) {
                        IndicesAliasesRequest.AliasActions aliasActions = new IndicesAliasesRequest.AliasActions(type, indices, aliases).filter(filter);
                        if (routingSet) {
                            aliasActions.routing(routing);
                        }
                        if (indexRoutingSet) {
                            aliasActions.indexRouting(indexRouting);
                        }
                        if (searchRoutingSet) {
                            aliasActions.searchRouting(searchRouting);
                        }
                        indicesAliasesRequest.addAliasAction(aliasActions);
                        continue;
                    }
                    if (type != AliasAction.Type.REMOVE) continue;
                    indicesAliasesRequest.removeAlias(indices, aliases);
                }
            }
        }
        client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestListener<IndicesAliasesResponse>(channel));
    }
}

