/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestAnalyzeAction
extends BaseRestHandler {
    @Inject
    public RestAnalyzeAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_analyze", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String[] texts = request.paramAsStringArrayOrEmptyIfAll("text");
        AnalyzeRequest analyzeRequest = new AnalyzeRequest(request.param("index"));
        analyzeRequest.text(texts);
        analyzeRequest.analyzer(request.param("analyzer"));
        analyzeRequest.field(request.param("field"));
        analyzeRequest.tokenizer(request.param("tokenizer"));
        analyzeRequest.tokenFilters(request.paramAsStringArray("filter", request.paramAsStringArray("token_filter", request.paramAsStringArray("token_filters", request.paramAsStringArray("filters", analyzeRequest.tokenFilters())))));
        analyzeRequest.charFilters(request.paramAsStringArray("char_filter", request.paramAsStringArray("char_filters", analyzeRequest.charFilters())));
        analyzeRequest.explain(request.paramAsBoolean("explain", false));
        analyzeRequest.attributes(request.paramAsStringArray("attributes", analyzeRequest.attributes()));
        if (RestActions.hasBodyContent(request)) {
            XContentType type = RestActions.guessBodyContentType(request);
            if (type == null) {
                if (texts == null || texts.length == 0) {
                    texts = new String[]{RestActions.getRestContent(request).toUtf8()};
                    analyzeRequest.text(texts);
                }
            } else {
                RestAnalyzeAction.buildFromContent(RestActions.getRestContent(request), analyzeRequest, this.parseFieldMatcher);
            }
        }
        client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeResponse>(channel));
    }

    public static void buildFromContent(BytesReference content, AnalyzeRequest analyzeRequest, ParseFieldMatcher parseFieldMatcher) {
        try (XContentParser parser = XContentHelper.createParser(content);){
            XContentParser.Token token;
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Malforrmed content, must start with an object");
            }
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.TEXT) && token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.text(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.TEXT) && token == XContentParser.Token.START_ARRAY) {
                    ArrayList<String> texts = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException(currentFieldName + " array element should only contain text");
                        }
                        texts.add(parser.text());
                    }
                    analyzeRequest.text(texts.toArray(new String[texts.size()]));
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.ANALYZER) && token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.analyzer(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.FIELD) && token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.field(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.TOKENIZER) && token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.tokenizer(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.TOKEN_FILTERS) && token == XContentParser.Token.START_ARRAY) {
                    ArrayList<String> filters = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException(currentFieldName + " array element should only contain token filter's name");
                        }
                        filters.add(parser.text());
                    }
                    analyzeRequest.tokenFilters(filters.toArray(new String[filters.size()]));
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.CHAR_FILTERS) && token == XContentParser.Token.START_ARRAY) {
                    ArrayList<String> charFilters = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException(currentFieldName + " array element should only contain char filter's name");
                        }
                        charFilters.add(parser.text());
                    }
                    analyzeRequest.charFilters(charFilters.toArray(new String[charFilters.size()]));
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.EXPLAIN)) {
                    if (parser.isBooleanValue()) {
                        analyzeRequest.explain(parser.booleanValue());
                        continue;
                    }
                    throw new IllegalArgumentException(currentFieldName + " must be either 'true' or 'false'");
                }
                if (parseFieldMatcher.match(currentFieldName, Fields.ATTRIBUTES) && token == XContentParser.Token.START_ARRAY) {
                    ArrayList<String> attributes = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException(currentFieldName + " array element should only contain attribute name");
                        }
                        attributes.add(parser.text());
                    }
                    analyzeRequest.attributes(attributes.toArray(new String[attributes.size()]));
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse request body", e);
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField TOKENIZER = new ParseField("tokenizer", new String[0]);
        public static final ParseField TOKEN_FILTERS = new ParseField("filter", "token_filter", "token_filters", "filters");
        public static final ParseField CHAR_FILTERS = new ParseField("char_filter", "char_filters");
        public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
    }
}

