/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class UnmappedSignificantTerms
extends InternalSignificantTerms<UnmappedSignificantTerms, InternalSignificantTerms.Bucket> {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "umsigterms");
    private static final List<InternalSignificantTerms.Bucket> BUCKETS = Collections.emptyList();
    private static final Map<String, InternalSignificantTerms.Bucket> BUCKETS_MAP = Collections.emptyMap();
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public UnmappedSignificantTerms readResult(StreamInput in) throws IOException {
            UnmappedSignificantTerms buckets = new UnmappedSignificantTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    UnmappedSignificantTerms() {
    }

    public UnmappedSignificantTerms(String name, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(0L, 0L, name, requiredSize, minDocCount, JLHScore.INSTANCE, BUCKETS, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public UnmappedSignificantTerms create(List<InternalSignificantTerms.Bucket> buckets) {
        return new UnmappedSignificantTerms(this.name, this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public InternalSignificantTerms.Bucket createBucket(InternalAggregations aggregations, InternalSignificantTerms.Bucket prototype) {
        throw new UnsupportedOperationException("not supported for UnmappedSignificantTerms");
    }

    @Override
    protected UnmappedSignificantTerms create(long subsetSize, long supersetSize, List<InternalSignificantTerms.Bucket> buckets, InternalSignificantTerms prototype) {
        throw new UnsupportedOperationException("not supported for UnmappedSignificantTerms");
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation aggregation : aggregations) {
            if (aggregation instanceof UnmappedSignificantTerms) continue;
            return aggregation.reduce(aggregations, reduceContext);
        }
        return this;
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.requiredSize = UnmappedSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.buckets = BUCKETS;
        this.bucketMap = BUCKETS_MAP;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        UnmappedSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(InternalAggregation.CommonFields.BUCKETS).endArray();
        return builder;
    }
}

