/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder {
    private Script script;
    @Deprecated
    private String scriptString;
    private final String type;
    @Deprecated
    private String lang;
    @Deprecated
    private Map<String, Object> params;
    private SortOrder order;
    private String sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;

    public ScriptSortBuilder(Script script, String type) {
        this.script = script;
        this.type = type;
    }

    @Deprecated
    public ScriptSortBuilder(String script, String type) {
        this.scriptString = script;
        this.type = type;
    }

    @Deprecated
    public ScriptSortBuilder param(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
        return this;
    }

    @Deprecated
    public ScriptSortBuilder setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Deprecated
    public ScriptSortBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public ScriptSortBuilder order(SortOrder order) {
        this.order = order;
        return this;
    }

    @Override
    public SortBuilder missing(Object missing) {
        return this;
    }

    public ScriptSortBuilder sortMode(String sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    public ScriptSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public ScriptSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject("_script");
        if (this.script == null) {
            builder.field("script", new Script(this.scriptString, ScriptService.ScriptType.INLINE, this.lang, this.params));
        } else {
            builder.field("script", this.script);
        }
        builder.field("type", this.type);
        if (this.order == SortOrder.DESC) {
            builder.field("order", "desc");
        }
        if (this.sortMode != null) {
            builder.field("mode", this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field("nested_path", this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field("nested_filter", this.nestedFilter, builderParams);
        }
        builder.endObject();
        return builder;
    }
}

