/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.File;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyXmlModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.CachedModuleDescriptorParseContext;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultIvyModuleResolveMetaData;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;

public class ModuleDescriptorStore {
    public static final String FILE_PATH_PATTERN = "%s/%s/%s/%s/ivy.xml";
    private final IvyXmlModuleDescriptorParser descriptorParser;
    private final PathKeyFileStore metaDataStore;
    private final IvyModuleDescriptorWriter descriptorWriter;

    public ModuleDescriptorStore(PathKeyFileStore metaDataStore, IvyModuleDescriptorWriter descriptorWriter, IvyXmlModuleDescriptorParser ivyXmlModuleDescriptorParser) {
        this.metaDataStore = metaDataStore;
        this.descriptorWriter = descriptorWriter;
        this.descriptorParser = ivyXmlModuleDescriptorParser;
    }

    public ModuleDescriptor getModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        String filePath = this.getFilePath(repository, moduleComponentIdentifier);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            return this.parseModuleDescriptorFile(resource.getFile());
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier, final ModuleDescriptor moduleDescriptor) {
        String filePath = this.getFilePath(repository, moduleComponentIdentifier);
        return this.metaDataStore.add(filePath, (Action)new Action<File>(){

            public void execute(File moduleDescriptorFile) {
                try {
                    ModuleDescriptorStore.this.descriptorWriter.write(moduleDescriptor, moduleDescriptorFile);
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
    }

    private ModuleDescriptor parseModuleDescriptorFile(File moduleDescriptorFile) {
        CachedModuleDescriptorParseContext parserSettings = new CachedModuleDescriptorParseContext();
        return ((DefaultIvyModuleResolveMetaData)this.descriptorParser.parseMetaData(parserSettings, moduleDescriptorFile, false)).getDescriptor();
    }

    private String getFilePath(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        return moduleComponentIdentifier.getGroup() + "/" + moduleComponentIdentifier.getModule() + "/" + moduleComponentIdentifier.getVersion() + "/" + repository.getId() + "/ivy.xml";
    }
}

