/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import say.swing.JFontChooser;

public class JadxSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1804570470377354148L;
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsWindow.class);
    private final MainWindow mainWindow;
    private final JadxSettings settings;
    private final String startSettings;
    private boolean needReload = false;

    public JadxSettingsWindow(MainWindow mainWindow, JadxSettings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.startSettings = JadxSettingsAdapter.makeString(settings);
        this.initUI();
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 10, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.makeDeobfuscationGroup());
        panel.add(this.makeOtherGroup());
        JButton saveBtn = new JButton(NLS.str("preferences.save"));
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JadxSettingsWindow.this.settings.sync();
                if (JadxSettingsWindow.this.needReload) {
                    JadxSettingsWindow.this.mainWindow.reOpenFile();
                }
                JadxSettingsWindow.this.dispose();
            }
        });
        JButton cancelButton = new JButton(NLS.str("preferences.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JadxSettingsAdapter.fill(JadxSettingsWindow.this.settings, JadxSettingsWindow.this.startSettings);
                JadxSettingsWindow.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.getRootPane().setDefaultButton(saveBtn);
        this.setTitle(NLS.str("preferences.title"));
        this.setSize(400, 550);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
    }

    private SettingsGroup makeDeobfuscationGroup() {
        JCheckBox deobfOn = new JCheckBox();
        deobfOn.setSelected(this.settings.isDeobfuscationOn());
        deobfOn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setDeobfuscationOn(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        JCheckBox deobfForce = new JCheckBox();
        deobfForce.setSelected(this.settings.isDeobfuscationForceSave());
        deobfForce.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setDeobfuscationForceSave(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        final JSpinner minLen = new JSpinner();
        minLen.setValue(this.settings.getDeobfuscationMinLength());
        minLen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JadxSettingsWindow.this.settings.setDeobfuscationMinLength((Integer)minLen.getValue());
                JadxSettingsWindow.this.needReload();
            }
        });
        final JSpinner maxLen = new JSpinner();
        maxLen.setValue(this.settings.getDeobfuscationMaxLength());
        maxLen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JadxSettingsWindow.this.settings.setDeobfuscationMaxLength((Integer)maxLen.getValue());
                JadxSettingsWindow.this.needReload();
            }
        });
        SettingsGroup deobfGroup = new SettingsGroup(NLS.str("preferences.deobfuscation"));
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_on"), deobfOn);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_force"), deobfForce);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_min_len"), minLen);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_max_len"), maxLen);
        deobfGroup.end();
        return deobfGroup;
    }

    private SettingsGroup makeOtherGroup() {
        JCheckBox update = new JCheckBox();
        update.setSelected(this.settings.isCheckForUpdates());
        update.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setCheckForUpdates(e.getStateChange() == 1);
            }
        });
        JCheckBox fallback = new JCheckBox();
        fallback.setSelected(this.settings.isFallbackMode());
        fallback.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setFallbackMode(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        JCheckBox showInconsistentCode = new JCheckBox();
        showInconsistentCode.setSelected(this.settings.isShowInconsistentCode());
        showInconsistentCode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setShowInconsistentCode(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        JCheckBox resourceDecode = new JCheckBox();
        resourceDecode.setSelected(this.settings.isSkipResources());
        resourceDecode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setSkipResources(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        final JSpinner threadsCount = new JSpinner();
        threadsCount.setValue(this.settings.getThreadsCount());
        threadsCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JadxSettingsWindow.this.settings.setThreadsCount((Integer)threadsCount.getValue());
            }
        });
        JCheckBox cfg = new JCheckBox();
        cfg.setSelected(this.settings.isCFGOutput());
        cfg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setCfgOutput(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        JCheckBox rawCfg = new JCheckBox();
        rawCfg.setSelected(this.settings.isRawCFGOutput());
        rawCfg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JadxSettingsWindow.this.settings.setRawCfgOutput(e.getStateChange() == 1);
                JadxSettingsWindow.this.needReload();
            }
        });
        JButton fontBtn = new JButton(NLS.str("preferences.select_font"));
        fontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFontChooser fontChooser = new JFontChooser();
                fontChooser.setSelectedFont(JadxSettingsWindow.this.settings.getFont());
                int result = fontChooser.showDialog((Component)JadxSettingsWindow.this);
                if (result == 0) {
                    Font font = fontChooser.getSelectedFont();
                    LOG.info("Selected Font : {}", (Object)font);
                    JadxSettingsWindow.this.settings.setFont(font);
                    JadxSettingsWindow.this.mainWindow.updateFont(font);
                }
            }
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.other"));
        other.addRow(NLS.str("preferences.check_for_updates"), update);
        other.addRow(NLS.str("preferences.threads"), threadsCount);
        other.addRow(NLS.str("preferences.fallback"), fallback);
        other.addRow(NLS.str("preferences.showInconsistentCode"), showInconsistentCode);
        other.addRow(NLS.str("preferences.skipResourcesDecode"), resourceDecode);
        other.addRow(NLS.str("preferences.cfg"), cfg);
        other.addRow(NLS.str("preferences.raw_cfg"), rawCfg);
        other.addRow(NLS.str("preferences.font"), fontBtn);
        return other;
    }

    private void needReload() {
        this.needReload = true;
    }

    private static class SettingsGroup
    extends JPanel {
        private static final long serialVersionUID = -6487309975896192544L;
        private final GridBagConstraints c;
        private int row;

        public SettingsGroup(String title) {
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.insets = new Insets(5, 5, 5, 5);
            this.c.weighty = 1.0;
        }

        public void addRow(String label, JComponent comp) {
            this.c.gridy = this.row++;
            JLabel jLabel = new JLabel(label);
            jLabel.setLabelFor(comp);
            jLabel.setHorizontalAlignment(2);
            this.c.gridx = 0;
            this.c.gridwidth = 1;
            this.c.anchor = 21;
            this.c.weightx = 0.8;
            this.c.fill = 0;
            this.add((Component)jLabel, this.c);
            this.c.gridx = 1;
            this.c.gridwidth = 0;
            this.c.anchor = 10;
            this.c.weightx = 0.2;
            this.c.fill = 2;
            this.add((Component)comp, this.c);
        }

        public void end() {
            this.add(Box.createVerticalGlue());
        }
    }
}

