/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED_FOCUS = new Color(-7361793);
    public static final Color BGCOLOR_SELECTED = new Color(-5258497);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void setBackgroundReadable(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl, boolean bl2, boolean bl3) {
        Color color = UIManager.getColor("Table.background");
        if (!tagTableModel.hasTag(string) && tagTableModel.isCurrentPointInTime() || !tagTableModel.oppositeHasTag(string) && tagTableModel.isReferencePointInTime()) {
            color = TwoColumnDiff.Item.DiffItemType.DELETED.getColor();
        } else if (!tagTableModel.oppositeHasTag(string) && tagTableModel.isCurrentPointInTime() || !tagTableModel.hasTag(string) && tagTableModel.isReferencePointInTime()) {
            color = TwoColumnDiff.Item.DiffItemType.INSERTED.getColor();
        } else if (bl3 && tagTableModel.hasTag(string) && tagTableModel.oppositeHasTag(string) && !tagTableModel.hasSameValueAsOpposite(string)) {
            color = TwoColumnDiff.Item.DiffItemType.CHANGED.getColor();
        }
        if (bl) {
            color = bl2 ? BGCOLOR_SELECTED_FOCUS : BGCOLOR_SELECTED;
        }
        GuiHelper.setBackgroundReadable(this, color);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        String string = (String)object;
        HistoryBrowserModel.TagTableModel tagTableModel = this.getTagTableModel(jTable);
        String string2 = "";
        if (tagTableModel.hasTag(string)) {
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                case 1: {
                    string2 = tagTableModel.getValue(string);
                    break;
                }
            }
        }
        this.setText(string2);
        this.setToolTipText(string2);
        this.setBackgroundReadable(string, tagTableModel, bl, jTable.hasFocus(), n2 == 1);
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable jTable) {
        return (HistoryBrowserModel.TagTableModel)jTable.getModel();
    }
}

