/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T runWithCheckCanceled(final @NotNull Computable<T> computable, @NotNull ProgressIndicator indicator) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        try {
            return ApplicationUtil.runWithCheckCanceled(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return computable.compute();
                }
            }, indicator);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T runWithCheckCanceled(final @NotNull Callable<T> callable, final @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        final Ref result2 = Ref.create();
        final Ref error = Ref.create();
        Future<?> future = PooledThreadExecutor.INSTANCE.submit(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result2.set(callable.call());
                        }
                        catch (Throwable t) {
                            error.set(t);
                        }
                    }
                }, indicator);
            }
        });
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                future.cancel(true);
                throw e;
            }
            try {
                future.get(200L, TimeUnit.MILLISECONDS);
                ExceptionUtil.rethrowAll((Throwable)error.get());
                return result2.get();
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }
}

