/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.io.ExtensionFileFilter;

public class TextInputFormat
implements InputFormat {
    private TextHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private boolean isMultiline;

    public TextInputFormat(TextHolderFigure textHolderFigure) {
        this(textHolderFigure, "Text", "Text", "txt", false);
    }

    public TextInputFormat(TextHolderFigure textHolderFigure, String string, String string2, String string3, boolean bl) {
        this.prototype = textHolderFigure;
        this.formatName = string;
        this.description = string2;
        this.fileExtension = string3;
        this.isMultiline = bl;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    @Override
    public void read(File file, Drawing drawing, boolean bl) throws IOException {
        this.read(new FileInputStream(file), drawing, bl);
    }

    @Override
    public void read(InputStream inputStream, Drawing drawing, boolean bl) throws IOException {
        if (bl) {
            drawing.removeAllChildren();
        }
        drawing.basicAddAll(0, this.createTextHolderFigures(inputStream));
    }

    public LinkedList<Figure> createTextHolderFigures(InputStream inputStream) throws IOException {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        if (this.isMultiline) {
            TextHolderFigure textHolderFigure = (TextHolderFigure)this.prototype.clone();
            StringBuilder stringBuilder = new StringBuilder();
            Object object = null;
            while (object != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append((String)object);
                object = bufferedReader.readLine();
            }
            textHolderFigure.setText(stringBuilder.toString());
            object = textHolderFigure.getPreferredSize();
            textHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(((Dimension2DDouble)object).width, ((Dimension2DDouble)object).height));
        } else {
            double d = 0.0;
            String string = null;
            while (string != null) {
                TextHolderFigure textHolderFigure = (TextHolderFigure)this.prototype.clone();
                textHolderFigure.setText(string);
                Dimension2DDouble dimension2DDouble = textHolderFigure.getPreferredSize();
                textHolderFigure.setBounds(new Point2D.Double(0.0, d), new Point2D.Double(dimension2DDouble.width, dimension2DDouble.height));
                linkedList.add(textHolderFigure);
                d += dimension2DDouble.height;
                string = bufferedReader.readLine();
            }
        }
        if (linkedList.size() == 0) {
            throw new IOException("No text found");
        }
        return linkedList;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public void read(Transferable transferable, Drawing drawing, boolean bl) throws UnsupportedFlavorException, IOException {
        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        LinkedList<TextHolderFigure> linkedList = new LinkedList<TextHolderFigure>();
        if (this.isMultiline) {
            TextHolderFigure textHolderFigure = (TextHolderFigure)this.prototype.clone();
            textHolderFigure.setText(string);
            Dimension2DDouble dimension2DDouble = textHolderFigure.getPreferredSize();
            textHolderFigure.willChange();
            textHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(dimension2DDouble.width, dimension2DDouble.height));
            textHolderFigure.changed();
            linkedList.add(textHolderFigure);
        } else {
            double d = 0.0;
            for (String string2 : string.split("\n")) {
                TextHolderFigure textHolderFigure = (TextHolderFigure)this.prototype.clone();
                textHolderFigure.setText(string2);
                Dimension2DDouble dimension2DDouble = textHolderFigure.getPreferredSize();
                textHolderFigure.willChange();
                textHolderFigure.setBounds(new Point2D.Double(0.0, 0.0 + (d += dimension2DDouble.height)), new Point2D.Double(dimension2DDouble.width, dimension2DDouble.height + d));
                textHolderFigure.changed();
                linkedList.add(textHolderFigure);
            }
        }
        if (bl) {
            drawing.removeAllChildren();
        }
        drawing.addAll(linkedList);
    }
}

