__name = 'Fix Display'
__author = 'Bill Good'
__version = '.01'
__blurb = 'Makes the main window\'s song display a little more intuitive.'
__class = 'Plugin'

import os.path

class Plugin:
    class Blank:
        pass
    def _init(self, data, get):
        self.data = data
        self.xml = self.data[0]
        self.mpd = self.data[2]
        self.first_time = True
        self.r1 = self.xml.get_widget('label2')
        self.r2 = self.Blank()
        self.r2.lfrom = self.xml.get_widget('label3')
        self.r2.album = self.xml.get_widget('albumLabel')
        self.r2.by = self.xml.get_widget('label4')
        self.r2.artist = self.xml.get_widget('artistLabel')
        return None

    def _spin(self, data, changed=False):
#        if changed: print 'changed'
        if self.first_time:
            changed = True
            self.first_time = False
        if changed is True:
            song = self.mpd.getCurrentSong()
            title = song.title
            album = song.album
            artist = song.artist
            if album.strip() == '':
#                print "'%s'" % (album)
                album = None
            if artist.strip() == '':
                artist = None
            if title.strip() == '':
                title = os.path.basename(song.file)
            self.set_r1(title)
            self.set_r2(album, artist)
        return None

    def _conf(self, has_dia=None):
        return False

    def _unload(self):
        for x in (self.r2.lfrom, self.r2.album, self.r2.by, self.r2.artist):
            x.show()
        del self

    def set_r1(self, s):
        '''Set row 1 to str(s).'''
        s = s.replace('<', '&lt;').replace('>', '&gt;').replace('&', '&amp;')
        self.r1.set_markup('<b><span size="xx-large">%s</span></b>' % s)
        return

    def set_r2(self, album=None, artist=None):
        '''Set album and artist fields.
        If either is None, hide respective labels.'''
        if album is None:
            self.r2.lfrom.hide()
            self.r2.album.hide()
        else:
            self.r2.lfrom.show()
            self.r2.album.set_markup("<b><span size='large'>%s</span></b>"%album)
            self.r2.album.show()
        if artist is None:
            self.r2.by.hide()
            self.r2.artist.hide()
        else:
            self.r2.by.show()
            self.r2.artist.set_markup("<b><span size='large'>%s</span></b>"%artist)
            self.r2.artist.show()
        return

