/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.jts;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;

public class Jts2iox {
    private Jts2iox() {
    }

    public static IomObject hexwkb2coord(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jts2iox.JTS2coord(geom.getCoordinate());
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject hexwkb2polyline(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jts2iox.JTS2polyline((LineString)geom);
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject hexwkb2surface(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jts2iox.JTS2surface((Polygon)geom);
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject JTS2coord(Coordinate value) {
        Iom_jObject ret = new Iom_jObject("COORD", null);
        ret.setattrvalue("C1", Double.toString(value.x));
        ret.setattrvalue("C2", Double.toString(value.y));
        if (!Double.isNaN(value.z)) {
            ret.setattrvalue("C3", Double.toString(value.z));
        }
        return ret;
    }

    public static IomObject JTS2polyline(LineString value) {
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        int coordc = value.getNumPoints();
        int coordi = 0;
        while (coordi < coordc) {
            sequence.addattrobj("segment", Jts2iox.JTS2coord(value.getCoordinateN(coordi)));
            ++coordi;
        }
        return ret;
    }

    public static IomObject JTS2surface(Polygon value) {
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        Iom_jObject surface = new Iom_jObject("SURFACE", null);
        ret.addattrobj("surface", surface);
        LineString shell = value.getExteriorRing();
        Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
        surface.addattrobj("boundary", boundary);
        boundary.addattrobj("polyline", Jts2iox.JTS2polyline(shell));
        int holec = value.getNumInteriorRing();
        int holei = 0;
        while (holei < holec) {
            LineString hole = value.getInteriorRingN(holei);
            Iom_jObject boundary2 = new Iom_jObject("BOUNDARY", null);
            surface.addattrobj("boundary", boundary2);
            boundary2.addattrobj("polyline", Jts2iox.JTS2polyline(hole));
            ++holei;
        }
        return ret;
    }
}

