/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator.stats;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class PercolateStats
implements Streamable,
ToXContent {
    private long percolateCount;
    private long percolateTimeInMillis;
    private long current;
    private long memorySizeInBytes = -1L;
    private long numQueries;

    public PercolateStats() {
    }

    PercolateStats(long percolateCount, long percolateTimeInMillis, long current, long memorySizeInBytes, long numQueries) {
        this.percolateCount = percolateCount;
        this.percolateTimeInMillis = percolateTimeInMillis;
        this.current = current;
        this.memorySizeInBytes = memorySizeInBytes;
        this.numQueries = numQueries;
    }

    public long getCount() {
        return this.percolateCount;
    }

    public long getTimeInMillis() {
        return this.percolateTimeInMillis;
    }

    public TimeValue getTime() {
        return new TimeValue(this.getTimeInMillis());
    }

    public long getCurrent() {
        return this.current;
    }

    public long getNumQueries() {
        return this.numQueries;
    }

    public long getMemorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySizeInBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.PERCOLATE);
        builder.field(Fields.TOTAL, this.percolateCount);
        builder.timeValueField(Fields.TIME_IN_MILLIS, Fields.TIME, this.percolateTimeInMillis);
        builder.field(Fields.CURRENT, this.current);
        builder.field(Fields.MEMORY_SIZE_IN_BYTES, this.memorySizeInBytes);
        builder.field(Fields.MEMORY_SIZE, (Object)this.getMemorySize());
        builder.field(Fields.QUERIES, this.getNumQueries());
        builder.endObject();
        return builder;
    }

    public void add(PercolateStats percolate) {
        if (percolate == null) {
            return;
        }
        this.percolateCount += percolate.getCount();
        this.percolateTimeInMillis += percolate.getTimeInMillis();
        this.current += percolate.getCurrent();
        this.numQueries += percolate.getNumQueries();
    }

    public static PercolateStats readPercolateStats(StreamInput in) throws IOException {
        PercolateStats stats = new PercolateStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.percolateCount = in.readVLong();
        this.percolateTimeInMillis = in.readVLong();
        this.current = in.readVLong();
        this.numQueries = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.percolateCount);
        out.writeVLong(this.percolateTimeInMillis);
        out.writeVLong(this.current);
        out.writeVLong(this.numQueries);
    }

    static final class Fields {
        static final XContentBuilderString PERCOLATE = new XContentBuilderString("percolate");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString TIME_IN_MILLIS = new XContentBuilderString("time_in_millis");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");
        static final XContentBuilderString MEMORY_SIZE_IN_BYTES = new XContentBuilderString("memory_size_in_bytes");
        static final XContentBuilderString MEMORY_SIZE = new XContentBuilderString("memory_size");
        static final XContentBuilderString QUERIES = new XContentBuilderString("queries");

        Fields() {
        }
    }
}

