/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeArrayBuffer
extends IdScriptableObject {
    private static final long serialVersionUID = 3110411773054879549L;
    public static final String CLASS_NAME = "ArrayBuffer";
    private static final byte[] EMPTY_BUF = new byte[0];
    public static final NativeArrayBuffer EMPTY_BUFFER = new NativeArrayBuffer();
    final byte[] buffer;
    private static final int Id_constructor = 1;
    private static final int Id_slice = 2;
    private static final int Id_isView = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final int ConstructorId_isView = -3;
    private static final int Id_byteLength = 1;
    private static final int MAX_INSTANCE_ID = 1;

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer();
        nativeArrayBuffer.exportAsJSClass(3, scriptable, bl);
    }

    public NativeArrayBuffer() {
        this.buffer = EMPTY_BUF;
    }

    public NativeArrayBuffer(int n) {
        if (n < 0) {
            throw ScriptRuntime.constructError("RangeError", "Negative array length " + n);
        }
        this.buffer = n == 0 ? EMPTY_BUF : new byte[n];
    }

    public int getLength() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public NativeArrayBuffer slice(int n, int n2) {
        int n3 = Math.max(0, Math.min(this.buffer.length, n2 < 0 ? this.buffer.length + n2 : n2));
        int n4 = Math.min(n3, Math.max(0, n < 0 ? this.buffer.length + n : n));
        int n5 = n3 - n4;
        NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer(n5);
        System.arraycopy(this.buffer, n4, nativeArrayBuffer.buffer, 0, n5);
        return nativeArrayBuffer;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CLASS_NAME)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case -3: {
                return NativeArrayBuffer.isArg(objectArray, 0) && objectArray[0] instanceof NativeArrayBufferView;
            }
            case 1: {
                int n2 = NativeArrayBuffer.isArg(objectArray, 0) ? ScriptRuntime.toInt32(objectArray[0]) : 0;
                return new NativeArrayBuffer(n2);
            }
            case 2: {
                NativeArrayBuffer nativeArrayBuffer = NativeArrayBuffer.realThis(scriptable2, idFunctionObject);
                int n3 = NativeArrayBuffer.isArg(objectArray, 0) ? ScriptRuntime.toInt32(objectArray[0]) : 0;
                int n4 = NativeArrayBuffer.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : nativeArrayBuffer.buffer.length;
                return nativeArrayBuffer.slice(n3, n4);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeArrayBuffer realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeArrayBuffer)) {
            throw NativeArrayBuffer.incompatibleCallError(idFunctionObject);
        }
        return (NativeArrayBuffer)scriptable;
    }

    private static boolean isArg(Object[] objectArray, int n) {
        return objectArray.length > n && !Undefined.instance.equals(objectArray[n]);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "slice";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(CLASS_NAME, n, string, n2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block5: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 5) {
                string2 = "slice";
                n = 2;
            } else if (n2 == 6) {
                string2 = "isView";
                n = 3;
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block5;
            n = 0;
        }
        return n;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -3, "isView", 1);
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "byteLength";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.buffer.length);
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if ("byteLength".equals(string)) {
            return NativeArrayBuffer.instanceIdInfo(5, 1);
        }
        return super.findInstanceIdInfo(string);
    }
}

