/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EvalInstrumentListener;
import com.oracle.truffle.api.instrument.EventHandlerNode;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SimpleInstrumentListener;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;

@Deprecated
public abstract class ProbeInstrument
extends Instrument {
    Probe probe = null;

    private ProbeInstrument(String instrumentInfo) {
        super(instrumentInfo);
    }

    @Override
    protected void innerDispose() {
        if (this.probe != null) {
            this.probe.disposeInstrument(this);
            this.probe = null;
        }
    }

    public Probe getProbe() {
        return this.probe;
    }

    void setAttachedTo(Probe probe) {
        this.probe = probe;
    }

    abstract AbstractInstrumentNode addToChain(AbstractInstrumentNode var1);

    abstract AbstractInstrumentNode removeFromChain(AbstractInstrumentNode var1);

    @NodeInfo(cost=NodeCost.NONE)
    abstract class AbstractInstrumentNode
    extends EventHandlerNode {
        @Node.Child
        protected AbstractInstrumentNode nextInstrumentNode;

        protected AbstractInstrumentNode(AbstractInstrumentNode nextNode) {
            this.nextInstrumentNode = nextNode;
        }

        @Override
        public Probe getProbe() {
            return ProbeInstrument.this.probe;
        }

        private ProbeInstrument getInstrument() {
            return ProbeInstrument.this;
        }

        private boolean removeFromChain(ProbeInstrument instrument) {
            assert (this.getInstrument() != instrument);
            if (this.nextInstrumentNode == null) {
                return false;
            }
            if (this.nextInstrumentNode.getInstrument() == instrument) {
                if (this.nextInstrumentNode.nextInstrumentNode == null) {
                    this.nextInstrumentNode = null;
                } else {
                    this.nextInstrumentNode.replace(this.nextInstrumentNode.nextInstrumentNode);
                }
                return true;
            }
            return this.nextInstrumentNode.removeFromChain(instrument);
        }

        protected String getInstrumentInfo() {
            return ProbeInstrument.this.getInstrumentInfo();
        }
    }

    public static interface TruffleOptListener {
        public void notifyIsCompiled(boolean var1);
    }

    static final class EvalInstrument
    extends ProbeInstrument {
        private final Class<? extends TruffleLanguage> languageClass;
        private final Source source;
        private final EvalInstrumentListener evalListener;
        private final String[] names;
        private final Object[] params;

        EvalInstrument(Class<? extends TruffleLanguage> languageClass, Source source, EvalInstrumentListener evalListener, String instrumentInfo, String[] argumentNames, Object[] parameters) {
            super(instrumentInfo);
            this.languageClass = languageClass;
            this.source = source;
            this.evalListener = evalListener;
            this.names = argumentNames;
            this.params = parameters;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new EvalInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class EvalInstrumentNode
        extends AbstractInstrumentNode {
            @Node.Child
            private DirectCallNode callNode;

            private EvalInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame frame) {
                block10: {
                    block9: {
                        if (this.callNode == null) {
                            try {
                                CallTarget callTarget = Instrumenter.ACCESSOR.parse(EvalInstrument.this.languageClass, EvalInstrument.this.source, node, EvalInstrument.this.names);
                                if (callTarget != null) {
                                    this.callNode = Truffle.getRuntime().createDirectCallNode(callTarget);
                                    this.callNode.forceInlining();
                                    this.adoptChildren();
                                    EvalInstrument.this.probe.invalidateProbeUnchanged();
                                }
                            }
                            catch (IOException | RuntimeException ex) {
                                if (EvalInstrument.this.evalListener == null) break block9;
                                EvalInstrument.this.evalListener.onFailure(node, frame, ex);
                            }
                        }
                    }
                    if (this.callNode != null) {
                        try {
                            Object result = this.callNode.call(frame, EvalInstrument.this.params);
                            if (EvalInstrument.this.evalListener != null) {
                                EvalInstrument.this.evalListener.onExecution(node, frame, result);
                            }
                        }
                        catch (RuntimeException ex) {
                            if (EvalInstrument.this.evalListener == null) break block10;
                            EvalInstrument.this.evalListener.onFailure(node, frame, ex);
                        }
                    }
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, frame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame frame) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, frame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame frame, Object result) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, frame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame frame, Throwable exception) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, frame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : this.getInstrumentInfo();
            }
        }
    }

    static final class StandardInstrument
    extends ProbeInstrument {
        private final StandardInstrumentListener standardListener;

        StandardInstrument(StandardInstrumentListener standardListener, String instrumentInfo) {
            super(instrumentInfo);
            this.standardListener = standardListener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new StandardInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class StandardInstrumentNode
        extends AbstractInstrumentNode {
            private StandardInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame frame) {
                StandardInstrument.this.standardListener.onEnter(StandardInstrument.this.probe, node, frame);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, frame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame frame) {
                StandardInstrument.this.standardListener.onReturnVoid(StandardInstrument.this.probe, node, frame);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, frame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame frame, Object result) {
                StandardInstrument.this.standardListener.onReturnValue(StandardInstrument.this.probe, node, frame, result);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, frame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame frame, Throwable exception) {
                StandardInstrument.this.standardListener.onReturnExceptional(StandardInstrument.this.probe, node, frame, exception);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, frame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : StandardInstrument.this.standardListener.getClass().getSimpleName();
            }

            @Override
            public Probe getProbe() {
                return StandardInstrument.this.probe;
            }
        }
    }

    static final class SimpleInstrument
    extends ProbeInstrument {
        private final SimpleInstrumentListener simpleListener;

        SimpleInstrument(SimpleInstrumentListener simpleListener, String instrumentInfo) {
            super(instrumentInfo);
            this.simpleListener = simpleListener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new SimpleInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class SimpleInstrumentNode
        extends AbstractInstrumentNode {
            private SimpleInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame frame) {
                SimpleInstrument.this.simpleListener.onEnter(SimpleInstrument.this.probe);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, frame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame frame) {
                SimpleInstrument.this.simpleListener.onReturnVoid(SimpleInstrument.this.probe);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, frame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame frame, Object result) {
                SimpleInstrument.this.simpleListener.onReturnValue(SimpleInstrument.this.probe, result);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, frame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame frame, Throwable exception) {
                SimpleInstrument.this.simpleListener.onReturnExceptional(SimpleInstrument.this.probe, exception);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, frame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : SimpleInstrument.this.simpleListener.getClass().getSimpleName();
            }

            @Override
            public Probe getProbe() {
                return SimpleInstrument.this.probe;
            }
        }
    }
}

