/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import java.util.Arrays;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.array.BasicArrayMirror;

class LongIntArrayMirror
extends BasicArrayMirror {
    private final long[] array;

    public LongIntArrayMirror(long[] array) {
        this.array = array;
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = ((Integer)value).intValue();
    }

    @Override
    public ArrayMirror copyArrayAndMirror() {
        return new LongIntArrayMirror((long[])this.array.clone());
    }

    @Override
    public ArrayMirror copyArrayAndMirror(int newLength) {
        return new LongIntArrayMirror(Arrays.copyOf(this.array, newLength));
    }

    @Override
    public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
        for (int i = 0; i < count; ++i) {
            destination.set(destinationStart + i, this.array[sourceStart + i]);
        }
    }

    @Override
    public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
        for (int n = 0; n < count; ++n) {
            destination[destinationStart + n] = this.array[sourceStart + n];
        }
    }

    @Override
    public ArrayMirror extractRange(int start, int end) {
        return new LongIntArrayMirror(ArrayUtils.extractRange(this.array, start, end));
    }

    @Override
    public Object getArray() {
        return this.array;
    }
}

