#!/usr/bin/env python
#
#      Restriction Analysis Libraries.
#      Copyright (C) 2004. Frederic Sohm.
#
# This code is part of the Biopython distribution and governed by its
# license.  Please see the LICENSE file that should have been included
# as part of this package.
#
# This file is automatically generated - do not edit it by hand! Instead,
# use the tool Scripts/Restriction/ranacompiler.py which in turn uses
# Bio/Restriction/_Update/RestrictionCompiler.py
#
# The following dictionaries used to be defined in one go, but that does
# not work on Jython due to JVM limitations. Therefore we break this up
# into steps, using temporary functions to avoid the JVM limits.
#
# Used REBASE emboss files version 605 (2016).

rest_dict = {}


def _temp():
    return {
        'compsite': '(?P<AanI>TTATAA)',
        'results': None,
        'site': 'TTATAA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TTATAA'),
        'ovhgseq': '',
    }
rest_dict['AanI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AarI>CACCTGC)|(?P<AarI_as>GCAGGTG)',
        'results': None,
        'site': 'CACCTGC',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 11,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (11, 8, None, None, 'CACCTGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['AarI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AasI>GAC......GTC)',
        'results': None,
        'site': 'GACNNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq': 'NN',
    }
rest_dict['AasI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AatII>GACGTC)',
        'results': None,
        'site': 'GACGTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'I', 'K', 'M', 'N', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GACGTC'),
        'ovhgseq': 'ACGT',
    }
rest_dict['AatII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Aba6411II>C[AG][AG]TAAG)|(?P<Aba6411II_as>CTTA[CT][CT]G)',
        'results': None,
        'site': 'CRRTAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CRRTAAG'),
        'ovhgseq': None,
    }
rest_dict['Aba6411II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AbaCIII>CTATCA[ACG])|(?P<AbaCIII_as>[CGT]TGATAG)',
        'results': None,
        'site': 'CTATCAV',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CTATCAV'),
        'ovhgseq': None,
    }
rest_dict['AbaCIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AbaSI>C)|(?P<AbaSI_as>G)',
        'results': None,
        'site': 'C',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 12,
        'freq': 4,
        'size': 1,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (12, 9, None, None, 'C'),
        'ovhgseq': 'NN',
    }
rest_dict['AbaSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AbaUMB2I>[CT]CCG[CG][CG])|(?P<AbaUMB2I_as>[CG][CG]CGG[AG])',
        'results': None,
        'site': 'YCCGSS',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 512,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'YCCGSS'),
        'ovhgseq': None,
    }
rest_dict['AbaUMB2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AbsI>CCTCGAGG)',
        'results': None,
        'site': 'CCTCGAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTCGAGG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['AbsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Acc16I>TGCGCA)',
        'results': None,
        'site': 'TGCGCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGCGCA'),
        'ovhgseq': '',
    }
rest_dict['Acc16I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Acc36I>ACCTGC)|(?P<Acc36I_as>GCAGGT)',
        'results': None,
        'site': 'ACCTGC',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 10,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (10, 8, None, None, 'ACCTGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Acc36I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Acc65I>GGTACC)',
        'results': None,
        'site': 'GGTACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'I', 'N', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTACC'),
        'ovhgseq': 'GTAC',
    }
rest_dict['Acc65I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccB1I>GG[CT][AG]CC)',
        'results': None,
        'site': 'GGYRCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGYRCC'),
        'ovhgseq': 'GYRC',
    }
rest_dict['AccB1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccB7I>CCA.....TGG)',
        'results': None,
        'site': 'CCANNNNNTGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['AccB7I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccBSI>CCGCTC)|(?P<AccBSI_as>GAGCGG)',
        'results': None,
        'site': 'CCGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CCGCTC'),
        'ovhgseq': '',
    }
rest_dict['AccBSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccI>GT[AC][GT]AC)',
        'results': None,
        'site': 'GTMKAC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GTMKAC'),
        'ovhgseq': 'MK',
    }
rest_dict['AccI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccII>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('J', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['AccII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AccIII>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'K', 'R'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['AccIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AceIII>CAGCTC)|(?P<AceIII_as>GAGCTG)',
        'results': None,
        'site': 'CAGCTC',
        'substrat': 'DNA',
        'fst3': 11,
        'fst5': 13,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (13, 11, None, None, 'CAGCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['AceIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AchA6III>AGCCAG)|(?P<AchA6III_as>CTGGCT)',
        'results': None,
        'site': 'AGCCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AGCCAG'),
        'ovhgseq': None,
    }
rest_dict['AchA6III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AciI>CCGC)|(?P<AciI_as>GCGG)',
        'results': None,
        'site': 'CCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['AciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AclI>AACGTT)',
        'results': None,
        'site': 'AACGTT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'AACGTT'),
        'ovhgseq': 'CG',
    }
rest_dict['AclI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AclWI>GGATC)|(?P<AclWI_as>GATCC)',
        'results': None,
        'site': 'GGATC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (9, 5, None, None, 'GGATC'),
        'ovhgseq': 'N',
    }
rest_dict['AclWI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Aco12261II>CC[AG]GAG)|(?P<Aco12261II_as>CTC[CT]GG)',
        'results': None,
        'site': 'CCRGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCRGAG'),
        'ovhgseq': None,
    }
rest_dict['Aco12261II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AcoI>[CT]GGCC[AG])',
        'results': None,
        'site': 'YGGCCR',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'YGGCCR'),
        'ovhgseq': 'GGCC',
    }
rest_dict['AcoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AcsI>[AG]AATT[CT])',
        'results': None,
        'site': 'RAATTY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'RAATTY'),
        'ovhgseq': 'AATT',
    }
rest_dict['AcsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AcuI>CTGAAG)|(?P<AcuI_as>CTTCAG)',
        'results': None,
        'site': 'CTGAAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTGAAG'),
        'ovhgseq': 'NN',
    }
rest_dict['AcuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AcvI>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['AcvI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AcyI>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('J',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['AcyI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AdeI>CAC...GTG)',
        'results': None,
        'site': 'CACNNNGTG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CACNNNGTG'),
        'ovhgseq': 'NNN',
    }
rest_dict['AdeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AfaI>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GTAC'),
        'ovhgseq': '',
    }
rest_dict['AfaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AfeI>AGCGCT)',
        'results': None,
        'site': 'AGCGCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGCGCT'),
        'ovhgseq': '',
    }
rest_dict['AfeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AfiI>CC.......GG)',
        'results': None,
        'site': 'CCNNNNNNNGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['AfiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AflII>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'K', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['AflII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AflIII>AC[AG][CT]GT)',
        'results': None,
        'site': 'ACRYGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('M', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACRYGT'),
        'ovhgseq': 'CRYG',
    }
rest_dict['AflIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AgeI>ACCGGT)',
        'results': None,
        'site': 'ACCGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'N', 'R'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCGGT'),
        'ovhgseq': 'CCGG',
    }
rest_dict['AgeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AgsI>TT[CG]AA)',
        'results': None,
        'site': 'TTSAA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TTSAA'),
        'ovhgseq': 'S',
    }
rest_dict['AgsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AhaIII>TTTAAA)',
        'results': None,
        'site': 'TTTAAA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'TTTAAA'),
        'ovhgseq': '',
    }
rest_dict['AhaIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AhdI>GAC.....GTC)',
        'results': None,
        'site': 'GACNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['AhdI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AhlI>ACTAGT)',
        'results': None,
        'site': 'ACTAGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACTAGT'),
        'ovhgseq': 'CTAG',
    }
rest_dict['AhlI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AhyYL17I>[CT]AA[AC]GAG)|(?P<AhyYL17I_as>CTC[GT]TT[AG])',
        'results': None,
        'site': 'YAAMGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'YAAMGAG'),
        'ovhgseq': None,
    }
rest_dict['AhyYL17I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AjiI>CACGTC)|(?P<AjiI_as>GACGTG)',
        'results': None,
        'site': 'CACGTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTC'),
        'ovhgseq': '',
    }
rest_dict['AjiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AjnI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCWGG'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['AjnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AjuI>GAA.......TTGG)|(?P<AjuI_as>CCAA.......TTC)',
        'results': None,
        'site': 'GAANNNNNNNTTGG',
        'substrat': 'DNA',
        'fst3': -26,
        'fst5': -7,
        'freq': 16384,
        'size': 14,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 6,
        'suppl': ('B',),
        'scd5': 25,
        'charac': (-7, -26, 25, 6, 'GAANNNNNNNTTGG'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['AjuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AleI>CAC....GTG)',
        'results': None,
        'site': 'CACNNNNGTG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CACNNNNGTG'),
        'ovhgseq': '',
    }
rest_dict['AleI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AlfI>GCA......TGC)',
        'results': None,
        'site': 'GCANNNNNNTGC',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -10,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 10,
        'suppl': (),
        'scd5': 24,
        'charac': (-10, -24, 24, 10, 'GCANNNNNNTGC'),
        'ovhgseq': 'NN',
    }
rest_dict['AlfI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AloI>GAAC......TCC)|(?P<AloI_as>GGA......GTTC)',
        'results': None,
        'site': 'GAACNNNNNNTCC',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -7,
        'freq': 16384,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': ('B',),
        'scd5': 25,
        'charac': (-7, -25, 25, 7, 'GAACNNNNNNTCC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['AloI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AluBI>AGCT)',
        'results': None,
        'site': 'AGCT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'AGCT'),
        'ovhgseq': '',
    }
rest_dict['AluBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AluI>AGCT)',
        'results': None,
        'site': 'AGCT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (2, -2, None, None, 'AGCT'),
        'ovhgseq': '',
    }
rest_dict['AluI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Alw21I>G[AT]GC[AT]C)',
        'results': None,
        'site': 'GWGCWC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GWGCWC'),
        'ovhgseq': 'WGCW',
    }
rest_dict['Alw21I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Alw26I>GTCTC)|(?P<Alw26I_as>GAGAC)',
        'results': None,
        'site': 'GTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (6, 5, None, None, 'GTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Alw26I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Alw44I>GTGCAC)',
        'results': None,
        'site': 'GTGCAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'J'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTGCAC'),
        'ovhgseq': 'TGCA',
    }
rest_dict['Alw44I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AlwFI>GAAA[CT].....[AG]TG)|(?P<AlwFI_as>CA[CT].....[AG]TTTC)',
        'results': None,
        'site': 'GAAAYNNNNNRTG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAAYNNNNNRTG'),
        'ovhgseq': None,
    }
rest_dict['AlwFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AlwI>GGATC)|(?P<AlwI_as>GATCC)',
        'results': None,
        'site': 'GGATC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (9, 5, None, None, 'GGATC'),
        'ovhgseq': 'N',
    }
rest_dict['AlwI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AlwNI>CAG...CTG)',
        'results': None,
        'site': 'CAGNNNCTG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'ovhgseq': 'NNN',
    }
rest_dict['AlwNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ama87I>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['Ama87I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Aor13HI>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Aor13HI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Aor51HI>AGCGCT)',
        'results': None,
        'site': 'AGCGCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGCGCT'),
        'ovhgseq': '',
    }
rest_dict['Aor51HI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AoxI>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GGCC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['AoxI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApaBI>GCA.....TGC)',
        'results': None,
        'site': 'GCANNNNNTGC',
        'substrat': 'DNA',
        'fst3': -8,
        'fst5': 8,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (8, -8, None, None, 'GCANNNNNTGC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['ApaBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApaI>GGGCCC)',
        'results': None,
        'site': 'GGGCCC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GGGCCC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['ApaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApaLI>GTGCAC)',
        'results': None,
        'site': 'GTGCAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C', 'K', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTGCAC'),
        'ovhgseq': 'TGCA',
    }
rest_dict['ApaLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApeKI>GC[AT]GC)',
        'results': None,
        'site': 'GCWGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCWGC'),
        'ovhgseq': 'CWG',
    }
rest_dict['ApeKI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApoI>[AG]AATT[CT])',
        'results': None,
        'site': 'RAATTY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RAATTY'),
        'ovhgseq': 'AATT',
    }
rest_dict['ApoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ApyPI>ATCGAC)|(?P<ApyPI_as>GTCGAT)',
        'results': None,
        'site': 'ATCGAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'ATCGAC'),
        'ovhgseq': 'NN',
    }
rest_dict['ApyPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AquII>GCCG.AC)|(?P<AquII_as>GT.CGGC)',
        'results': None,
        'site': 'GCCGNAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'GCCGNAC'),
        'ovhgseq': 'NN',
    }
rest_dict['AquII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AquIII>GAGGAG)|(?P<AquIII_as>CTCCTC)',
        'results': None,
        'site': 'GAGGAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'GAGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['AquIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AquIV>G[AG]GGAAG)|(?P<AquIV_as>CTTCC[CT]C)',
        'results': None,
        'site': 'GRGGAAG',
        'substrat': 'DNA',
        'fst3': 17,
        'fst5': 26,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 17, None, None, 'GRGGAAG'),
        'ovhgseq': 'NN',
    }
rest_dict['AquIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ArsI>GAC......TT[CT]G)|(?P<ArsI_as>C[AG]AA......GTC)',
        'results': None,
        'site': 'GACNNNNNNTTYG',
        'substrat': 'DNA',
        'fst3': -26,
        'fst5': -8,
        'freq': 8192,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 6,
        'suppl': ('I',),
        'scd5': 24,
        'charac': (-8, -26, 24, 6, 'GACNNNNNNTTYG'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['ArsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AscI>GGCGCGCC)',
        'results': None,
        'site': 'GGCGCGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['AscI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AseI>ATTAAT)',
        'results': None,
        'site': 'ATTAAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('J', 'N'),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATTAAT'),
        'ovhgseq': 'TA',
    }
rest_dict['AseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Asi256I>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'GATC'),
        'ovhgseq': 'AT',
    }
rest_dict['Asi256I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsiGI>ACCGGT)',
        'results': None,
        'site': 'ACCGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCGGT'),
        'ovhgseq': 'CCGG',
    }
rest_dict['AsiGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsiSI>GCGATCGC)',
        'results': None,
        'site': 'GCGATCGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq': 'AT',
    }
rest_dict['AsiSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Asp700I>GAA....TTC)',
        'results': None,
        'site': 'GAANNNNTTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq': '',
    }
rest_dict['Asp700I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Asp718I>GGTACC)',
        'results': None,
        'site': 'GGTACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTACC'),
        'ovhgseq': 'GTAC',
    }
rest_dict['Asp718I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspA2I>CCTAGG)',
        'results': None,
        'site': 'CCTAGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCTAGG'),
        'ovhgseq': 'CTAG',
    }
rest_dict['AspA2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspBHI>[CT][CG]C.[CG])|(?P<AspBHI_as>[CG].G[CG][AG])',
        'results': None,
        'site': 'YSCNS',
        'substrat': 'DNA',
        'fst3': 12,
        'fst5': 13,
        'freq': 32,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (13, 12, None, None, 'YSCNS'),
        'ovhgseq': 'NNNN',
    }
rest_dict['AspBHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspDUT2V>G.GCAAC)|(?P<AspDUT2V_as>GTTGC.C)',
        'results': None,
        'site': 'GNGCAAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GNGCAAC'),
        'ovhgseq': None,
    }
rest_dict['AspDUT2V'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspJHL3II>CGCCCAG)|(?P<AspJHL3II_as>CTGGGCG)',
        'results': None,
        'site': 'CGCCCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGCCCAG'),
        'ovhgseq': None,
    }
rest_dict['AspJHL3II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspLEI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['AspLEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AspS9I>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['AspS9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Asu14238IV>CGT[AG]AC)|(?P<Asu14238IV_as>GT[CT]ACG)',
        'results': None,
        'site': 'CGTRAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGTRAC'),
        'ovhgseq': None,
    }
rest_dict['Asu14238IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsuC2I>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCSGG'),
        'ovhgseq': 'S',
    }
rest_dict['AsuC2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsuHPI>GGTGA)|(?P<AsuHPI_as>TCACC)',
        'results': None,
        'site': 'GGTGA',
        'substrat': 'DNA',
        'fst3': 7,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (13, 7, None, None, 'GGTGA'),
        'ovhgseq': 'N',
    }
rest_dict['AsuHPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsuI>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['AsuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsuII>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['AsuII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AsuNHI>GCTAGC)',
        'results': None,
        'site': 'GCTAGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCTAGC'),
        'ovhgseq': 'CTAG',
    }
rest_dict['AsuNHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AvaI>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'N', 'Q', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['AvaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AvaII>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('J', 'N', 'R', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['AvaII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AvaIII>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ATGCAT'),
        'ovhgseq': None,
    }
rest_dict['AvaIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AvrII>CCTAGG)',
        'results': None,
        'site': 'CCTAGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCTAGG'),
        'ovhgseq': 'CTAG',
    }
rest_dict['AvrII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Awo1030IV>GCC[AG]AG)|(?P<Awo1030IV_as>CT[CT]GGC)',
        'results': None,
        'site': 'GCCRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCCRAG'),
        'ovhgseq': None,
    }
rest_dict['Awo1030IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<AxyI>CCT.AGG)',
        'results': None,
        'site': 'CCTNAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('J',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq': 'TNA',
    }
rest_dict['AxyI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BaeGI>G[GT]GC[AC]C)',
        'results': None,
        'site': 'GKGCMC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GKGCMC'),
        'ovhgseq': 'KGCM',
    }
rest_dict['BaeGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BaeI>AC....GTA[CT]C)|(?P<BaeI_as>G[AG]TAC....GT)',
        'results': None,
        'site': 'ACNNNNGTAYC',
        'substrat': 'DNA',
        'fst3': -26,
        'fst5': -10,
        'freq': 8192,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': ('N',),
        'scd5': 23,
        'charac': (-10, -26, 23, 7, 'ACNNNNGTAYC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['BaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bag18758I>CCCGAG)|(?P<Bag18758I_as>CTCGGG)',
        'results': None,
        'site': 'CCCGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCCGAG'),
        'ovhgseq': None,
    }
rest_dict['Bag18758I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BalI>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['BalI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BamHI>GGATCC)',
        'results': None,
        'site': 'GGATCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGATCC'),
        'ovhgseq': 'GATC',
    }
rest_dict['BamHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BanI>GG[CT][AG]CC)',
        'results': None,
        'site': 'GGYRCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N', 'R'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGYRCC'),
        'ovhgseq': 'GYRC',
    }
rest_dict['BanI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BanII>G[AG]GC[CT]C)',
        'results': None,
        'site': 'GRGCYC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('K', 'N', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GRGCYC'),
        'ovhgseq': 'RGCY',
    }
rest_dict['BanII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BanLI>[AG]TCAGG)|(?P<BanLI_as>CCTGA[CT])',
        'results': None,
        'site': 'RTCAGG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'RTCAGG'),
        'ovhgseq': None,
    }
rest_dict['BanLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BarI>GAAG......TAC)|(?P<BarI_as>GTA......CTTC)',
        'results': None,
        'site': 'GAAGNNNNNNTAC',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -7,
        'freq': 16384,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': ('I',),
        'scd5': 25,
        'charac': (-7, -25, 25, 7, 'GAAGNNNNNNTAC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['BarI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BauI>CACGAG)|(?P<BauI_as>CTCGTG)',
        'results': None,
        'site': 'CACGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CACGAG'),
        'ovhgseq': 'ACGA',
    }
rest_dict['BauI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bbr7I>GAAGAC)|(?P<Bbr7I_as>GTCTTC)',
        'results': None,
        'site': 'GAAGAC',
        'substrat': 'DNA',
        'fst3': 11,
        'fst5': 13,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (13, 11, None, None, 'GAAGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Bbr7I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BbrPI>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['BbrPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BbsI>GAAGAC)|(?P<BbsI_as>GTCTTC)',
        'results': None,
        'site': 'GAAGAC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, 6, None, None, 'GAAGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BbsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bbv12I>G[AT]GC[AT]C)',
        'results': None,
        'site': 'GWGCWC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GWGCWC'),
        'ovhgseq': 'WGCW',
    }
rest_dict['Bbv12I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BbvCI>CCTCAGC)|(?P<BbvCI_as>GCTGAGG)',
        'results': None,
        'site': 'CCTCAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTCAGC'),
        'ovhgseq': 'TCA',
    }
rest_dict['BbvCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BbvI>GCAGC)|(?P<BbvI_as>GCTGC)',
        'results': None,
        'site': 'GCAGC',
        'substrat': 'DNA',
        'fst3': 12,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (13, 12, None, None, 'GCAGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BbvI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BbvII>GAAGAC)|(?P<BbvII_as>GTCTTC)',
        'results': None,
        'site': 'GAAGAC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (8, 6, None, None, 'GAAGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BbvII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BccI>CCATC)|(?P<BccI_as>GATGG)',
        'results': None,
        'site': 'CCATC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (9, 5, None, None, 'CCATC'),
        'ovhgseq': 'N',
    }
rest_dict['BccI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bce3081I>TAGGAG)|(?P<Bce3081I_as>CTCCTA)',
        'results': None,
        'site': 'TAGGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TAGGAG'),
        'ovhgseq': None,
    }
rest_dict['Bce3081I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bce83I>CTTGAG)|(?P<Bce83I_as>CTCAAG)',
        'results': None,
        'site': 'CTTGAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTTGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['Bce83I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BceAI>ACGGC)|(?P<BceAI_as>GCCGT)',
        'results': None,
        'site': 'ACGGC',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 17,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (17, 14, None, None, 'ACGGC'),
        'ovhgseq': 'NN',
    }
rest_dict['BceAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BceSIV>GCAGC)|(?P<BceSIV_as>GCTGC)',
        'results': None,
        'site': 'GCAGC',
        'substrat': 'DNA',
        'fst3': -10,
        'fst5': -7,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': 11,
        'suppl': (),
        'scd5': 14,
        'charac': (-7, -10, 14, 11, 'GCAGC'),
        'ovhgseq': 'NN',
    }
rest_dict['BceSIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BcefI>ACGGC)|(?P<BcefI_as>GCCGT)',
        'results': None,
        'site': 'ACGGC',
        'substrat': 'DNA',
        'fst3': 13,
        'fst5': 17,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 13, None, None, 'ACGGC'),
        'ovhgseq': 'N',
    }
rest_dict['BcefI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BcgI>CGA......TGC)|(?P<BcgI_as>GCA......TCG)',
        'results': None,
        'site': 'CGANNNNNNTGC',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -10,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 10,
        'suppl': ('N',),
        'scd5': 24,
        'charac': (-10, -24, 24, 10, 'CGANNNNNNTGC'),
        'ovhgseq': 'NN',
    }
rest_dict['BcgI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BciT130I>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCWGG'),
        'ovhgseq': 'W',
    }
rest_dict['BciT130I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BciVI>GTATCC)|(?P<BciVI_as>GGATAC)',
        'results': None,
        'site': 'GTATCC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 12,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (12, 5, None, None, 'GTATCC'),
        'ovhgseq': 'N',
    }
rest_dict['BciVI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BclI>TGATCA)',
        'results': None,
        'site': 'TGATCA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'J', 'M', 'N', 'O', 'R', 'S'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGATCA'),
        'ovhgseq': 'GATC',
    }
rest_dict['BclI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BcnI>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCSGG'),
        'ovhgseq': 'S',
    }
rest_dict['BcnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BcoDI>GTCTC)|(?P<BcoDI_as>GAGAC)',
        'results': None,
        'site': 'GTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, 5, None, None, 'GTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BcoDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BcuI>ACTAGT)',
        'results': None,
        'site': 'ACTAGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACTAGT'),
        'ovhgseq': 'CTAG',
    }
rest_dict['BcuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BdaI>TGA......TCA)',
        'results': None,
        'site': 'TGANNNNNNTCA',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -10,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 10,
        'suppl': (),
        'scd5': 24,
        'charac': (-10, -24, 24, 10, 'TGANNNNNNTCA'),
        'ovhgseq': 'NN',
    }
rest_dict['BdaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BetI>[AT]CCGG[AT])',
        'results': None,
        'site': 'WCCGGW',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'WCCGGW'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BetI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfaI>CTAG)',
        'results': None,
        'site': 'CTAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTAG'),
        'ovhgseq': 'TA',
    }
rest_dict['BfaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfaSII>GA.GGAG)|(?P<BfaSII_as>CTCC.TC)',
        'results': None,
        'site': 'GANGGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GANGGAG'),
        'ovhgseq': None,
    }
rest_dict['BfaSII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfiI>ACTGGG)|(?P<BfiI_as>CCCAGT)',
        'results': None,
        'site': 'ACTGGG',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 11,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (11, 4, None, None, 'ACTGGG'),
        'ovhgseq': 'N',
    }
rest_dict['BfiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfmI>CT[AG][CT]AG)',
        'results': None,
        'site': 'CTRYAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTRYAG'),
        'ovhgseq': 'TRYA',
    }
rest_dict['BfmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfoI>[AG]GCGC[CT])',
        'results': None,
        'site': 'RGCGCY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'RGCGCY'),
        'ovhgseq': 'GCGC',
    }
rest_dict['BfoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfrI>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['BfrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfuAI>ACCTGC)|(?P<BfuAI_as>GCAGGT)',
        'results': None,
        'site': 'ACCTGC',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 10,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (10, 8, None, None, 'ACCTGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BfuAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfuCI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['BfuCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BfuI>GTATCC)|(?P<BfuI_as>GGATAC)',
        'results': None,
        'site': 'GTATCC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 12,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (12, 5, None, None, 'GTATCC'),
        'ovhgseq': 'N',
    }
rest_dict['BfuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BglI>GCC.....GGC)',
        'results': None,
        'site': 'GCCNNNNNGGC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'N', 'O', 'Q', 'R', 'V', 'X'),
        'scd5': None,
        'charac': (7, -7, None, None, 'GCCNNNNNGGC'),
        'ovhgseq': 'NNN',
    }
rest_dict['BglI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BglII>AGATCT)',
        'results': None,
        'site': 'AGATCT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'AGATCT'),
        'ovhgseq': 'GATC',
    }
rest_dict['BglII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BinI>GGATC)|(?P<BinI_as>GATCC)',
        'results': None,
        'site': 'GGATC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (9, 5, None, None, 'GGATC'),
        'ovhgseq': 'N',
    }
rest_dict['BinI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BisI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['BisI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BlnI>CCTAGG)',
        'results': None,
        'site': 'CCTAGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K', 'M', 'S'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCTAGG'),
        'ovhgseq': 'CTAG',
    }
rest_dict['BlnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BloAII>GAGGAC)|(?P<BloAII_as>GTCCTC)',
        'results': None,
        'site': 'GAGGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAGGAC'),
        'ovhgseq': None,
    }
rest_dict['BloAII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BlpI>GCT.AGC)',
        'results': None,
        'site': 'GCTNAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq': 'TNA',
    }
rest_dict['BlpI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BlsI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['BlsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmcAI>AGTACT)',
        'results': None,
        'site': 'AGTACT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGTACT'),
        'ovhgseq': '',
    }
rest_dict['BmcAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bme1390I>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCNGG'),
        'ovhgseq': 'N',
    }
rest_dict['Bme1390I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bme18I>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['Bme18I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmeDI>C)|(?P<BmeDI_as>G)',
        'results': None,
        'site': 'C',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 3,
        'freq': 4,
        'size': 1,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, 0, None, None, 'C'),
        'ovhgseq': 'NN',
    }
rest_dict['BmeDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmeRI>GAC.....GTC)',
        'results': None,
        'site': 'GACNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['BmeRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmeT110I>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['BmeT110I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmgBI>CACGTC)|(?P<BmgBI_as>GACGTG)',
        'results': None,
        'site': 'CACGTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTC'),
        'ovhgseq': '',
    }
rest_dict['BmgBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmgI>G[GT]GCCC)|(?P<BmgI_as>GGGC[AC]C)',
        'results': None,
        'site': 'GKGCCC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GKGCCC'),
        'ovhgseq': None,
    }
rest_dict['BmgI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmgT120I>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['BmgT120I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmiI>GG..CC)',
        'results': None,
        'site': 'GGNNCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGNNCC'),
        'ovhgseq': '',
    }
rest_dict['BmiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmrFI>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCNGG'),
        'ovhgseq': 'N',
    }
rest_dict['BmrFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmrI>ACTGGG)|(?P<BmrI_as>CCCAGT)',
        'results': None,
        'site': 'ACTGGG',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 11,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (11, 4, None, None, 'ACTGGG'),
        'ovhgseq': 'N',
    }
rest_dict['BmrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmsI>GCATC)|(?P<BmsI_as>GATGC)',
        'results': None,
        'site': 'GCATC',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (10, 9, None, None, 'GCATC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BmsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmtI>GCTAGC)',
        'results': None,
        'site': 'GCTAGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCTAGC'),
        'ovhgseq': 'CTAG',
    }
rest_dict['BmtI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BmuI>ACTGGG)|(?P<BmuI_as>CCCAGT)',
        'results': None,
        'site': 'ACTGGG',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 11,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (11, 4, None, None, 'ACTGGG'),
        'ovhgseq': 'N',
    }
rest_dict['BmuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BoxI>GAC....GTC)',
        'results': None,
        'site': 'GACNNNNGTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq': '',
    }
rest_dict['BoxI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BpiI>GAAGAC)|(?P<BpiI_as>GTCTTC)',
        'results': None,
        'site': 'GAAGAC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (8, 6, None, None, 'GAAGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BpiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BplI>GAG.....CTC)',
        'results': None,
        'site': 'GAGNNNNNCTC',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -8,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 8,
        'suppl': ('B',),
        'scd5': 24,
        'charac': (-8, -24, 24, 8, 'GAGNNNNNCTC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['BplI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BpmI>CTGGAG)|(?P<BpmI_as>CTCCAG)',
        'results': None,
        'site': 'CTGGAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BpmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bpu10I>CCT.AGC)|(?P<Bpu10I_as>GCT.AGG)',
        'results': None,
        'site': 'CCTNAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'I', 'N', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGC'),
        'ovhgseq': 'TNA',
    }
rest_dict['Bpu10I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bpu1102I>GCT.AGC)',
        'results': None,
        'site': 'GCTNAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq': 'TNA',
    }
rest_dict['Bpu1102I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bpu14I>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['Bpu14I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BpuEI>CTTGAG)|(?P<BpuEI_as>CTCAAG)',
        'results': None,
        'site': 'CTTGAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTTGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BpuEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BpuMI>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCSGG'),
        'ovhgseq': 'S',
    }
rest_dict['BpuMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsa29I>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['Bsa29I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaAI>[CT]ACGT[AG])',
        'results': None,
        'site': 'YACGTR',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'YACGTR'),
        'ovhgseq': '',
    }
rest_dict['BsaAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaBI>GAT....ATC)',
        'results': None,
        'site': 'GATNNNNATC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq': '',
    }
rest_dict['BsaBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaHI>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['BsaHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaI>GGTCTC)|(?P<BsaI_as>GAGACC)',
        'results': None,
        'site': 'GGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, 5, None, None, 'GGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BsaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaJI>CC..GG)',
        'results': None,
        'site': 'CCNNGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCNNGG'),
        'ovhgseq': 'CNNG',
    }
rest_dict['BsaJI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaWI>[AT]CCGG[AT])',
        'results': None,
        'site': 'WCCGGW',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'WCCGGW'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BsaWI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsaXI>AC.....CTCC)|(?P<BsaXI_as>GGAG.....GT)',
        'results': None,
        'site': 'ACNNNNNCTCC',
        'substrat': 'DNA',
        'fst3': -23,
        'fst5': -9,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': 7,
        'suppl': ('N',),
        'scd5': 21,
        'charac': (-9, -23, 21, 7, 'ACNNNNNCTCC'),
        'ovhgseq': 'NNN',
    }
rest_dict['BsaXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsbI>CAACAC)|(?P<BsbI_as>GTGTTG)',
        'results': None,
        'site': 'CAACAC',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 27,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 19, None, None, 'CAACAC'),
        'ovhgseq': 'NN',
    }
rest_dict['BsbI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsc4I>CC.......GG)',
        'results': None,
        'site': 'CCNNNNNNNGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['Bsc4I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BscAI>GCATC)|(?P<BscAI_as>GATGC)',
        'results': None,
        'site': 'GCATC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (9, 6, None, None, 'GCATC'),
        'ovhgseq': 'NN',
    }
rest_dict['BscAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BscGI>CCCGT)|(?P<BscGI_as>ACGGG)',
        'results': None,
        'site': 'CCCGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCCGT'),
        'ovhgseq': None,
    }
rest_dict['BscGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bse118I>[AG]CCGG[CT])',
        'results': None,
        'site': 'RCCGGY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'RCCGGY'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Bse118I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bse1I>ACTGG)|(?P<Bse1I_as>CCAGT)',
        'results': None,
        'site': 'ACTGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (6, -1, None, None, 'ACTGG'),
        'ovhgseq': 'GN',
    }
rest_dict['Bse1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bse21I>CCT.AGG)',
        'results': None,
        'site': 'CCTNAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq': 'TNA',
    }
rest_dict['Bse21I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bse3DI>GCAATG)|(?P<Bse3DI_as>CATTGC)',
        'results': None,
        'site': 'GCAATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (8, 0, None, None, 'GCAATG'),
        'ovhgseq': 'NN',
    }
rest_dict['Bse3DI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bse8I>GAT....ATC)',
        'results': None,
        'site': 'GATNNNNATC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq': '',
    }
rest_dict['Bse8I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseAI>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BseAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseBI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCWGG'),
        'ovhgseq': 'W',
    }
rest_dict['BseBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseCI>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['BseCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseDI>CC..GG)',
        'results': None,
        'site': 'CCNNGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCNNGG'),
        'ovhgseq': 'CNNG',
    }
rest_dict['BseDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseGI>GGATG)|(?P<BseGI_as>CATCC)',
        'results': None,
        'site': 'GGATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 7,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, 0, None, None, 'GGATG'),
        'ovhgseq': 'NN',
    }
rest_dict['BseGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseJI>GAT....ATC)',
        'results': None,
        'site': 'GATNNNNATC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GATNNNNATC'),
        'ovhgseq': '',
    }
rest_dict['BseJI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseLI>CC.......GG)',
        'results': None,
        'site': 'CCNNNNNNNGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['BseLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseMI>GCAATG)|(?P<BseMI_as>CATTGC)',
        'results': None,
        'site': 'GCAATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (8, 0, None, None, 'GCAATG'),
        'ovhgseq': 'NN',
    }
rest_dict['BseMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseMII>CTCAG)|(?P<BseMII_as>CTGAG)',
        'results': None,
        'site': 'CTCAG',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 15,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (15, 8, None, None, 'CTCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BseMII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseNI>ACTGG)|(?P<BseNI_as>CCAGT)',
        'results': None,
        'site': 'ACTGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (6, -1, None, None, 'ACTGG'),
        'ovhgseq': 'GN',
    }
rest_dict['BseNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsePI>GCGCGC)',
        'results': None,
        'site': 'GCGCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGCGC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['BsePI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseRI>GAGGAG)|(?P<BseRI_as>CTCCTC)',
        'results': None,
        'site': 'GAGGAG',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 16,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (16, 8, None, None, 'GAGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BseRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseSI>G[GT]GC[AC]C)',
        'results': None,
        'site': 'GKGCMC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GKGCMC'),
        'ovhgseq': 'KGCM',
    }
rest_dict['BseSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseX3I>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['BseX3I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseXI>GCAGC)|(?P<BseXI_as>GCTGC)',
        'results': None,
        'site': 'GCAGC',
        'substrat': 'DNA',
        'fst3': 12,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (13, 12, None, None, 'GCAGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BseXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BseYI>CCCAGC)|(?P<BseYI_as>GCTGGG)',
        'results': None,
        'site': 'CCCAGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCCAGC'),
        'ovhgseq': 'CCAG',
    }
rest_dict['BseYI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsgI>GTGCAG)|(?P<BsgI_as>CTGCAC)',
        'results': None,
        'site': 'GTGCAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (22, 14, None, None, 'GTGCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BsgI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsh1236I>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['Bsh1236I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsh1285I>CG[AG][CT]CG)',
        'results': None,
        'site': 'CGRYCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGRYCG'),
        'ovhgseq': 'RY',
    }
rest_dict['Bsh1285I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BshFI>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCC'),
        'ovhgseq': '',
    }
rest_dict['BshFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BshNI>GG[CT][AG]CC)',
        'results': None,
        'site': 'GGYRCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGYRCC'),
        'ovhgseq': 'GYRC',
    }
rest_dict['BshNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BshTI>ACCGGT)',
        'results': None,
        'site': 'ACCGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCGGT'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BshTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BshVI>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['BshVI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiEI>CG[AG][CT]CG)',
        'results': None,
        'site': 'CGRYCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGRYCG'),
        'ovhgseq': 'RY',
    }
rest_dict['BsiEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiHKAI>G[AT]GC[AT]C)',
        'results': None,
        'site': 'GWGCWC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GWGCWC'),
        'ovhgseq': 'WGCW',
    }
rest_dict['BsiHKAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiHKCI>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['BsiHKCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiI>CACGAG)|(?P<BsiI_as>CTCGTG)',
        'results': None,
        'site': 'CACGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CACGAG'),
        'ovhgseq': 'ACGA',
    }
rest_dict['BsiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiSI>CCGG)',
        'results': None,
        'site': 'CCGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('C', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGG'),
        'ovhgseq': 'CG',
    }
rest_dict['BsiSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiWI>CGTACG)',
        'results': None,
        'site': 'CGTACG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGTACG'),
        'ovhgseq': 'GTAC',
    }
rest_dict['BsiWI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsiYI>CC.......GG)',
        'results': None,
        'site': 'CCNNNNNNNGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['BsiYI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BslFI>GGGAC)|(?P<BslFI_as>GTCCC)',
        'results': None,
        'site': 'GGGAC',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 15,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (15, 14, None, None, 'GGGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BslFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BslI>CC.......GG)',
        'results': None,
        'site': 'CCNNNNNNNGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['BslI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsmAI>GTCTC)|(?P<BsmAI_as>GAGAC)',
        'results': None,
        'site': 'GTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, 5, None, None, 'GTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BsmAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsmBI>CGTCTC)|(?P<BsmBI_as>GAGACG)',
        'results': None,
        'site': 'CGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, 5, None, None, 'CGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BsmBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsmFI>GGGAC)|(?P<BsmFI_as>GTCCC)',
        'results': None,
        'site': 'GGGAC',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 15,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (15, 14, None, None, 'GGGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BsmFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsmI>GAATGC)|(?P<BsmI_as>GCATTC)',
        'results': None,
        'site': 'GAATGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('J', 'M', 'N', 'S'),
        'scd5': None,
        'charac': (7, -1, None, None, 'GAATGC'),
        'ovhgseq': 'CN',
    }
rest_dict['BsmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsnI>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCC'),
        'ovhgseq': '',
    }
rest_dict['BsnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bso31I>GGTCTC)|(?P<Bso31I_as>GAGACC)',
        'results': None,
        'site': 'GGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, 5, None, None, 'GGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Bso31I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsoBI>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['BsoBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp119I>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['Bsp119I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp120I>GGGCCC)',
        'results': None,
        'site': 'GGGCCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGGCCC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['Bsp120I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp1286I>G[AGT]GC[ACT]C)',
        'results': None,
        'site': 'GDGCHC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('J', 'K', 'N'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GDGCHC'),
        'ovhgseq': 'DGCH',
    }
rest_dict['Bsp1286I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp13I>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Bsp13I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp1407I>TGTACA)',
        'results': None,
        'site': 'TGTACA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGTACA'),
        'ovhgseq': 'GTAC',
    }
rest_dict['Bsp1407I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp143I>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['Bsp143I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp1720I>GCT.AGC)',
        'results': None,
        'site': 'GCTNAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq': 'TNA',
    }
rest_dict['Bsp1720I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp19I>CCATGG)',
        'results': None,
        'site': 'CCATGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCATGG'),
        'ovhgseq': 'CATG',
    }
rest_dict['Bsp19I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp24I>GAC......TGG)|(?P<Bsp24I_as>CCA......GTC)',
        'results': None,
        'site': 'GACNNNNNNTGG',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -8,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': (),
        'scd5': 24,
        'charac': (-8, -25, 24, 7, 'GACNNNNNNTGG'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['Bsp24I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp3004IV>CCGCAT)|(?P<Bsp3004IV_as>ATGCGG)',
        'results': None,
        'site': 'CCGCAT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCGCAT'),
        'ovhgseq': None,
    }
rest_dict['Bsp3004IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsp68I>TCGCGA)',
        'results': None,
        'site': 'TCGCGA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TCGCGA'),
        'ovhgseq': '',
    }
rest_dict['Bsp68I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspACI>CCGC)|(?P<BspACI_as>GCGG)',
        'results': None,
        'site': 'CCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['BspACI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspANI>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('X',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCC'),
        'ovhgseq': '',
    }
rest_dict['BspANI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspCNI>CTCAG)|(?P<BspCNI_as>CTGAG)',
        'results': None,
        'site': 'CTCAG',
        'substrat': 'DNA',
        'fst3': 7,
        'fst5': 14,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (14, 7, None, None, 'CTCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['BspCNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspD6I>GACTC)|(?P<BspD6I_as>GAGTC)',
        'results': None,
        'site': 'GACTC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (9, 6, None, None, 'GACTC'),
        'ovhgseq': 'NN',
    }
rest_dict['BspD6I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspDI>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['BspDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspEI>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BspEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspFNI>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['BspFNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspGI>CTGGAC)|(?P<BspGI_as>GTCCAG)',
        'results': None,
        'site': 'CTGGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CTGGAC'),
        'ovhgseq': None,
    }
rest_dict['BspGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspHI>TCATGA)',
        'results': None,
        'site': 'TCATGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCATGA'),
        'ovhgseq': 'CATG',
    }
rest_dict['BspHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspLI>GG..CC)',
        'results': None,
        'site': 'GGNNCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGNNCC'),
        'ovhgseq': '',
    }
rest_dict['BspLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspLU11I>ACATGT)',
        'results': None,
        'site': 'ACATGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACATGT'),
        'ovhgseq': 'CATG',
    }
rest_dict['BspLU11I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspMAI>CTGCAG)',
        'results': None,
        'site': 'CTGCAG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('X',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CTGCAG'),
        'ovhgseq': 'TGCA',
    }
rest_dict['BspMAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspMI>ACCTGC)|(?P<BspMI_as>GCAGGT)',
        'results': None,
        'site': 'ACCTGC',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 10,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (10, 8, None, None, 'ACCTGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BspMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspMII>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BspMII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspNCI>CCAGA)|(?P<BspNCI_as>TCTGG)',
        'results': None,
        'site': 'CCAGA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCAGA'),
        'ovhgseq': None,
    }
rest_dict['BspNCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspOI>GCTAGC)',
        'results': None,
        'site': 'GCTAGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCTAGC'),
        'ovhgseq': 'CTAG',
    }
rest_dict['BspOI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspPI>GGATC)|(?P<BspPI_as>GATCC)',
        'results': None,
        'site': 'GGATC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (9, 5, None, None, 'GGATC'),
        'ovhgseq': 'N',
    }
rest_dict['BspPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspQI>GCTCTTC)|(?P<BspQI_as>GAAGAGC)',
        'results': None,
        'site': 'GCTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 8,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['BspQI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspT104I>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['BspT104I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspT107I>GG[CT][AG]CC)',
        'results': None,
        'site': 'GGYRCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGYRCC'),
        'ovhgseq': 'GYRC',
    }
rest_dict['BspT107I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspTI>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['BspTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BspTNI>GGTCTC)|(?P<BspTNI_as>GAGACC)',
        'results': None,
        'site': 'GGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('X',),
        'scd5': None,
        'charac': (7, 5, None, None, 'GGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BspTNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsrBI>CCGCTC)|(?P<BsrBI_as>GAGCGG)',
        'results': None,
        'site': 'CCGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CCGCTC'),
        'ovhgseq': '',
    }
rest_dict['BsrBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsrDI>GCAATG)|(?P<BsrDI_as>CATTGC)',
        'results': None,
        'site': 'GCAATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, 0, None, None, 'GCAATG'),
        'ovhgseq': 'NN',
    }
rest_dict['BsrDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsrFI>[AG]CCGG[CT])',
        'results': None,
        'site': 'RCCGGY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RCCGGY'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BsrFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsrGI>TGTACA)',
        'results': None,
        'site': 'TGTACA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGTACA'),
        'ovhgseq': 'GTAC',
    }
rest_dict['BsrGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsrI>ACTGG)|(?P<BsrI_as>CCAGT)',
        'results': None,
        'site': 'ACTGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, -1, None, None, 'ACTGG'),
        'ovhgseq': 'GN',
    }
rest_dict['BsrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssAI>[AG]CCGG[CT])',
        'results': None,
        'site': 'RCCGGY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RCCGGY'),
        'ovhgseq': 'CCGG',
    }
rest_dict['BssAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssECI>CC..GG)',
        'results': None,
        'site': 'CCNNGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCNNGG'),
        'ovhgseq': 'CNNG',
    }
rest_dict['BssECI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssHII>GCGCGC)',
        'results': None,
        'site': 'GCGCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'K', 'M', 'N', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGCGC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['BssHII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssMI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['BssMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssNAI>GTATAC)',
        'results': None,
        'site': 'GTATAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTATAC'),
        'ovhgseq': '',
    }
rest_dict['BssNAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssNI>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['BssNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssSI>CACGAG)|(?P<BssSI_as>CTCGTG)',
        'results': None,
        'site': 'CACGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CACGAG'),
        'ovhgseq': 'ACGA',
    }
rest_dict['BssSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BssT1I>CC[AT][AT]GG)',
        'results': None,
        'site': 'CCWWGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCWWGG'),
        'ovhgseq': 'CWWG',
    }
rest_dict['BssT1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bst1107I>GTATAC)',
        'results': None,
        'site': 'GTATAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTATAC'),
        'ovhgseq': '',
    }
rest_dict['Bst1107I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bst2BI>CACGAG)|(?P<Bst2BI_as>CTCGTG)',
        'results': None,
        'site': 'CACGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CACGAG'),
        'ovhgseq': 'ACGA',
    }
rest_dict['Bst2BI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bst2UI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCWGG'),
        'ovhgseq': 'W',
    }
rest_dict['Bst2UI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bst4CI>AC.GT)',
        'results': None,
        'site': 'ACNGT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'ACNGT'),
        'ovhgseq': 'N',
    }
rest_dict['Bst4CI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bst6I>CTCTTC)|(?P<Bst6I_as>GAAGAG)',
        'results': None,
        'site': 'CTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, 4, None, None, 'CTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['Bst6I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstACI>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['BstACI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstAFI>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['BstAFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstAPI>GCA.....TGC)',
        'results': None,
        'site': 'GCANNNNNTGC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (7, -7, None, None, 'GCANNNNNTGC'),
        'ovhgseq': 'NNN',
    }
rest_dict['BstAPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstAUI>TGTACA)',
        'results': None,
        'site': 'TGTACA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGTACA'),
        'ovhgseq': 'GTAC',
    }
rest_dict['BstAUI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstBAI>[CT]ACGT[AG])',
        'results': None,
        'site': 'YACGTR',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'YACGTR'),
        'ovhgseq': '',
    }
rest_dict['BstBAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstBI>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['BstBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstC8I>GC..GC)',
        'results': None,
        'site': 'GCNNGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCNNGC'),
        'ovhgseq': '',
    }
rest_dict['BstC8I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstDEI>CT.AG)',
        'results': None,
        'site': 'CTNAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTNAG'),
        'ovhgseq': 'TNA',
    }
rest_dict['BstDEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstDSI>CC[AG][CT]GG)',
        'results': None,
        'site': 'CCRYGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCRYGG'),
        'ovhgseq': 'CRYG',
    }
rest_dict['BstDSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstEII>GGT.ACC)',
        'results': None,
        'site': 'GGTNACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('C', 'J', 'N', 'R', 'S'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTNACC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['BstEII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstENI>CCT.....AGG)',
        'results': None,
        'site': 'CCTNNNNNAGG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq': 'N',
    }
rest_dict['BstENI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstF5I>GGATG)|(?P<BstF5I_as>CATCC)',
        'results': None,
        'site': 'GGATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 7,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, 0, None, None, 'GGATG'),
        'ovhgseq': 'NN',
    }
rest_dict['BstF5I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstFNI>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['BstFNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstH2I>[AG]GCGC[CT])',
        'results': None,
        'site': 'RGCGCY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'RGCGCY'),
        'ovhgseq': 'GCGC',
    }
rest_dict['BstH2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstHHI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['BstHHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstKTI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GATC'),
        'ovhgseq': 'AT',
    }
rest_dict['BstKTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstMAI>GTCTC)|(?P<BstMAI_as>GAGAC)',
        'results': None,
        'site': 'GTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (6, 5, None, None, 'GTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BstMAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstMBI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['BstMBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstMCI>CG[AG][CT]CG)',
        'results': None,
        'site': 'CGRYCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGRYCG'),
        'ovhgseq': 'RY',
    }
rest_dict['BstMCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstMWI>GC.......GC)',
        'results': None,
        'site': 'GCNNNNNNNGC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq': 'NNN',
    }
rest_dict['BstMWI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstNI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCWGG'),
        'ovhgseq': 'W',
    }
rest_dict['BstNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstNSI>[AG]CATG[CT])',
        'results': None,
        'site': 'RCATGY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'RCATGY'),
        'ovhgseq': 'CATG',
    }
rest_dict['BstNSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstPAI>GAC....GTC)',
        'results': None,
        'site': 'GACNNNNGTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq': '',
    }
rest_dict['BstPAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstPI>GGT.ACC)',
        'results': None,
        'site': 'GGTNACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTNACC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['BstPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstSCI>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCNGG'),
        'ovhgseq': 'CCNGG',
    }
rest_dict['BstSCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstSFI>CT[AG][CT]AG)',
        'results': None,
        'site': 'CTRYAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTRYAG'),
        'ovhgseq': 'TRYA',
    }
rest_dict['BstSFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstSLI>G[GT]GC[AC]C)',
        'results': None,
        'site': 'GKGCMC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GKGCMC'),
        'ovhgseq': 'KGCM',
    }
rest_dict['BstSLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstSNI>TACGTA)',
        'results': None,
        'site': 'TACGTA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TACGTA'),
        'ovhgseq': '',
    }
rest_dict['BstSNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstUI>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['BstUI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstV1I>GCAGC)|(?P<BstV1I_as>GCTGC)',
        'results': None,
        'site': 'GCAGC',
        'substrat': 'DNA',
        'fst3': 12,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (13, 12, None, None, 'GCAGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BstV1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstV2I>GAAGAC)|(?P<BstV2I_as>GTCTTC)',
        'results': None,
        'site': 'GAAGAC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (8, 6, None, None, 'GAAGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BstV2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstX2I>[AG]GATC[CT])',
        'results': None,
        'site': 'RGATCY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'RGATCY'),
        'ovhgseq': 'GATC',
    }
rest_dict['BstX2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstXI>CCA......TGG)',
        'results': None,
        'site': 'CCANNNNNNTGG',
        'substrat': 'DNA',
        'fst3': -8,
        'fst5': 8,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (8, -8, None, None, 'CCANNNNNNTGG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BstXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstYI>[AG]GATC[CT])',
        'results': None,
        'site': 'RGATCY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RGATCY'),
        'ovhgseq': 'GATC',
    }
rest_dict['BstYI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstZ17I>GTATAC)',
        'results': None,
        'site': 'GTATAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTATAC'),
        'ovhgseq': '',
    }
rest_dict['BstZ17I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BstZI>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('R',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['BstZI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsu15I>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['Bsu15I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsu36I>CCT.AGG)',
        'results': None,
        'site': 'CCTNAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq': 'TNA',
    }
rest_dict['Bsu36I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Bsu7003I>GACGAGC)|(?P<Bsu7003I_as>GCTCGTC)',
        'results': None,
        'site': 'GACGAGC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GACGAGC'),
        'ovhgseq': None,
    }
rest_dict['Bsu7003I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsuI>GTATCC)|(?P<BsuI_as>GGATAC)',
        'results': None,
        'site': 'GTATCC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 12,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (12, 5, None, None, 'GTATCC'),
        'ovhgseq': 'N',
    }
rest_dict['BsuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsuRI>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'I'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCC'),
        'ovhgseq': '',
    }
rest_dict['BsuRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BsuTUI>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('X',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['BsuTUI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtgI>CC[AG][CT]GG)',
        'results': None,
        'site': 'CCRYGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCRYGG'),
        'ovhgseq': 'CRYG',
    }
rest_dict['BtgI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtgZI>GCGATG)|(?P<BtgZI_as>CATCGC)',
        'results': None,
        'site': 'GCGATG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 16,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (16, 14, None, None, 'GCGATG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BtgZI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BthCI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'GCNGC'),
        'ovhgseq': 'CNG',
    }
rest_dict['BthCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtrI>CACGTC)|(?P<BtrI_as>GACGTG)',
        'results': None,
        'site': 'CACGTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTC'),
        'ovhgseq': '',
    }
rest_dict['BtrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtsCI>GGATG)|(?P<BtsCI_as>CATCC)',
        'results': None,
        'site': 'GGATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 7,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, 0, None, None, 'GGATG'),
        'ovhgseq': 'NN',
    }
rest_dict['BtsCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtsI>GCAGTG)|(?P<BtsI_as>CACTGC)',
        'results': None,
        'site': 'GCAGTG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 8,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, 0, None, None, 'GCAGTG'),
        'ovhgseq': 'NN',
    }
rest_dict['BtsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtsIMutI>CAGTG)|(?P<BtsIMutI_as>CACTG)',
        'results': None,
        'site': 'CAGTG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 7,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, 0, None, None, 'CAGTG'),
        'ovhgseq': 'NN',
    }
rest_dict['BtsIMutI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BtuMI>TCGCGA)',
        'results': None,
        'site': 'TCGCGA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TCGCGA'),
        'ovhgseq': '',
    }
rest_dict['BtuMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<BveI>ACCTGC)|(?P<BveI_as>GCAGGT)',
        'results': None,
        'site': 'ACCTGC',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 10,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (10, 8, None, None, 'ACCTGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['BveI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cac8I>GC..GC)',
        'results': None,
        'site': 'GCNNGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCNNGC'),
        'ovhgseq': '',
    }
rest_dict['Cac8I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CaiI>CAG...CTG)',
        'results': None,
        'site': 'CAGNNNCTG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'ovhgseq': 'NNN',
    }
rest_dict['CaiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cal14237I>GGTTAG)|(?P<Cal14237I_as>CTAACC)',
        'results': None,
        'site': 'GGTTAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGTTAG'),
        'ovhgseq': None,
    }
rest_dict['Cal14237I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CalB3II>G[AG]TT[AG]AG)|(?P<CalB3II_as>CT[CT]AA[CT]C)',
        'results': None,
        'site': 'GRTTRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GRTTRAG'),
        'ovhgseq': None,
    }
rest_dict['CalB3II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cau10061II>GTTAAT)|(?P<Cau10061II_as>ATTAAC)',
        'results': None,
        'site': 'GTTAAT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTTAAT'),
        'ovhgseq': None,
    }
rest_dict['Cau10061II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CauII>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCSGG'),
        'ovhgseq': 'S',
    }
rest_dict['CauII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cba13II>AGGAAT)|(?P<Cba13II_as>ATTCCT)',
        'results': None,
        'site': 'AGGAAT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AGGAAT'),
        'ovhgseq': None,
    }
rest_dict['Cba13II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cba16038I>CCT.A[CT].C)|(?P<Cba16038I_as>G.[AG]T.AGG)',
        'results': None,
        'site': 'CCTNAYNC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCTNAYNC'),
        'ovhgseq': None,
    }
rest_dict['Cba16038I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CchII>GGA[AG]GA)|(?P<CchII_as>TC[CT]TCC)',
        'results': None,
        'site': 'GGARGA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 9, None, None, 'GGARGA'),
        'ovhgseq': 'NN',
    }
rest_dict['CchII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CchIII>CCCAAG)|(?P<CchIII_as>CTTGGG)',
        'results': None,
        'site': 'CCCAAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'CCCAAG'),
        'ovhgseq': 'NN',
    }
rest_dict['CchIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CciI>TCATGA)',
        'results': None,
        'site': 'TCATGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCATGA'),
        'ovhgseq': 'CATG',
    }
rest_dict['CciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CciNI>GCGGCCGC)',
        'results': None,
        'site': 'GCGGCCGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCGGCCGC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['CciNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CcrNAIII>CGACCAG)|(?P<CcrNAIII_as>CTGGTCG)',
        'results': None,
        'site': 'CGACCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGACCAG'),
        'ovhgseq': None,
    }
rest_dict['CcrNAIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cdi11397I>GCGCAG)|(?P<Cdi11397I_as>CTGCGC)',
        'results': None,
        'site': 'GCGCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGCAG'),
        'ovhgseq': None,
    }
rest_dict['Cdi11397I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CdiI>CATCG)|(?P<CdiI_as>CGATG)',
        'results': None,
        'site': 'CATCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 4,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -1, None, None, 'CATCG'),
        'ovhgseq': '',
    }
rest_dict['CdiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CdpI>GCGGAG)|(?P<CdpI_as>CTCCGC)',
        'results': None,
        'site': 'GCGGAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'GCGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['CdpI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cdu23823II>GTGAAG)|(?P<Cdu23823II_as>CTTCAC)',
        'results': None,
        'site': 'GTGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTGAAG'),
        'ovhgseq': None,
    }
rest_dict['Cdu23823II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CfoI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('M', 'R', 'S'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['CfoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cfr10I>[AG]CCGG[CT])',
        'results': None,
        'site': 'RCCGGY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (1, -1, None, None, 'RCCGGY'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Cfr10I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cfr13I>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['Cfr13I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cfr42I>CCGCGG)',
        'results': None,
        'site': 'CCGCGG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CCGCGG'),
        'ovhgseq': 'GC',
    }
rest_dict['Cfr42I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cfr9I>CCCGGG)',
        'results': None,
        'site': 'CCCGGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCCGGG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Cfr9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CfrI>[CT]GGCC[AG])',
        'results': None,
        'site': 'YGGCCR',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'YGGCCR'),
        'ovhgseq': 'GGCC',
    }
rest_dict['CfrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cgl13032I>GGCGCA)|(?P<Cgl13032I_as>TGCGCC)',
        'results': None,
        'site': 'GGCGCA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGCGCA'),
        'ovhgseq': None,
    }
rest_dict['Cgl13032I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cgl13032II>ACGA[CGT]GG)|(?P<Cgl13032II_as>CC[ACG]TCGT)',
        'results': None,
        'site': 'ACGABGG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ACGABGG'),
        'ovhgseq': None,
    }
rest_dict['Cgl13032II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ChaI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['ChaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeFIII>GCAAGG)|(?P<CjeFIII_as>CCTTGC)',
        'results': None,
        'site': 'GCAAGG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCAAGG'),
        'ovhgseq': None,
    }
rest_dict['CjeFIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeFV>GG[AG]CA)|(?P<CjeFV_as>TG[CT]CC)',
        'results': None,
        'site': 'GGRCA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGRCA'),
        'ovhgseq': None,
    }
rest_dict['CjeFV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeI>CCA......GT)|(?P<CjeI_as>AC......TGG)',
        'results': None,
        'site': 'CCANNNNNNGT',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -8,
        'freq': 1024,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 6,
        'scd3': 9,
        'suppl': (),
        'scd5': 26,
        'charac': (-8, -25, 26, 9, 'CCANNNNNNGT'),
        'ovhgseq': 'NNNNNN',
    }
rest_dict['CjeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeNII>GAG.....GT)|(?P<CjeNII_as>AC.....CTC)',
        'results': None,
        'site': 'GAGNNNNNGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAGNNNNNGT'),
        'ovhgseq': None,
    }
rest_dict['CjeNII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeNIII>G[GT]AA[CT]G)|(?P<CjeNIII_as>C[AG]TT[AC]C)',
        'results': None,
        'site': 'GKAAYG',
        'substrat': 'DNA',
        'fst3': 17,
        'fst5': 25,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (25, 17, None, None, 'GKAAYG'),
        'ovhgseq': 'NN',
    }
rest_dict['CjeNIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjeP659IV>CAC.......GAA)|(?P<CjeP659IV_as>TTC.......GTG)',
        'results': None,
        'site': 'CACNNNNNNNGAA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CACNNNNNNNGAA'),
        'ovhgseq': None,
    }
rest_dict['CjeP659IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjePI>CCA.......TC)|(?P<CjePI_as>GA.......TGG)',
        'results': None,
        'site': 'CCANNNNNNNTC',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -7,
        'freq': 1024,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 6,
        'scd3': 8,
        'suppl': (),
        'scd5': 26,
        'charac': (-7, -25, 26, 8, 'CCANNNNNNNTC'),
        'ovhgseq': 'NNNNNN',
    }
rest_dict['CjePI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjuI>CA[CT].....[AG]TG)',
        'results': None,
        'site': 'CAYNNNNNRTG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CAYNNNNNRTG'),
        'ovhgseq': None,
    }
rest_dict['CjuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CjuII>CA[CT].....CTC)|(?P<CjuII_as>GAG.....[AG]TG)',
        'results': None,
        'site': 'CAYNNNNNCTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CAYNNNNNCTC'),
        'ovhgseq': None,
    }
rest_dict['CjuII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cla11845III>GCGAA)|(?P<Cla11845III_as>TTCGC)',
        'results': None,
        'site': 'GCGAA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGAA'),
        'ovhgseq': None,
    }
rest_dict['Cla11845III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ClaI>ATCGAT)',
        'results': None,
        'site': 'ATCGAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATCGAT'),
        'ovhgseq': 'CG',
    }
rest_dict['ClaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cly7489II>AAAAG[AG]G)|(?P<Cly7489II_as>C[CT]CTTTT)',
        'results': None,
        'site': 'AAAAGRG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AAAAGRG'),
        'ovhgseq': None,
    }
rest_dict['Cly7489II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Cma23826I>CGGAAG)|(?P<Cma23826I_as>CTTCCG)',
        'results': None,
        'site': 'CGGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGGAAG'),
        'ovhgseq': None,
    }
rest_dict['Cma23826I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CpoI>CGG[AT]CCG)',
        'results': None,
        'site': 'CGGWCCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq': 'GWC',
    }
rest_dict['CpoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CseI>GACGC)|(?P<CseI_as>GCGTC)',
        'results': None,
        'site': 'GACGC',
        'substrat': 'DNA',
        'fst3': 10,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (10, 10, None, None, 'GACGC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['CseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CsiI>ACC[AT]GGT)',
        'results': None,
        'site': 'ACCWGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['CsiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Csp2014I>GGAGGC)|(?P<Csp2014I_as>GCCTCC)',
        'results': None,
        'site': 'GGAGGC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGAGGC'),
        'ovhgseq': None,
    }
rest_dict['Csp2014I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Csp6I>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTAC'),
        'ovhgseq': 'TA',
    }
rest_dict['Csp6I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CspAI>ACCGGT)',
        'results': None,
        'site': 'ACCGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCGGT'),
        'ovhgseq': 'CCGG',
    }
rest_dict['CspAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CspCI>CAA.....GTGG)|(?P<CspCI_as>CCAC.....TTG)',
        'results': None,
        'site': 'CAANNNNNGTGG',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -11,
        'freq': 16384,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 10,
        'suppl': ('N',),
        'scd5': 24,
        'charac': (-11, -25, 24, 10, 'CAANNNNNGTGG'),
        'ovhgseq': 'NN',
    }
rest_dict['CspCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CspI>CGG[AT]CCG)',
        'results': None,
        'site': 'CGGWCCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('R',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq': 'GWC',
    }
rest_dict['CspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CstMI>AAGGAG)|(?P<CstMI_as>CTCCTT)',
        'results': None,
        'site': 'AAGGAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'AAGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['CstMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CviAII>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CATG'),
        'ovhgseq': 'AT',
    }
rest_dict['CviAII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CviJI>[AG]GC[CT])',
        'results': None,
        'site': 'RGCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 64,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGCY'),
        'ovhgseq': '',
    }
rest_dict['CviJI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CviKI_1>[AG]GC[CT])',
        'results': None,
        'site': 'RGCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 64,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGCY'),
        'ovhgseq': '',
    }
rest_dict['CviKI_1'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CviQI>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTAC'),
        'ovhgseq': 'TA',
    }
rest_dict['CviQI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<CviRI>TGCA)',
        'results': None,
        'site': 'TGCA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'TGCA'),
        'ovhgseq': '',
    }
rest_dict['CviRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DdeI>CT.AG)',
        'results': None,
        'site': 'CTNAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTNAG'),
        'ovhgseq': 'TNA',
    }
rest_dict['DdeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DinI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGCGCC'),
        'ovhgseq': '',
    }
rest_dict['DinI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DpnI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'E', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GATC'),
        'ovhgseq': '',
    }
rest_dict['DpnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DpnII>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['DpnII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DraI>TTTAAA)',
        'results': None,
        'site': 'TTTAAA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TTTAAA'),
        'ovhgseq': '',
    }
rest_dict['DraI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DraII>[AG]GG.CC[CT])',
        'results': None,
        'site': 'RGGNCCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGGNCCY'),
        'ovhgseq': 'GNC',
    }
rest_dict['DraII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DraIII>CAC...GTG)',
        'results': None,
        'site': 'CACNNNGTG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I', 'M', 'N', 'V'),
        'scd5': None,
        'charac': (6, -6, None, None, 'CACNNNGTG'),
        'ovhgseq': 'NNN',
    }
rest_dict['DraIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DraRI>CAAG.AC)|(?P<DraRI_as>GT.CTTG)',
        'results': None,
        'site': 'CAAGNAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CAAGNAC'),
        'ovhgseq': 'NN',
    }
rest_dict['DraRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DrdI>GAC......GTC)',
        'results': None,
        'site': 'GACNNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq': 'NN',
    }
rest_dict['DrdI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DrdII>GAACCA)|(?P<DrdII_as>TGGTTC)',
        'results': None,
        'site': 'GAACCA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAACCA'),
        'ovhgseq': None,
    }
rest_dict['DrdII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DriI>GAC.....GTC)',
        'results': None,
        'site': 'GACNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['DriI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DsaI>CC[AG][CT]GG)',
        'results': None,
        'site': 'CCRYGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCRYGG'),
        'ovhgseq': 'CRYG',
    }
rest_dict['DsaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<DseDI>GAC......GTC)',
        'results': None,
        'site': 'GACNNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
        'ovhgseq': 'NN',
    }
rest_dict['DseDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EaeI>[CT]GGCC[AG])',
        'results': None,
        'site': 'YGGCCR',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'YGGCCR'),
        'ovhgseq': 'GGCC',
    }
rest_dict['EaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EagI>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['EagI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eam1104I>CTCTTC)|(?P<Eam1104I_as>GAAGAG)',
        'results': None,
        'site': 'CTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, 4, None, None, 'CTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['Eam1104I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eam1105I>GAC.....GTC)',
        'results': None,
        'site': 'GACNNNNNGTC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (6, -6, None, None, 'GACNNNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['Eam1105I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EarI>CTCTTC)|(?P<EarI_as>GAAGAG)',
        'results': None,
        'site': 'CTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, 4, None, None, 'CTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['EarI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EciI>GGCGGA)|(?P<EciI_as>TCCGCC)',
        'results': None,
        'site': 'GGCGGA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (17, 9, None, None, 'GGCGGA'),
        'ovhgseq': 'NN',
    }
rest_dict['EciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ecl136II>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GAGCTC'),
        'ovhgseq': '',
    }
rest_dict['Ecl136II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ecl35734I>GAAA[CT]TC)|(?P<Ecl35734I_as>GA[AG]TTTC)',
        'results': None,
        'site': 'GAAAYTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAAYTC'),
        'ovhgseq': None,
    }
rest_dict['Ecl35734I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EclXI>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('S',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['EclXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco105I>TACGTA)',
        'results': None,
        'site': 'TACGTA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TACGTA'),
        'ovhgseq': '',
    }
rest_dict['Eco105I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco130I>CC[AT][AT]GG)',
        'results': None,
        'site': 'CCWWGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCWWGG'),
        'ovhgseq': 'CWWG',
    }
rest_dict['Eco130I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco147I>AGGCCT)',
        'results': None,
        'site': 'AGGCCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGGCCT'),
        'ovhgseq': '',
    }
rest_dict['Eco147I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco24I>G[AG]GC[CT]C)',
        'results': None,
        'site': 'GRGCYC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GRGCYC'),
        'ovhgseq': 'RGCY',
    }
rest_dict['Eco24I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco31I>GGTCTC)|(?P<Eco31I_as>GAGACC)',
        'results': None,
        'site': 'GGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, 5, None, None, 'GGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Eco31I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco32I>GATATC)',
        'results': None,
        'site': 'GATATC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GATATC'),
        'ovhgseq': '',
    }
rest_dict['Eco32I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco47I>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['Eco47I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco47III>AGCGCT)',
        'results': None,
        'site': 'AGCGCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'M', 'R'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGCGCT'),
        'ovhgseq': '',
    }
rest_dict['Eco47III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco52I>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['Eco52I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco53kI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GAGCTC'),
        'ovhgseq': '',
    }
rest_dict['Eco53kI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco57I>CTGAAG)|(?P<Eco57I_as>CTTCAG)',
        'results': None,
        'site': 'CTGAAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTGAAG'),
        'ovhgseq': 'NN',
    }
rest_dict['Eco57I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco57MI>CTG[AG]AG)|(?P<Eco57MI_as>CT[CT]CAG)',
        'results': None,
        'site': 'CTGRAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTGRAG'),
        'ovhgseq': 'NN',
    }
rest_dict['Eco57MI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco72I>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['Eco72I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco81I>CCT.AGG)',
        'results': None,
        'site': 'CCTNAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq': 'TNA',
    }
rest_dict['Eco81I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco88I>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['Eco88I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Eco91I>GGT.ACC)',
        'results': None,
        'site': 'GGTNACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTNACC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['Eco91I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoE1140I>ACC[CT]AC)|(?P<EcoE1140I_as>GT[AG]GGT)',
        'results': None,
        'site': 'ACCYAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ACCYAC'),
        'ovhgseq': None,
    }
rest_dict['EcoE1140I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoHI>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCSGG'),
        'ovhgseq': 'CCSGG',
    }
rest_dict['EcoHI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoICRI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'R', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GAGCTC'),
        'ovhgseq': '',
    }
rest_dict['EcoICRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoMII>CA.CATC)|(?P<EcoMII_as>GATG.TG)',
        'results': None,
        'site': 'CANCATC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CANCATC'),
        'ovhgseq': None,
    }
rest_dict['EcoMII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoNI>CCT.....AGG)',
        'results': None,
        'site': 'CCTNNNNNAGG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq': 'N',
    }
rest_dict['EcoNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoO109I>[AG]GG.CC[CT])',
        'results': None,
        'site': 'RGGNCCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'N'),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGGNCCY'),
        'ovhgseq': 'GNC',
    }
rest_dict['EcoO109I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoO65I>GGT.ACC)',
        'results': None,
        'site': 'GGTNACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTNACC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['EcoO65I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoRI>GAATTC)',
        'results': None,
        'site': 'GAATTC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GAATTC'),
        'ovhgseq': 'AATT',
    }
rest_dict['EcoRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoRII>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B', 'J'),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCWGG'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['EcoRII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoRV>GATATC)',
        'results': None,
        'site': 'GATATC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GATATC'),
        'ovhgseq': '',
    }
rest_dict['EcoRV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoT14I>CC[AT][AT]GG)',
        'results': None,
        'site': 'CCWWGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCWWGG'),
        'ovhgseq': 'CWWG',
    }
rest_dict['EcoT14I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoT22I>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (5, -5, None, None, 'ATGCAT'),
        'ovhgseq': 'TGCA',
    }
rest_dict['EcoT22I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EcoT38I>G[AG]GC[CT]C)',
        'results': None,
        'site': 'GRGCYC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('J',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GRGCYC'),
        'ovhgseq': 'RGCY',
    }
rest_dict['EcoT38I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EgeI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGCGCC'),
        'ovhgseq': '',
    }
rest_dict['EgeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EheI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGCGCC'),
        'ovhgseq': '',
    }
rest_dict['EheI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ErhI>CC[AT][AT]GG)',
        'results': None,
        'site': 'CCWWGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCWWGG'),
        'ovhgseq': 'CWWG',
    }
rest_dict['ErhI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EsaBC3I>TCGA)',
        'results': None,
        'site': 'TCGA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'TCGA'),
        'ovhgseq': '',
    }
rest_dict['EsaBC3I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EsaSSI>GACCAC)|(?P<EsaSSI_as>GTGGTC)',
        'results': None,
        'site': 'GACCAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GACCAC'),
        'ovhgseq': None,
    }
rest_dict['EsaSSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Esp3007I>CAGAAG)|(?P<Esp3007I_as>CTTCTG)',
        'results': None,
        'site': 'CAGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CAGAAG'),
        'ovhgseq': None,
    }
rest_dict['Esp3007I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Esp3I>CGTCTC)|(?P<Esp3I_as>GAGACG)',
        'results': None,
        'site': 'CGTCTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, 5, None, None, 'CGTCTC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Esp3I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<EspI>GCT.AGC)',
        'results': None,
        'site': 'GCTNAGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCTNAGC'),
        'ovhgseq': 'TNA',
    }
rest_dict['EspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FaeI>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CATG'),
        'ovhgseq': 'CATG',
    }
rest_dict['FaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FaiI>[CT]AT[AG])',
        'results': None,
        'site': 'YATR',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 64,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'YATR'),
        'ovhgseq': '',
    }
rest_dict['FaiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FalI>AAG.....CTT)',
        'results': None,
        'site': 'AAGNNNNNCTT',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -8,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 8,
        'suppl': ('I',),
        'scd5': 24,
        'charac': (-8, -24, 24, 8, 'AAGNNNNNCTT'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['FalI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FaqI>GGGAC)|(?P<FaqI_as>GTCCC)',
        'results': None,
        'site': 'GGGAC',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 15,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (15, 14, None, None, 'GGGAC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['FaqI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FatI>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (0, 0, None, None, 'CATG'),
        'ovhgseq': 'CATG',
    }
rest_dict['FatI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FauI>CCCGC)|(?P<FauI_as>GCGGG)',
        'results': None,
        'site': 'CCCGC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (9, 6, None, None, 'CCCGC'),
        'ovhgseq': 'NN',
    }
rest_dict['FauI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FauNDI>CATATG)',
        'results': None,
        'site': 'CATATG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CATATG'),
        'ovhgseq': 'TA',
    }
rest_dict['FauNDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FbaI>TGATCA)',
        'results': None,
        'site': 'TGATCA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGATCA'),
        'ovhgseq': 'GATC',
    }
rest_dict['FbaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FblI>GT[AC][GT]AC)',
        'results': None,
        'site': 'GTMKAC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GTMKAC'),
        'ovhgseq': 'MK',
    }
rest_dict['FblI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FinI>GGGAC)|(?P<FinI_as>GTCCC)',
        'results': None,
        'site': 'GGGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGGAC'),
        'ovhgseq': None,
    }
rest_dict['FinI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FmuI>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['FmuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Fnu4HI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['Fnu4HI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FnuDII>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['FnuDII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FokI>GGATG)|(?P<FokI_as>CATCC)',
        'results': None,
        'site': 'GGATG',
        'substrat': 'DNA',
        'fst3': 13,
        'fst5': 14,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (14, 13, None, None, 'GGATG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['FokI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FriOI>G[AG]GC[CT]C)',
        'results': None,
        'site': 'GRGCYC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GRGCYC'),
        'ovhgseq': 'RGCY',
    }
rest_dict['FriOI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FseI>GGCCGGCC)',
        'results': None,
        'site': 'GGCCGGCC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (6, -6, None, None, 'GGCCGGCC'),
        'ovhgseq': 'CCGG',
    }
rest_dict['FseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Fsp4HI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['Fsp4HI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FspAI>[AG]TGCGCA[CT])',
        'results': None,
        'site': 'RTGCGCAY',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 16384,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'RTGCGCAY'),
        'ovhgseq': '',
    }
rest_dict['FspAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FspBI>CTAG)',
        'results': None,
        'site': 'CTAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTAG'),
        'ovhgseq': 'TA',
    }
rest_dict['FspBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FspEI>CC)|(?P<FspEI_as>GG)',
        'results': None,
        'site': 'CC',
        'substrat': 'DNA',
        'fst3': 16,
        'fst5': 14,
        'freq': 16,
        'size': 2,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (14, 16, None, None, 'CC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['FspEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FspI>TGCGCA)',
        'results': None,
        'site': 'TGCGCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('J', 'N'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGCGCA'),
        'ovhgseq': '',
    }
rest_dict['FspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<FtnUV>GAAACA)|(?P<FtnUV_as>TGTTTC)',
        'results': None,
        'site': 'GAAACA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAACA'),
        'ovhgseq': None,
    }
rest_dict['FtnUV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GauT27I>CGCGCAGG)|(?P<GauT27I_as>CCTGCGCG)',
        'results': None,
        'site': 'CGCGCAGG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGCGCAGG'),
        'ovhgseq': None,
    }
rest_dict['GauT27I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Gba708II>ATGCAC)|(?P<Gba708II_as>GTGCAT)',
        'results': None,
        'site': 'ATGCAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ATGCAC'),
        'ovhgseq': None,
    }
rest_dict['Gba708II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GdiII>CGGCC[AG])|(?P<GdiII_as>[CT]GGCCG)',
        'results': None,
        'site': 'CGGCCR',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCR'),
        'ovhgseq': 'GGCC',
    }
rest_dict['GdiII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GlaI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCGC'),
        'ovhgseq': '',
    }
rest_dict['GlaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GluI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['GluI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GsaI>CCCAGC)|(?P<GsaI_as>GCTGGG)',
        'results': None,
        'site': 'CCCAGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CCCAGC'),
        'ovhgseq': 'CCAG',
    }
rest_dict['GsaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<GsuI>CTGGAG)|(?P<GsuI_as>CTCCAG)',
        'results': None,
        'site': 'CTGGAG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 22,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (22, 14, None, None, 'CTGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['GsuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HaeI>[AT]GGCC[AT])',
        'results': None,
        'site': 'WGGCCW',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'WGGCCW'),
        'ovhgseq': '',
    }
rest_dict['HaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HaeII>[AG]GCGC[CT])',
        'results': None,
        'site': 'RGCGCY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('J', 'K', 'N', 'R'),
        'scd5': None,
        'charac': (5, -5, None, None, 'RGCGCY'),
        'ovhgseq': 'GCGC',
    }
rest_dict['HaeII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HaeIII>GGCC)',
        'results': None,
        'site': 'GGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCC'),
        'ovhgseq': '',
    }
rest_dict['HaeIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HapII>CCGG)',
        'results': None,
        'site': 'CCGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGG'),
        'ovhgseq': 'CG',
    }
rest_dict['HapII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HauII>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 9, None, None, 'TGGCCA'),
        'ovhgseq': 'NN',
    }
rest_dict['HauII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HbaII>GCCCAG)|(?P<HbaII_as>CTGGGC)',
        'results': None,
        'site': 'GCCCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCCCAG'),
        'ovhgseq': None,
    }
rest_dict['HbaII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HgaI>GACGC)|(?P<HgaI_as>GCGTC)',
        'results': None,
        'site': 'GACGC',
        'substrat': 'DNA',
        'fst3': 10,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (10, 10, None, None, 'GACGC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['HgaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HgiAI>G[AT]GC[AT]C)',
        'results': None,
        'site': 'GWGCWC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (5, -5, None, None, 'GWGCWC'),
        'ovhgseq': 'WGCW',
    }
rest_dict['HgiAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HgiCI>GG[CT][AG]CC)',
        'results': None,
        'site': 'GGYRCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGYRCC'),
        'ovhgseq': 'GYRC',
    }
rest_dict['HgiCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HgiEII>ACC......GGT)',
        'results': None,
        'site': 'ACCNNNNNNGGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ACCNNNNNNGGT'),
        'ovhgseq': None,
    }
rest_dict['HgiEII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HgiJII>G[AG]GC[CT]C)',
        'results': None,
        'site': 'GRGCYC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (5, -5, None, None, 'GRGCYC'),
        'ovhgseq': 'RGCY',
    }
rest_dict['HgiJII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HhaI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'N', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['HhaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hin1I>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['Hin1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hin1II>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CATG'),
        'ovhgseq': 'CATG',
    }
rest_dict['Hin1II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hin4I>GA[CT].....[ACG]TC)|(?P<Hin4I_as>GA[CGT].....[AG]TC)',
        'results': None,
        'site': 'GAYNNNNNVTC',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -8,
        'freq': 512,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 8,
        'suppl': (),
        'scd5': 24,
        'charac': (-8, -24, 24, 8, 'GAYNNNNNVTC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['Hin4I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hin4II>CCTTC)|(?P<Hin4II_as>GAAGG)',
        'results': None,
        'site': 'CCTTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 11,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (11, 5, None, None, 'CCTTC'),
        'ovhgseq': 'N',
    }
rest_dict['Hin4II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hin6I>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['Hin6I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HinP1I>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['HinP1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HincII>GT[CT][AG]AC)',
        'results': None,
        'site': 'GTYRAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'N', 'O', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTYRAC'),
        'ovhgseq': '',
    }
rest_dict['HincII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HindII>GT[CT][AG]AC)',
        'results': None,
        'site': 'GTYRAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'M', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTYRAC'),
        'ovhgseq': '',
    }
rest_dict['HindII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HindIII>AAGCTT)',
        'results': None,
        'site': 'AAGCTT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'AAGCTT'),
        'ovhgseq': 'AGCT',
    }
rest_dict['HindIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HinfI>GA.TC)',
        'results': None,
        'site': 'GANTC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GANTC'),
        'ovhgseq': 'ANT',
    }
rest_dict['HinfI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpaI>GTTAAC)',
        'results': None,
        'site': 'GTTAAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTTAAC'),
        'ovhgseq': '',
    }
rest_dict['HpaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpaII>CCGG)',
        'results': None,
        'site': 'CCGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'I', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGG'),
        'ovhgseq': 'CG',
    }
rest_dict['HpaII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HphI>GGTGA)|(?P<HphI_as>TCACC)',
        'results': None,
        'site': 'GGTGA',
        'substrat': 'DNA',
        'fst3': 7,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B', 'N'),
        'scd5': None,
        'charac': (13, 7, None, None, 'GGTGA'),
        'ovhgseq': 'N',
    }
rest_dict['HphI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy166II>GT..AC)',
        'results': None,
        'site': 'GTNNAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTNNAC'),
        'ovhgseq': '',
    }
rest_dict['Hpy166II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy178III>TC..GA)',
        'results': None,
        'site': 'TCNNGA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'TCNNGA'),
        'ovhgseq': 'NN',
    }
rest_dict['Hpy178III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy188I>TC.GA)',
        'results': None,
        'site': 'TCNGA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TCNGA'),
        'ovhgseq': 'N',
    }
rest_dict['Hpy188I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy188III>TC..GA)',
        'results': None,
        'site': 'TCNNGA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TCNNGA'),
        'ovhgseq': 'NN',
    }
rest_dict['Hpy188III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy8I>GT..AC)',
        'results': None,
        'site': 'GTNNAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTNNAC'),
        'ovhgseq': '',
    }
rest_dict['Hpy8I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy99I>CG[AT]CG)',
        'results': None,
        'site': 'CGWCG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CGWCG'),
        'ovhgseq': 'CGWCG',
    }
rest_dict['Hpy99I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy99XIII>GCCTA)|(?P<Hpy99XIII_as>TAGGC)',
        'results': None,
        'site': 'GCCTA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCCTA'),
        'ovhgseq': None,
    }
rest_dict['Hpy99XIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy99XIV>GG[AT]TAA)|(?P<Hpy99XIV_as>TTA[AT]CC)',
        'results': None,
        'site': 'GGWTAA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGWTAA'),
        'ovhgseq': None,
    }
rest_dict['Hpy99XIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy99XIV_mut1>GG[AT]C.A)|(?P<Hpy99XIV_mut1_as>T.G[AT]CC)',
        'results': None,
        'site': 'GGWCNA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 512,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGWCNA'),
        'ovhgseq': None,
    }
rest_dict['Hpy99XIV_mut1'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hpy99XXII>TCA......T[AG]G)|(?P<Hpy99XXII_as>C[CT]A......TGA)',
        'results': None,
        'site': 'TCANNNNNNTRG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TCANNNNNNTRG'),
        'ovhgseq': None,
    }
rest_dict['Hpy99XXII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyAV>CCTTC)|(?P<HpyAV_as>GAAGG)',
        'results': None,
        'site': 'CCTTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 11,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (11, 5, None, None, 'CCTTC'),
        'ovhgseq': 'N',
    }
rest_dict['HpyAV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyAXIV>GCGTA)|(?P<HpyAXIV_as>TACGC)',
        'results': None,
        'site': 'GCGTA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGTA'),
        'ovhgseq': None,
    }
rest_dict['HpyAXIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyAXVI_mut1>C[AG]TTAA)|(?P<HpyAXVI_mut1_as>TTAA[CT]G)',
        'results': None,
        'site': 'CRTTAA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CRTTAA'),
        'ovhgseq': None,
    }
rest_dict['HpyAXVI_mut1'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyAXVI_mut2>C[AG]TC.A)|(?P<HpyAXVI_mut2_as>T.GA[CT]G)',
        'results': None,
        'site': 'CRTCNA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 512,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CRTCNA'),
        'ovhgseq': None,
    }
rest_dict['HpyAXVI_mut2'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyCH4III>AC.GT)',
        'results': None,
        'site': 'ACNGT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'ACNGT'),
        'ovhgseq': 'N',
    }
rest_dict['HpyCH4III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyCH4IV>ACGT)',
        'results': None,
        'site': 'ACGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACGT'),
        'ovhgseq': 'CG',
    }
rest_dict['HpyCH4IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyCH4V>TGCA)',
        'results': None,
        'site': 'TGCA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TGCA'),
        'ovhgseq': '',
    }
rest_dict['HpyCH4V'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyF10VI>GC.......GC)',
        'results': None,
        'site': 'GCNNNNNNNGC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq': 'NNN',
    }
rest_dict['HpyF10VI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyF3I>CT.AG)',
        'results': None,
        'site': 'CTNAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTNAG'),
        'ovhgseq': 'TNA',
    }
rest_dict['HpyF3I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpySE526I>ACGT)',
        'results': None,
        'site': 'ACGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACGT'),
        'ovhgseq': 'CG',
    }
rest_dict['HpySE526I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyUM032XIII>C[CT]A.......T[AG]G)',
        'results': None,
        'site': 'CYANNNNNNNTRG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CYANNNNNNNTRG'),
        'ovhgseq': None,
    }
rest_dict['HpyUM032XIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyUM032XIII_mut1>C[CT]A.......TTC)|(?P<HpyUM032XIII_mut1_as>GAA.......T[AG]G)',
        'results': None,
        'site': 'CYANNNNNNNTTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CYANNNNNNNTTC'),
        'ovhgseq': None,
    }
rest_dict['HpyUM032XIII_mut1'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyUM032XIV>GAAAG)|(?P<HpyUM032XIV_as>CTTTC)',
        'results': None,
        'site': 'GAAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAAG'),
        'ovhgseq': None,
    }
rest_dict['HpyUM032XIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HpyUM037X>T.GG.AG)|(?P<HpyUM037X_as>CT.CC.A)',
        'results': None,
        'site': 'TNGGNAG|GTGGNAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TNGGNAG|GTGGNAG'),
        'ovhgseq': None,
    }
rest_dict['HpyUM037X'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hsp92I>G[AG]CG[CT]C)',
        'results': None,
        'site': 'GRCGYC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('R',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GRCGYC'),
        'ovhgseq': 'CG',
    }
rest_dict['Hsp92I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Hsp92II>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('R',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CATG'),
        'ovhgseq': 'CATG',
    }
rest_dict['Hsp92II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<HspAI>GCGC)',
        'results': None,
        'site': 'GCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['HspAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Jma19592I>GTAT.AC)|(?P<Jma19592I_as>GT.ATAC)',
        'results': None,
        'site': 'GTATNAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTATNAC'),
        'ovhgseq': None,
    }
rest_dict['Jma19592I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Jma19592II>G[AG]GC[AG]AC)|(?P<Jma19592II_as>GT[CT]GC[CT]C)',
        'results': None,
        'site': 'GRGCRAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GRGCRAC'),
        'ovhgseq': None,
    }
rest_dict['Jma19592II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KasI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGCGCC'),
        'ovhgseq': 'GCGC',
    }
rest_dict['KasI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KflI>GGG[AT]CCC)',
        'results': None,
        'site': 'GGGWCCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGGWCCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['KflI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Kpn2I>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Kpn2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KpnI>GGTACC)',
        'results': None,
        'site': 'GGTACC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GGTACC'),
        'ovhgseq': 'GTAC',
    }
rest_dict['KpnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KpnNIH30III>GTTC.AC)|(?P<KpnNIH30III_as>GT.GAAC)',
        'results': None,
        'site': 'GTTCNAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTTCNAC'),
        'ovhgseq': None,
    }
rest_dict['KpnNIH30III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KroI>GCCGGC)',
        'results': None,
        'site': 'GCCGGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCCGGC'),
        'ovhgseq': 'CCGG',
    }
rest_dict['KroI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ksp22I>TGATCA)',
        'results': None,
        'site': 'TGATCA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TGATCA'),
        'ovhgseq': 'GATC',
    }
rest_dict['Ksp22I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ksp632I>CTCTTC)|(?P<Ksp632I_as>GAAGAG)',
        'results': None,
        'site': 'CTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (7, 4, None, None, 'CTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['Ksp632I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KspAI>GTTAAC)',
        'results': None,
        'site': 'GTTAAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTTAAC'),
        'ovhgseq': '',
    }
rest_dict['KspAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<KspI>CCGCGG)',
        'results': None,
        'site': 'CCGCGG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('M', 'S'),
        'scd5': None,
        'charac': (4, -4, None, None, 'CCGCGG'),
        'ovhgseq': 'GC',
    }
rest_dict['KspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Kzo9I>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['Kzo9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lba2029III>C[CT]AAA.G)|(?P<Lba2029III_as>C.TTT[AG]G)',
        'results': None,
        'site': 'CYAAANG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CYAAANG'),
        'ovhgseq': None,
    }
rest_dict['Lba2029III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<LguI>GCTCTTC)|(?P<LguI_as>GAAGAGC)',
        'results': None,
        'site': 'GCTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 8,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['LguI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<LmnI>GCTCC)|(?P<LmnI_as>GGAGC)',
        'results': None,
        'site': 'GCTCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 6,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (6, -1, None, None, 'GCTCC'),
        'ovhgseq': 'CN',
    }
rest_dict['LmnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lmo370I>AGCGCCG)|(?P<Lmo370I_as>CGGCGCT)',
        'results': None,
        'site': 'AGCGCCG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AGCGCCG'),
        'ovhgseq': None,
    }
rest_dict['Lmo370I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lmo911II>TAG[AG]AG)|(?P<Lmo911II_as>CT[CT]CTA)',
        'results': None,
        'site': 'TAGRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TAGRAG'),
        'ovhgseq': None,
    }
rest_dict['Lmo911II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<LpnI>[AG]GCGC[CT])',
        'results': None,
        'site': 'RGCGCY',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'RGCGCY'),
        'ovhgseq': '',
    }
rest_dict['LpnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<LpnPI>CC[AGT]G)|(?P<LpnPI_as>C[ACT]GG)',
        'results': None,
        'site': 'CCDG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 14,
        'freq': 64,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (14, 14, None, None, 'CCDG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['LpnPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lsp1109I>GCAGC)|(?P<Lsp1109I_as>GCTGC)',
        'results': None,
        'site': 'GCAGC',
        'substrat': 'DNA',
        'fst3': 12,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (13, 12, None, None, 'GCAGC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Lsp1109I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lsp48III>AGCACC)|(?P<Lsp48III_as>GGTGCT)',
        'results': None,
        'site': 'AGCACC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AGCACC'),
        'ovhgseq': None,
    }
rest_dict['Lsp48III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Lsp6406VI>C[AG]AGCAC)|(?P<Lsp6406VI_as>GTGCT[CT]G)',
        'results': None,
        'site': 'CRAGCAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CRAGCAC'),
        'ovhgseq': None,
    }
rest_dict['Lsp6406VI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<LweI>GCATC)|(?P<LweI_as>GATGC)',
        'results': None,
        'site': 'GCATC',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (10, 9, None, None, 'GCATC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['LweI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MabI>ACC[AT]GGT)',
        'results': None,
        'site': 'ACCWGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['MabI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MaeI>CTAG)',
        'results': None,
        'site': 'CTAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTAG'),
        'ovhgseq': 'TA',
    }
rest_dict['MaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MaeII>ACGT)',
        'results': None,
        'site': 'ACGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACGT'),
        'ovhgseq': 'CG',
    }
rest_dict['MaeII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MaeIII>GT.AC)',
        'results': None,
        'site': 'GTNAC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GTNAC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['MaeIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MalI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GATC'),
        'ovhgseq': '',
    }
rest_dict['MalI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MaqI>C[AG]TTGAC)|(?P<MaqI_as>GTCAA[CT]G)',
        'results': None,
        'site': 'CRTTGAC',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 28,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (28, 19, None, None, 'CRTTGAC'),
        'ovhgseq': 'NN',
    }
rest_dict['MaqI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MauBI>CGCGCGCG)',
        'results': None,
        'site': 'CGCGCGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCGCGCG'),
        'ovhgseq': 'CGCG',
    }
rest_dict['MauBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mba11I>AGGCGA)|(?P<Mba11I_as>TCGCCT)',
        'results': None,
        'site': 'AGGCGA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'AGGCGA'),
        'ovhgseq': None,
    }
rest_dict['Mba11I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MbiI>CCGCTC)|(?P<MbiI_as>GAGCGG)',
        'results': None,
        'site': 'CCGCTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CCGCTC'),
        'ovhgseq': '',
    }
rest_dict['MbiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MboI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'K', 'N', 'Q', 'R', 'X', 'Y'),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['MboI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MboII>GAAGA)|(?P<MboII_as>TCTTC)',
        'results': None,
        'site': 'GAAGA',
        'substrat': 'DNA',
        'fst3': 7,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'N', 'Q', 'R', 'V', 'X'),
        'scd5': None,
        'charac': (13, 7, None, None, 'GAAGA'),
        'ovhgseq': 'N',
    }
rest_dict['MboII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<McaTI>GCGCGC)',
        'results': None,
        'site': 'GCGCGC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'GCGCGC'),
        'ovhgseq': 'GC',
    }
rest_dict['McaTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mcr10I>GAAG.....CTC)|(?P<Mcr10I_as>GAG.....CTTC)',
        'results': None,
        'site': 'GAAGNNNNNCTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAGNNNNNCTC'),
        'ovhgseq': None,
    }
rest_dict['Mcr10I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<McrI>CG[AG][CT]CG)',
        'results': None,
        'site': 'CGRYCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGRYCG'),
        'ovhgseq': 'RY',
    }
rest_dict['McrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MfeI>CAATTG)',
        'results': None,
        'site': 'CAATTG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CAATTG'),
        'ovhgseq': 'AATT',
    }
rest_dict['MfeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MflI>[AG]GATC[CT])',
        'results': None,
        'site': 'RGATCY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RGATCY'),
        'ovhgseq': 'GATC',
    }
rest_dict['MflI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MhlI>G[AGT]GC[ACT]C)',
        'results': None,
        'site': 'GDGCHC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GDGCHC'),
        'ovhgseq': 'DGCH',
    }
rest_dict['MhlI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MjaIV>GT..AC)',
        'results': None,
        'site': 'GTNNAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTNNAC'),
        'ovhgseq': None,
    }
rest_dict['MjaIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MkaDII>GAGA[CT]GT)|(?P<MkaDII_as>AC[AG]TCTC)',
        'results': None,
        'site': 'GAGAYGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAGAYGT'),
        'ovhgseq': None,
    }
rest_dict['MkaDII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MlsI>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['MlsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MluCI>AATT)',
        'results': None,
        'site': 'AATT',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'AATT'),
        'ovhgseq': 'AATT',
    }
rest_dict['MluCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MluI>ACGCGT)',
        'results': None,
        'site': 'ACGCGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACGCGT'),
        'ovhgseq': 'CGCG',
    }
rest_dict['MluI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MluNI>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['MluNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mly113I>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCGCC'),
        'ovhgseq': 'CG',
    }
rest_dict['Mly113I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MlyI>GAGTC)|(?P<MlyI_as>GACTC)',
        'results': None,
        'site': 'GAGTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (10, 5, None, None, 'GAGTC'),
        'ovhgseq': '',
    }
rest_dict['MlyI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MmeI>TCC[AG]AC)|(?P<MmeI_as>GT[CT]GGA)',
        'results': None,
        'site': 'TCCRAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N', 'X'),
        'scd5': None,
        'charac': (26, 18, None, None, 'TCCRAC'),
        'ovhgseq': 'NN',
    }
rest_dict['MmeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MnlI>CCTC)|(?P<MnlI_as>GAGG)',
        'results': None,
        'site': 'CCTC',
        'substrat': 'DNA',
        'fst3': 6,
        'fst5': 11,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B', 'I', 'N', 'Q', 'V', 'X'),
        'scd5': None,
        'charac': (11, 6, None, None, 'CCTC'),
        'ovhgseq': 'N',
    }
rest_dict['MnlI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mox20I>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['Mox20I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mph1103I>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'ATGCAT'),
        'ovhgseq': 'TGCA',
    }
rest_dict['Mph1103I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MreI>CGCCGGCG)',
        'results': None,
        'site': 'CGCCGGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCCGGCG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['MreI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MroI>TCCGGA)',
        'results': None,
        'site': 'TCCGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('M', 'O'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCGGA'),
        'ovhgseq': 'CCGG',
    }
rest_dict['MroI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MroNI>GCCGGC)',
        'results': None,
        'site': 'GCCGGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCCGGC'),
        'ovhgseq': 'CCGG',
    }
rest_dict['MroNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MroXI>GAA....TTC)',
        'results': None,
        'site': 'GAANNNNTTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq': '',
    }
rest_dict['MroXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MscI>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N', 'O'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['MscI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MseI>TTAA)',
        'results': None,
        'site': 'TTAA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TTAA'),
        'ovhgseq': 'TA',
    }
rest_dict['MseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MslI>CA[CT]....[AG]TG)',
        'results': None,
        'site': 'CAYNNNNRTG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq': '',
    }
rest_dict['MslI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Msp20I>TGGCCA)',
        'results': None,
        'site': 'TGGCCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGGCCA'),
        'ovhgseq': '',
    }
rest_dict['Msp20I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspA1I>C[AC]GC[GT]G)',
        'results': None,
        'site': 'CMGCKG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'N', 'R', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CMGCKG'),
        'ovhgseq': '',
    }
rest_dict['MspA1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspCI>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['MspCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspI>CCGG)',
        'results': None,
        'site': 'CCGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'I', 'J', 'K', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGG'),
        'ovhgseq': 'CG',
    }
rest_dict['MspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspI7II>ACG[AG]AG)|(?P<MspI7II_as>CT[CT]CGT)',
        'results': None,
        'site': 'ACGRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ACGRAG'),
        'ovhgseq': None,
    }
rest_dict['MspI7II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspJI>C..[AG])|(?P<MspJI_as>[CT]..G)',
        'results': None,
        'site': 'CNNR',
        'substrat': 'DNA',
        'fst3': 13,
        'fst5': 13,
        'freq': 8,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (13, 13, None, None, 'CNNR'),
        'ovhgseq': 'NNNN',
    }
rest_dict['MspJI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MspR9I>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCNGG'),
        'ovhgseq': 'N',
    }
rest_dict['MspR9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MssI>GTTTAAAC)',
        'results': None,
        'site': 'GTTTAAAC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GTTTAAAC'),
        'ovhgseq': '',
    }
rest_dict['MssI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MstI>TGCGCA)',
        'results': None,
        'site': 'TGCGCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGCGCA'),
        'ovhgseq': '',
    }
rest_dict['MstI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MteI>GCGC.GCGC)',
        'results': None,
        'site': 'GCGCNGCGC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GCGCNGCGC'),
        'ovhgseq': 'N',
    }
rest_dict['MteI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MtuHN878II>CACGCAG)|(?P<MtuHN878II_as>CTGCGTG)',
        'results': None,
        'site': 'CACGCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CACGCAG'),
        'ovhgseq': None,
    }
rest_dict['MtuHN878II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MunI>CAATTG)',
        'results': None,
        'site': 'CAATTG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'K', 'M'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CAATTG'),
        'ovhgseq': 'AATT',
    }
rest_dict['MunI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Mva1269I>GAATGC)|(?P<Mva1269I_as>GCATTC)',
        'results': None,
        'site': 'GAATGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, -1, None, None, 'GAATGC'),
        'ovhgseq': 'CN',
    }
rest_dict['Mva1269I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MvaI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B', 'M', 'S'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCWGG'),
        'ovhgseq': 'W',
    }
rest_dict['MvaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MvnI>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCG'),
        'ovhgseq': '',
    }
rest_dict['MvnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<MwoI>GC.......GC)',
        'results': None,
        'site': 'GCNNNNNNNGC',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 256,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
        'ovhgseq': 'NNN',
    }
rest_dict['MwoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NaeI>GCCGGC)',
        'results': None,
        'site': 'GCCGGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('C', 'K', 'N'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCCGGC'),
        'ovhgseq': '',
    }
rest_dict['NaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Nal45188II>ACCAGC)|(?P<Nal45188II_as>GCTGGT)',
        'results': None,
        'site': 'ACCAGC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'ACCAGC'),
        'ovhgseq': None,
    }
rest_dict['Nal45188II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NarI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('J', 'M', 'N', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCGCC'),
        'ovhgseq': 'CG',
    }
rest_dict['NarI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NciI>CC[CG]GG)',
        'results': None,
        'site': 'CCSGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('J', 'N', 'R'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCSGG'),
        'ovhgseq': 'S',
    }
rest_dict['NciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NcoI>CCATGG)',
        'results': None,
        'site': 'CCATGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCATGG'),
        'ovhgseq': 'CATG',
    }
rest_dict['NcoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NdeI>CATATG)',
        'results': None,
        'site': 'CATATG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CATATG'),
        'ovhgseq': 'TA',
    }
rest_dict['NdeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NdeII>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('J', 'M'),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['NdeII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NgoAVII>GCCGC)|(?P<NgoAVII_as>GCGGC)',
        'results': None,
        'site': 'GCCGC',
        'substrat': 'DNA',
        'fst3': 7,
        'fst5': 12,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (12, 7, None, None, 'GCCGC'),
        'ovhgseq': '',
    }
rest_dict['NgoAVII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NgoAVIII>GAC.....TGA)|(?P<NgoAVIII_as>TCA.....GTC)',
        'results': None,
        'site': 'GACNNNNNTGA',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -12,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 11,
        'suppl': (),
        'scd5': 24,
        'charac': (-12, -25, 24, 11, 'GACNNNNNTGA'),
        'ovhgseq': 'NN',
    }
rest_dict['NgoAVIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NgoMIV>GCCGGC)',
        'results': None,
        'site': 'GCCGGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCCGGC'),
        'ovhgseq': 'CCGG',
    }
rest_dict['NgoMIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NhaXI>CAAG[AG]AG)|(?P<NhaXI_as>CT[CT]CTTG)',
        'results': None,
        'site': 'CAAGRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CAAGRAG'),
        'ovhgseq': None,
    }
rest_dict['NhaXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NheI>GCTAGC)',
        'results': None,
        'site': 'GCTAGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCTAGC'),
        'ovhgseq': 'CTAG',
    }
rest_dict['NheI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NhoI>GC[AT]GC)',
        'results': None,
        'site': 'GCWGC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCWGC'),
        'ovhgseq': None,
    }
rest_dict['NhoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NlaCI>CATCAC)|(?P<NlaCI_as>GTGATG)',
        'results': None,
        'site': 'CATCAC',
        'substrat': 'DNA',
        'fst3': 17,
        'fst5': 25,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (25, 17, None, None, 'CATCAC'),
        'ovhgseq': 'NN',
    }
rest_dict['NlaCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NlaIII>CATG)',
        'results': None,
        'site': 'CATG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CATG'),
        'ovhgseq': 'CATG',
    }
rest_dict['NlaIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NlaIV>GG..CC)',
        'results': None,
        'site': 'GGNNCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGNNCC'),
        'ovhgseq': '',
    }
rest_dict['NlaIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Nli3877I>C[CT]CG[AG]G)',
        'results': None,
        'site': 'CYCGRG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (5, -5, None, None, 'CYCGRG'),
        'ovhgseq': 'YCGR',
    }
rest_dict['Nli3877I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NmeAIII>GCCGAG)|(?P<NmeAIII_as>CTCGGC)',
        'results': None,
        'site': 'GCCGAG',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 27,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (27, 19, None, None, 'GCCGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['NmeAIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NmeDI>[AG]CCGG[CT])',
        'results': None,
        'site': 'RCCGGY',
        'substrat': 'DNA',
        'fst3': -13,
        'fst5': -12,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': 12,
        'suppl': (),
        'scd5': 13,
        'charac': (-12, -13, 13, 12, 'RCCGGY'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['NmeDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NmuCI>GT[CG]AC)',
        'results': None,
        'site': 'GTSAC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GTSAC'),
        'ovhgseq': 'GTSAC',
    }
rest_dict['NmuCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NotI>GCGGCCGC)',
        'results': None,
        'site': 'GCGGCCGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCGGCCGC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['NotI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NruI>TCGCGA)',
        'results': None,
        'site': 'TCGCGA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TCGCGA'),
        'ovhgseq': '',
    }
rest_dict['NruI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NsbI>TGCGCA)',
        'results': None,
        'site': 'TGCGCA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TGCGCA'),
        'ovhgseq': '',
    }
rest_dict['NsbI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NsiI>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('J', 'M', 'N', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'ATGCAT'),
        'ovhgseq': 'TGCA',
    }
rest_dict['NsiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NspBII>C[AC]GC[GT]G)',
        'results': None,
        'site': 'CMGCKG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'CMGCKG'),
        'ovhgseq': '',
    }
rest_dict['NspBII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NspI>[AG]CATG[CT])',
        'results': None,
        'site': 'RCATGY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'RCATGY'),
        'ovhgseq': 'CATG',
    }
rest_dict['NspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<NspV>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('J',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['NspV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<OliI>CAC....GTG)',
        'results': None,
        'site': 'CACNNNNGTG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CACNNNNGTG'),
        'ovhgseq': '',
    }
rest_dict['OliI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<OspHL35III>[CT]AGGAG)|(?P<OspHL35III_as>CTCCT[AG])',
        'results': None,
        'site': 'YAGGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'YAGGAG'),
        'ovhgseq': None,
    }
rest_dict['OspHL35III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PabI>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'GTAC'),
        'ovhgseq': 'TA',
    }
rest_dict['PabI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pac19842II>CCTTGA)|(?P<Pac19842II_as>TCAAGG)',
        'results': None,
        'site': 'CCTTGA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCTTGA'),
        'ovhgseq': None,
    }
rest_dict['Pac19842II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PacI>TTAATTAA)',
        'results': None,
        'site': 'TTAATTAA',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B', 'N', 'O'),
        'scd5': None,
        'charac': (5, -5, None, None, 'TTAATTAA'),
        'ovhgseq': 'AT',
    }
rest_dict['PacI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PaeI>GCATGC)',
        'results': None,
        'site': 'GCATGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCATGC'),
        'ovhgseq': 'CATG',
    }
rest_dict['PaeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PaeR7I>CTCGAG)',
        'results': None,
        'site': 'CTCGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTCGAG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['PaeR7I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PagI>TCATGA)',
        'results': None,
        'site': 'TCATGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCATGA'),
        'ovhgseq': 'CATG',
    }
rest_dict['PagI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pal408I>CC[AG]TGAG)|(?P<Pal408I_as>CTCA[CT]GG)',
        'results': None,
        'site': 'CCRTGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCRTGAG'),
        'ovhgseq': None,
    }
rest_dict['Pal408I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PalAI>GGCGCGCC)',
        'results': None,
        'site': 'GGCGCGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['PalAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PasI>CCC[AT]GGG)',
        'results': None,
        'site': 'CCCWGGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCCWGGG'),
        'ovhgseq': 'CWG',
    }
rest_dict['PasI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PauI>GCGCGC)',
        'results': None,
        'site': 'GCGCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGCGC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['PauI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PceI>AGGCCT)',
        'results': None,
        'site': 'AGGCCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGGCCT'),
        'ovhgseq': '',
    }
rest_dict['PceI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PciI>ACATGT)',
        'results': None,
        'site': 'ACATGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACATGT'),
        'ovhgseq': 'CATG',
    }
rest_dict['PciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PciSI>GCTCTTC)|(?P<PciSI_as>GAAGAGC)',
        'results': None,
        'site': 'GCTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 8,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['PciSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PcsI>[AT]CG.......CG[AT])',
        'results': None,
        'site': 'WCGNNNNNNNCGW',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 1024,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (7, -7, None, None, 'WCGNNNNNNNCGW'),
        'ovhgseq': 'N',
    }
rest_dict['PcsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PctI>GAATGC)|(?P<PctI_as>GCATTC)',
        'results': None,
        'site': 'GAATGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (7, -1, None, None, 'GAATGC'),
        'ovhgseq': 'CN',
    }
rest_dict['PctI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pdi8503III>CCGG.AG)|(?P<Pdi8503III_as>CT.CCGG)',
        'results': None,
        'site': 'CCGGNAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCGGNAG'),
        'ovhgseq': None,
    }
rest_dict['Pdi8503III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PdiI>GCCGGC)',
        'results': None,
        'site': 'GCCGGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCCGGC'),
        'ovhgseq': '',
    }
rest_dict['PdiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PdmI>GAA....TTC)',
        'results': None,
        'site': 'GAANNNNTTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq': '',
    }
rest_dict['PdmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pdu1735I>CACCAC)|(?P<Pdu1735I_as>GTGGTG)',
        'results': None,
        'site': 'CACCAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CACCAC'),
        'ovhgseq': None,
    }
rest_dict['Pdu1735I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PenI>GCAGT)|(?P<PenI_as>ACTGC)',
        'results': None,
        'site': 'GCAGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCAGT'),
        'ovhgseq': None,
    }
rest_dict['PenI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PfeI>GA[AT]TC)',
        'results': None,
        'site': 'GAWTC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GAWTC'),
        'ovhgseq': 'AWT',
    }
rest_dict['PfeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pfl1108I>TCGTAG)|(?P<Pfl1108I_as>CTACGA)',
        'results': None,
        'site': 'TCGTAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TCGTAG'),
        'ovhgseq': None,
    }
rest_dict['Pfl1108I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pfl23II>CGTACG)',
        'results': None,
        'site': 'CGTACG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGTACG'),
        'ovhgseq': 'GTAC',
    }
rest_dict['Pfl23II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PflFI>GAC...GTC)',
        'results': None,
        'site': 'GACNNNGTC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['PflFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PflMI>CCA.....TGG)',
        'results': None,
        'site': 'CCANNNNNTGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['PflMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PfoI>TCC.GGA)',
        'results': None,
        'site': 'TCCNGGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCCNGGA'),
        'ovhgseq': 'CCNGG',
    }
rest_dict['PfoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PinAI>ACCGGT)',
        'results': None,
        'site': 'ACCGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCGGT'),
        'ovhgseq': 'CCGG',
    }
rest_dict['PinAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PkrI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['PkrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PlaDI>CATCAG)|(?P<PlaDI_as>CTGATG)',
        'results': None,
        'site': 'CATCAG',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 27,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 19, None, None, 'CATCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['PlaDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ple19I>CGATCG)',
        'results': None,
        'site': 'CGATCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGATCG'),
        'ovhgseq': 'AT',
    }
rest_dict['Ple19I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PleI>GAGTC)|(?P<PleI_as>GACTC)',
        'results': None,
        'site': 'GAGTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (9, 5, None, None, 'GAGTC'),
        'ovhgseq': 'N',
    }
rest_dict['PleI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PliMI>CGCCGAC)|(?P<PliMI_as>GTCGGCG)',
        'results': None,
        'site': 'CGCCGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGCCGAC'),
        'ovhgseq': None,
    }
rest_dict['PliMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PluTI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GGCGCC'),
        'ovhgseq': 'GCGC',
    }
rest_dict['PluTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PmaCI>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['PmaCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pme5II>GACGAG)|(?P<Pme5II_as>CTCGTC)',
        'results': None,
        'site': 'GACGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GACGAG'),
        'ovhgseq': None,
    }
rest_dict['Pme5II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PmeI>GTTTAAAC)',
        'results': None,
        'site': 'GTTTAAAC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GTTTAAAC'),
        'ovhgseq': '',
    }
rest_dict['PmeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PmeS132I>GACGAG)|(?P<PmeS132I_as>CTCGTC)',
        'results': None,
        'site': 'GACGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GACGAG'),
        'ovhgseq': None,
    }
rest_dict['PmeS132I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PmlI>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['PmlI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PpiI>GAAC.....CTC)|(?P<PpiI_as>GAG.....GTTC)',
        'results': None,
        'site': 'GAACNNNNNCTC',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -7,
        'freq': 16384,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 8,
        'suppl': (),
        'scd5': 25,
        'charac': (-7, -24, 25, 8, 'GAACNNNNNCTC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['PpiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PpsI>GAGTC)|(?P<PpsI_as>GACTC)',
        'results': None,
        'site': 'GAGTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 9,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (9, 5, None, None, 'GAGTC'),
        'ovhgseq': 'N',
    }
rest_dict['PpsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ppu10I>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'ATGCAT'),
        'ovhgseq': 'TGCA',
    }
rest_dict['Ppu10I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ppu21I>[CT]ACGT[AG])',
        'results': None,
        'site': 'YACGTR',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'YACGTR'),
        'ovhgseq': '',
    }
rest_dict['Ppu21I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PpuMI>[AG]GG[AT]CC[CT])',
        'results': None,
        'site': 'RGGWCCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 2048,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq': 'GWC',
    }
rest_dict['PpuMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PscI>ACATGT)',
        'results': None,
        'site': 'ACATGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACATGT'),
        'ovhgseq': 'CATG',
    }
rest_dict['PscI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pse18267I>[AG]CCGAAG)|(?P<Pse18267I_as>CTTCGG[CT])',
        'results': None,
        'site': 'RCCGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'RCCGAAG'),
        'ovhgseq': None,
    }
rest_dict['Pse18267I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PshAI>GAC....GTC)',
        'results': None,
        'site': 'GACNNNNGTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('K', 'N'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GACNNNNGTC'),
        'ovhgseq': '',
    }
rest_dict['PshAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PshBI>ATTAAT)',
        'results': None,
        'site': 'ATTAAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATTAAT'),
        'ovhgseq': 'TA',
    }
rest_dict['PshBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PsiI>TTATAA)',
        'results': None,
        'site': 'TTATAA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TTATAA'),
        'ovhgseq': '',
    }
rest_dict['PsiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp0357II>GCGAAG)|(?P<Psp0357II_as>CTTCGC)',
        'results': None,
        'site': 'GCGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGAAG'),
        'ovhgseq': None,
    }
rest_dict['Psp0357II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp03I>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (4, -4, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['Psp03I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp10HII>G[AG]AGCAG)|(?P<Psp10HII_as>CTGCT[CT]C)',
        'results': None,
        'site': 'GRAGCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GRAGCAG'),
        'ovhgseq': None,
    }
rest_dict['Psp10HII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp124BI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAGCTC'),
        'ovhgseq': 'AGCT',
    }
rest_dict['Psp124BI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp1406I>AACGTT)',
        'results': None,
        'site': 'AACGTT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (2, -2, None, None, 'AACGTT'),
        'ovhgseq': 'CG',
    }
rest_dict['Psp1406I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp5II>[AG]GG[AT]CC[CT])',
        'results': None,
        'site': 'RGGWCCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 2048,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq': 'GWC',
    }
rest_dict['Psp5II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Psp6I>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCWGG'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['Psp6I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspCI>CACGTG)',
        'results': None,
        'site': 'CACGTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CACGTG'),
        'ovhgseq': '',
    }
rest_dict['PspCI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspEI>GGT.ACC)',
        'results': None,
        'site': 'GGTNACC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGTNACC'),
        'ovhgseq': 'GTNAC',
    }
rest_dict['PspEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspFI>CCCAGC)|(?P<PspFI_as>GCTGGG)',
        'results': None,
        'site': 'CCCAGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCCAGC'),
        'ovhgseq': 'CCAG',
    }
rest_dict['PspFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspGI>CC[AT]GG)',
        'results': None,
        'site': 'CCWGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCWGG'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['PspGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspLI>CGTACG)',
        'results': None,
        'site': 'CGTACG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGTACG'),
        'ovhgseq': 'GTAC',
    }
rest_dict['PspLI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspN4I>GG..CC)',
        'results': None,
        'site': 'GGNNCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGNNCC'),
        'ovhgseq': '',
    }
rest_dict['PspN4I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspOMI>GGGCCC)',
        'results': None,
        'site': 'GGGCCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGGCCC'),
        'ovhgseq': 'GGCC',
    }
rest_dict['PspOMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspOMII>CGCCCA[AG])|(?P<PspOMII_as>[CT]TGGGCG)',
        'results': None,
        'site': 'CGCCCAR',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CGCCCAR'),
        'ovhgseq': 'NN',
    }
rest_dict['PspOMII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspPI>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['PspPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspPPI>[AG]GG[AT]CC[CT])',
        'results': None,
        'site': 'RGGWCCY',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 2048,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (2, -2, None, None, 'RGGWCCY'),
        'ovhgseq': 'GWC',
    }
rest_dict['PspPPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspPRI>CC[CT]CAG)|(?P<PspPRI_as>CTG[AG]GG)',
        'results': None,
        'site': 'CCYCAG',
        'substrat': 'DNA',
        'fst3': 13,
        'fst5': 21,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (21, 13, None, None, 'CCYCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['PspPRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PspXI>[ACG]CTCGAG[CGT])',
        'results': None,
        'site': 'VCTCGAGB',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N'),
        'scd5': None,
        'charac': (2, -2, None, None, 'VCTCGAGB'),
        'ovhgseq': 'TCGA',
    }
rest_dict['PspXI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PsrI>GAAC......TAC)|(?P<PsrI_as>GTA......GTTC)',
        'results': None,
        'site': 'GAACNNNNNNTAC',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -7,
        'freq': 16384,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': ('I',),
        'scd5': 25,
        'charac': (-7, -25, 25, 7, 'GAACNNNNNNTAC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['PsrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PssI>[AG]GG.CC[CT])',
        'results': None,
        'site': 'RGGNCCY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (5, -5, None, None, 'RGGNCCY'),
        'ovhgseq': 'GNC',
    }
rest_dict['PssI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Pst14472I>C.[CT]ACAC)|(?P<Pst14472I_as>GTGT[AG].G)',
        'results': None,
        'site': 'CNYACAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 2048,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CNYACAC'),
        'ovhgseq': None,
    }
rest_dict['Pst14472I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PstI>CTGCAG)',
        'results': None,
        'site': 'CTGCAG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'CTGCAG'),
        'ovhgseq': 'TGCA',
    }
rest_dict['PstI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PstNI>CAG...CTG)',
        'results': None,
        'site': 'CAGNNNCTG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CAGNNNCTG'),
        'ovhgseq': 'NNN',
    }
rest_dict['PstNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PsuGI>[CGT][CGT]CG[AGT])|(?P<PsuGI_as>[ACT]CG[ACG][ACG])',
        'results': None,
        'site': 'BBCGD',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'BBCGD'),
        'ovhgseq': None,
    }
rest_dict['PsuGI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PsuI>[AG]GATC[CT])',
        'results': None,
        'site': 'RGATCY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RGATCY'),
        'ovhgseq': 'GATC',
    }
rest_dict['PsuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PsyI>GAC...GTC)',
        'results': None,
        'site': 'GACNNNGTC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['PsyI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PteI>GCGCGC)',
        'results': None,
        'site': 'GCGCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCGCGC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['PteI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PvuI>CGATCG)',
        'results': None,
        'site': 'CGATCG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (4, -4, None, None, 'CGATCG'),
        'ovhgseq': 'AT',
    }
rest_dict['PvuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<PvuII>CAGCTG)',
        'results': None,
        'site': 'CAGCTG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CAGCTG'),
        'ovhgseq': '',
    }
rest_dict['PvuII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Rba2021I>CACGAG[ACT])|(?P<Rba2021I_as>[AGT]CTCGTG)',
        'results': None,
        'site': 'CACGAGH',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CACGAGH'),
        'ovhgseq': None,
    }
rest_dict['Rba2021I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RceI>CATCGAC)|(?P<RceI_as>GTCGATG)',
        'results': None,
        'site': 'CATCGAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CATCGAC'),
        'ovhgseq': 'NN',
    }
rest_dict['RceI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RdeGBI>CCGCAG)|(?P<RdeGBI_as>CTGCGG)',
        'results': None,
        'site': 'CCGCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCGCAG'),
        'ovhgseq': None,
    }
rest_dict['RdeGBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RdeGBII>ACCCAG)|(?P<RdeGBII_as>CTGGGT)',
        'results': None,
        'site': 'ACCCAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 26,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (26, 18, None, None, 'ACCCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['RdeGBII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RdeGBIII>TG[AG][CT]CA)',
        'results': None,
        'site': 'TGRYCA',
        'substrat': 'DNA',
        'fst3': -17,
        'fst5': -9,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 9,
        'suppl': (),
        'scd5': 17,
        'charac': (-9, -17, 17, 9, 'TGRYCA'),
        'ovhgseq': 'NN',
    }
rest_dict['RdeGBIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RflFIII>CGCCAG)|(?P<RflFIII_as>CTGGCG)',
        'results': None,
        'site': 'CGCCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGCCAG'),
        'ovhgseq': None,
    }
rest_dict['RflFIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RgaI>GCGATCGC)',
        'results': None,
        'site': 'GCGATCGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq': 'AT',
    }
rest_dict['RgaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RigI>GGCCGGCC)',
        'results': None,
        'site': 'GGCCGGCC',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (6, -6, None, None, 'GGCCGGCC'),
        'ovhgseq': 'CCGG',
    }
rest_dict['RigI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RlaI>[ACG]C[AT])|(?P<RlaI_as>[AT]G[CGT])',
        'results': None,
        'site': 'VCW',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8,
        'size': 3,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'VCW'),
        'ovhgseq': None,
    }
rest_dict['RlaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RleAI>CCCACA)|(?P<RleAI_as>TGTGGG)',
        'results': None,
        'site': 'CCCACA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 18,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (18, 9, None, None, 'CCCACA'),
        'ovhgseq': 'NNN',
    }
rest_dict['RleAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RpaB5I>CG[AG]GGAC)|(?P<RpaB5I_as>GTCC[CT]CG)',
        'results': None,
        'site': 'CGRGGAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CGRGGAC'),
        'ovhgseq': 'NN',
    }
rest_dict['RpaB5I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RpaBI>CCCGCAG)|(?P<RpaBI_as>CTGCGGG)',
        'results': None,
        'site': 'CCCGCAG',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CCCGCAG'),
        'ovhgseq': 'NN',
    }
rest_dict['RpaBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RpaI>GT[CT]GGAG)|(?P<RpaI_as>CTCC[AG]AC)',
        'results': None,
        'site': 'GTYGGAG',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 18,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (18, 9, None, None, 'GTYGGAG'),
        'ovhgseq': 'NN',
    }
rest_dict['RpaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RpaTI>G[AG]TGGAG)|(?P<RpaTI_as>CTCCA[CT]C)',
        'results': None,
        'site': 'GRTGGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GRTGGAG'),
        'ovhgseq': None,
    }
rest_dict['RpaTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RruI>TCGCGA)',
        'results': None,
        'site': 'TCGCGA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'TCGCGA'),
        'ovhgseq': '',
    }
rest_dict['RruI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RsaI>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'M', 'N', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (2, -2, None, None, 'GTAC'),
        'ovhgseq': '',
    }
rest_dict['RsaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RsaNI>GTAC)',
        'results': None,
        'site': 'GTAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTAC'),
        'ovhgseq': 'TA',
    }
rest_dict['RsaNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RseI>CA[CT]....[AG]TG)',
        'results': None,
        'site': 'CAYNNNNRTG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq': '',
    }
rest_dict['RseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Rsr2I>CGG[AT]CCG)',
        'results': None,
        'site': 'CGGWCCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq': 'GWC',
    }
rest_dict['Rsr2I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<RsrII>CGG[AT]CCG)',
        'results': None,
        'site': 'CGGWCCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N', 'Q', 'X'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGGWCCG'),
        'ovhgseq': 'GWC',
    }
rest_dict['RsrII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SacI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAGCTC'),
        'ovhgseq': 'AGCT',
    }
rest_dict['SacI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SacII>CCGCGG)',
        'results': None,
        'site': 'CCGCGG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'N', 'O', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (4, -4, None, None, 'CCGCGG'),
        'ovhgseq': 'GC',
    }
rest_dict['SacII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Saf8902III>CAAT.AG)|(?P<Saf8902III_as>CT.ATTG)',
        'results': None,
        'site': 'CAATNAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CAATNAG'),
        'ovhgseq': None,
    }
rest_dict['Saf8902III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SalI>GTCGAC)',
        'results': None,
        'site': 'GTCGAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTCGAC'),
        'ovhgseq': 'TCGA',
    }
rest_dict['SalI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SanDI>GGG[AT]CCC)',
        'results': None,
        'site': 'GGGWCCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGGWCCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['SanDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SapI>GCTCTTC)|(?P<SapI_as>GAAGAGC)',
        'results': None,
        'site': 'GCTCTTC',
        'substrat': 'DNA',
        'fst3': 4,
        'fst5': 8,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, 4, None, None, 'GCTCTTC'),
        'ovhgseq': 'NNN',
    }
rest_dict['SapI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SaqAI>TTAA)',
        'results': None,
        'site': 'TTAA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TTAA'),
        'ovhgseq': 'TA',
    }
rest_dict['SaqAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SatI>GC.GC)',
        'results': None,
        'site': 'GCNGC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GCNGC'),
        'ovhgseq': 'N',
    }
rest_dict['SatI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sau3AI>GATC)',
        'results': None,
        'site': 'GATC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C', 'J', 'K', 'M', 'N', 'R', 'S'),
        'scd5': None,
        'charac': (0, 0, None, None, 'GATC'),
        'ovhgseq': 'GATC',
    }
rest_dict['Sau3AI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sau96I>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('J', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGNCC'),
        'ovhgseq': 'GNC',
    }
rest_dict['Sau96I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SauI>CCT.AGG)',
        'results': None,
        'site': 'CCTNAGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCTNAGG'),
        'ovhgseq': 'TNA',
    }
rest_dict['SauI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SbfI>CCTGCAGG)',
        'results': None,
        'site': 'CCTGCAGG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq': 'TGCA',
    }
rest_dict['SbfI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sbo46I>TGAAC)|(?P<Sbo46I_as>GTTCA)',
        'results': None,
        'site': 'TGAAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TGAAC'),
        'ovhgseq': None,
    }
rest_dict['Sbo46I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ScaI>AGTACT)',
        'results': None,
        'site': 'AGTACT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGTACT'),
        'ovhgseq': '',
    }
rest_dict['ScaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SchI>GAGTC)|(?P<SchI_as>GACTC)',
        'results': None,
        'site': 'GAGTC',
        'substrat': 'DNA',
        'fst3': 5,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (10, 5, None, None, 'GAGTC'),
        'ovhgseq': '',
    }
rest_dict['SchI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SciI>CTCGAG)',
        'results': None,
        'site': 'CTCGAG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'CTCGAG'),
        'ovhgseq': '',
    }
rest_dict['SciI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ScrFI>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('J', 'N'),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCNGG'),
        'ovhgseq': 'N',
    }
rest_dict['ScrFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SdaI>CCTGCAGG)',
        'results': None,
        'site': 'CCTGCAGG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq': 'TGCA',
    }
rest_dict['SdaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SdeAI>CAG[AG]AG)|(?P<SdeAI_as>CT[CT]CTG)',
        'results': None,
        'site': 'CAGRAG',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 27,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 19, None, None, 'CAGRAG'),
        'ovhgseq': 'NN',
    }
rest_dict['SdeAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SdeOSI>GAC....[AG]TGA)|(?P<SdeOSI_as>TCA[CT]....GTC)',
        'results': None,
        'site': 'GACNNNNRTGA',
        'substrat': 'DNA',
        'fst3': -24,
        'fst5': -11,
        'freq': 8192,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': 10,
        'suppl': (),
        'scd5': 23,
        'charac': (-11, -24, 23, 10, 'GACNNNNRTGA'),
        'ovhgseq': 'NN',
    }
rest_dict['SdeOSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SduI>G[AGT]GC[ACT]C)',
        'results': None,
        'site': 'GDGCHC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GDGCHC'),
        'ovhgseq': 'DGCH',
    }
rest_dict['SduI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SecI>CC..GG)',
        'results': None,
        'site': 'CCNNGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCNNGG'),
        'ovhgseq': 'CNNG',
    }
rest_dict['SecI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SelI>CGCG)',
        'results': None,
        'site': 'CGCG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (0, 0, None, None, 'CGCG'),
        'ovhgseq': 'CGCG',
    }
rest_dict['SelI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sen13311III>GATCAG)|(?P<Sen13311III_as>CTGATC)',
        'results': None,
        'site': 'GATCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GATCAG'),
        'ovhgseq': None,
    }
rest_dict['Sen13311III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sen1736II>GATCAG)|(?P<Sen1736II_as>CTGATC)',
        'results': None,
        'site': 'GATCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GATCAG'),
        'ovhgseq': None,
    }
rest_dict['Sen1736II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SenTFIV>GATCAG)|(?P<SenTFIV_as>CTGATC)',
        'results': None,
        'site': 'GATCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GATCAG'),
        'ovhgseq': None,
    }
rest_dict['SenTFIV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SetI>A[CG][CG]T)',
        'results': None,
        'site': 'ASST',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 64,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (4, -4, None, None, 'ASST'),
        'ovhgseq': 'ASST',
    }
rest_dict['SetI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SexAI>ACC[AT]GGT)',
        'results': None,
        'site': 'ACCWGGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('M', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACCWGGT'),
        'ovhgseq': 'CCWGG',
    }
rest_dict['SexAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfaAI>GCGATCGC)',
        'results': None,
        'site': 'GCGATCGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq': 'AT',
    }
rest_dict['SfaAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfaNI>GCATC)|(?P<SfaNI_as>GATGC)',
        'results': None,
        'site': 'GCATC',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 10,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (10, 9, None, None, 'GCATC'),
        'ovhgseq': 'NNNN',
    }
rest_dict['SfaNI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfcI>CT[AG][CT]AG)',
        'results': None,
        'site': 'CTRYAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTRYAG'),
        'ovhgseq': 'TRYA',
    }
rest_dict['SfcI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfeI>CT[AG][CT]AG)',
        'results': None,
        'site': 'CTRYAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTRYAG'),
        'ovhgseq': 'TRYA',
    }
rest_dict['SfeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfiI>GGCC.....GGCC)',
        'results': None,
        'site': 'GGCCNNNNNGGCC',
        'substrat': 'DNA',
        'fst3': -8,
        'fst5': 8,
        'freq': 65536,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (8, -8, None, None, 'GGCCNNNNNGGCC'),
        'ovhgseq': 'NNN',
    }
rest_dict['SfiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfoI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (3, -3, None, None, 'GGCGCC'),
        'ovhgseq': '',
    }
rest_dict['SfoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sfr274I>CTCGAG)',
        'results': None,
        'site': 'CTCGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTCGAG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['Sfr274I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sfr303I>CCGCGG)',
        'results': None,
        'site': 'CCGCGG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (4, -4, None, None, 'CCGCGG'),
        'ovhgseq': 'GC',
    }
rest_dict['Sfr303I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SfuI>TTCGAA)',
        'results': None,
        'site': 'TTCGAA',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('M',),
        'scd5': None,
        'charac': (2, -2, None, None, 'TTCGAA'),
        'ovhgseq': 'CG',
    }
rest_dict['SfuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgeI>C..G)',
        'results': None,
        'site': 'CNNG',
        'substrat': 'DNA',
        'fst3': 13,
        'fst5': 13,
        'freq': 16,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (13, 13, None, None, 'CNNG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['SgeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgfI>GCGATCGC)',
        'results': None,
        'site': 'GCGATCGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('R',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCGATCGC'),
        'ovhgseq': 'AT',
    }
rest_dict['SgfI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgrAI>C[AG]CCGG[CT]G)',
        'results': None,
        'site': 'CRCCGGYG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 16384,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CRCCGGYG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['SgrAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgrBI>CCGCGG)',
        'results': None,
        'site': 'CCGCGG',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (4, -4, None, None, 'CCGCGG'),
        'ovhgseq': 'GC',
    }
rest_dict['SgrBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgrDI>CGTCGACG)',
        'results': None,
        'site': 'CGTCGACG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGTCGACG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['SgrDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgrTI>CC[AGT][CG])|(?P<SgrTI_as>[CG][ACT]GG)',
        'results': None,
        'site': 'CCDS',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 14,
        'freq': 32,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (14, 14, None, None, 'CCDS'),
        'ovhgseq': 'NNNN',
    }
rest_dict['SgrTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SgsI>GGCGCGCC)',
        'results': None,
        'site': 'GGCGCGCC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GGCGCGCC'),
        'ovhgseq': 'CGCG',
    }
rest_dict['SgsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SimI>GGGTC)|(?P<SimI_as>GACCC)',
        'results': None,
        'site': 'GGGTC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 2,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, 0, None, None, 'GGGTC'),
        'ovhgseq': 'GTC',
    }
rest_dict['SimI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SinI>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('X',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['SinI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SlaI>CTCGAG)',
        'results': None,
        'site': 'CTCGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C', 'Y'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTCGAG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['SlaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SmaI>CCCGGG)',
        'results': None,
        'site': 'CCCGGG',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X', 'Y'),
        'scd5': None,
        'charac': (3, -3, None, None, 'CCCGGG'),
        'ovhgseq': '',
    }
rest_dict['SmaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SmiI>ATTTAAAT)',
        'results': None,
        'site': 'ATTTAAAT',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'I', 'K', 'V'),
        'scd5': None,
        'charac': (4, -4, None, None, 'ATTTAAAT'),
        'ovhgseq': '',
    }
rest_dict['SmiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SmiMI>CA[CT]....[AG]TG)',
        'results': None,
        'site': 'CAYNNNNRTG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'CAYNNNNRTG'),
        'ovhgseq': '',
    }
rest_dict['SmiMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SmlI>CT[CT][AG]AG)',
        'results': None,
        'site': 'CTYRAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTYRAG'),
        'ovhgseq': 'TYRA',
    }
rest_dict['SmlI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SmoI>CT[CT][AG]AG)',
        'results': None,
        'site': 'CTYRAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTYRAG'),
        'ovhgseq': 'TYRA',
    }
rest_dict['SmoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SnaBI>TACGTA)',
        'results': None,
        'site': 'TACGTA',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('C', 'K', 'M', 'N', 'R'),
        'scd5': None,
        'charac': (3, -3, None, None, 'TACGTA'),
        'ovhgseq': '',
    }
rest_dict['SnaBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SnaI>GTATAC)',
        'results': None,
        'site': 'GTATAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GTATAC'),
        'ovhgseq': None,
    }
rest_dict['SnaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sno506I>GGCCGAG)|(?P<Sno506I_as>CTCGGCC)',
        'results': None,
        'site': 'GGCCGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGCCGAG'),
        'ovhgseq': None,
    }
rest_dict['Sno506I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SpeI>ACTAGT)',
        'results': None,
        'site': 'ACTAGT',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'ACTAGT'),
        'ovhgseq': 'CTAG',
    }
rest_dict['SpeI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SphI>GCATGC)',
        'results': None,
        'site': 'GCATGC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GCATGC'),
        'ovhgseq': 'CATG',
    }
rest_dict['SphI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SplI>CGTACG)',
        'results': None,
        'site': 'CGTACG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGTACG'),
        'ovhgseq': 'GTAC',
    }
rest_dict['SplI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SpnRII>TCGAG)|(?P<SpnRII_as>CTCGA)',
        'results': None,
        'site': 'TCGAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TCGAG'),
        'ovhgseq': None,
    }
rest_dict['SpnRII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SpoDI>GCGG[AG]AG)|(?P<SpoDI_as>CT[CT]CCGC)',
        'results': None,
        'site': 'GCGGRAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGGRAG'),
        'ovhgseq': None,
    }
rest_dict['SpoDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SrfI>GCCCGGGC)',
        'results': None,
        'site': 'GCCCGGGC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GCCCGGGC'),
        'ovhgseq': '',
    }
rest_dict['SrfI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sse232I>CGCCGGCG)',
        'results': None,
        'site': 'CGCCGGCG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'CGCCGGCG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['Sse232I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sse8387I>CCTGCAGG)',
        'results': None,
        'site': 'CCTGCAGG',
        'substrat': 'DNA',
        'fst3': -6,
        'fst5': 6,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (6, -6, None, None, 'CCTGCAGG'),
        'ovhgseq': 'TGCA',
    }
rest_dict['Sse8387I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sse8647I>AGG[AT]CCT)',
        'results': None,
        'site': 'AGGWCCT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'AGGWCCT'),
        'ovhgseq': 'GWC',
    }
rest_dict['Sse8647I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sse9I>AATT)',
        'results': None,
        'site': 'AATT',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (0, 0, None, None, 'AATT'),
        'ovhgseq': 'AATT',
    }
rest_dict['Sse9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SseBI>AGGCCT)',
        'results': None,
        'site': 'AGGCCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGGCCT'),
        'ovhgseq': '',
    }
rest_dict['SseBI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SsiI>CCGC)|(?P<SsiI_as>GCGG)',
        'results': None,
        'site': 'CCGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCGC'),
        'ovhgseq': 'CG',
    }
rest_dict['SsiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ssp6803IV>GAAGGC)|(?P<Ssp6803IV_as>GCCTTC)',
        'results': None,
        'site': 'GAAGGC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAAGGC'),
        'ovhgseq': None,
    }
rest_dict['Ssp6803IV'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Ssp714II>CGCAGCG)|(?P<Ssp714II_as>CGCTGCG)',
        'results': None,
        'site': 'CGCAGCG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGCAGCG'),
        'ovhgseq': None,
    }
rest_dict['Ssp714II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SspD5I>GGTGA)|(?P<SspD5I_as>TCACC)',
        'results': None,
        'site': 'GGTGA',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 13,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (13, 8, None, None, 'GGTGA'),
        'ovhgseq': '',
    }
rest_dict['SspD5I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SspDI>GGCGCC)',
        'results': None,
        'site': 'GGCGCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGCGCC'),
        'ovhgseq': 'GCGC',
    }
rest_dict['SspDI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SspI>AATATT)',
        'results': None,
        'site': 'AATATT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'N', 'Q', 'R', 'V', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AATATT'),
        'ovhgseq': '',
    }
rest_dict['SspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SspMI>CTAG)',
        'results': None,
        'site': 'CTAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTAG'),
        'ovhgseq': 'TA',
    }
rest_dict['SspMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SstE37I>CGAAGAC)|(?P<SstE37I_as>GTCTTCG)',
        'results': None,
        'site': 'CGAAGAC',
        'substrat': 'DNA',
        'fst3': 18,
        'fst5': 27,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 18, None, None, 'CGAAGAC'),
        'ovhgseq': 'NN',
    }
rest_dict['SstE37I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SstI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('C',),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAGCTC'),
        'ovhgseq': 'AGCT',
    }
rest_dict['SstI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sth132I>CCCG)|(?P<Sth132I_as>CGGG)',
        'results': None,
        'site': 'CCCG',
        'substrat': 'DNA',
        'fst3': 8,
        'fst5': 8,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (8, 8, None, None, 'CCCG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['Sth132I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sth20745III>GGACGAC)|(?P<Sth20745III_as>GTCGTCC)',
        'results': None,
        'site': 'GGACGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GGACGAC'),
        'ovhgseq': None,
    }
rest_dict['Sth20745III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sth302II>CCGG)',
        'results': None,
        'site': 'CCGG',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (2, -2, None, None, 'CCGG'),
        'ovhgseq': '',
    }
rest_dict['Sth302II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<StsI>GGATG)|(?P<StsI_as>CATCC)',
        'results': None,
        'site': 'GGATG',
        'substrat': 'DNA',
        'fst3': 14,
        'fst5': 15,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (15, 14, None, None, 'GGATG'),
        'ovhgseq': 'NNNN',
    }
rest_dict['StsI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<StuI>AGGCCT)',
        'results': None,
        'site': 'AGGCCT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'Q', 'R', 'X'),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGGCCT'),
        'ovhgseq': '',
    }
rest_dict['StuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Sty13348III>GATCAG)|(?P<Sty13348III_as>CTGATC)',
        'results': None,
        'site': 'GATCAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GATCAG'),
        'ovhgseq': None,
    }
rest_dict['Sty13348III'] = _temp()


def _temp():
    return {
        'compsite': '(?P<StyD4I>CC.GG)',
        'results': None,
        'site': 'CCNGG',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'CCNGG'),
        'ovhgseq': 'CCNGG',
    }
rest_dict['StyD4I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<StyI>CC[AT][AT]GG)',
        'results': None,
        'site': 'CCWWGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('C', 'J', 'N'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCWWGG'),
        'ovhgseq': 'CWWG',
    }
rest_dict['StyI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<SwaI>ATTTAAAT)',
        'results': None,
        'site': 'ATTTAAAT',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 65536,
        'size': 8,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('J', 'M', 'N'),
        'scd5': None,
        'charac': (4, -4, None, None, 'ATTTAAAT'),
        'ovhgseq': '',
    }
rest_dict['SwaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TaaI>AC.GT)',
        'results': None,
        'site': 'ACNGT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (3, -3, None, None, 'ACNGT'),
        'ovhgseq': 'N',
    }
rest_dict['TaaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TaiI>ACGT)',
        'results': None,
        'site': 'ACGT',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'ACGT'),
        'ovhgseq': 'ACGT',
    }
rest_dict['TaiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TaqI>TCGA)',
        'results': None,
        'site': 'TCGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCGA'),
        'ovhgseq': 'CG',
    }
rest_dict['TaqI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TaqII>GACCGA)|(?P<TaqII_as>TCGGTC)',
        'results': None,
        'site': 'GACCGA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (17, 9, None, None, 'GACCGA'),
        'ovhgseq': 'NN',
    }
rest_dict['TaqII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TaqIII>CACCCA)|(?P<TaqIII_as>TGGGTG)',
        'results': None,
        'site': 'CACCCA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 9, None, None, 'CACCCA'),
        'ovhgseq': 'NN',
    }
rest_dict['TaqIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TasI>AATT)',
        'results': None,
        'site': 'AATT',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (0, 0, None, None, 'AATT'),
        'ovhgseq': 'AATT',
    }
rest_dict['TasI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TatI>[AT]GTAC[AT])',
        'results': None,
        'site': 'WGTACW',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'WGTACW'),
        'ovhgseq': 'GTAC',
    }
rest_dict['TatI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TauI>GC[CG]GC)',
        'results': None,
        'site': 'GCSGC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (4, -4, None, None, 'GCSGC'),
        'ovhgseq': 'CSG',
    }
rest_dict['TauI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TfiI>GA[AT]TC)',
        'results': None,
        'site': 'GAWTC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GAWTC'),
        'ovhgseq': 'AWT',
    }
rest_dict['TfiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tru1I>TTAA)',
        'results': None,
        'site': 'TTAA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'TTAA'),
        'ovhgseq': 'TA',
    }
rest_dict['Tru1I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tru9I>TTAA)',
        'results': None,
        'site': 'TTAA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('I', 'M', 'R', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TTAA'),
        'ovhgseq': 'TA',
    }
rest_dict['Tru9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TscAI>CA[CG]TG)',
        'results': None,
        'site': 'CASTG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 10,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CASTG'),
        'ovhgseq': 'NNCASTGNN',
    }
rest_dict['TscAI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TseFI>GT[CG]AC)',
        'results': None,
        'site': 'GTSAC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GTSAC'),
        'ovhgseq': 'GTSAC',
    }
rest_dict['TseFI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TseI>GC[AT]GC)',
        'results': None,
        'site': 'GCWGC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GCWGC'),
        'ovhgseq': 'CWG',
    }
rest_dict['TseI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TsoI>TA[AG]CCA)|(?P<TsoI_as>TGG[CT]TA)',
        'results': None,
        'site': 'TARCCA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 9, None, None, 'TARCCA'),
        'ovhgseq': 'NN',
    }
rest_dict['TsoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tsp45I>GT[CG]AC)',
        'results': None,
        'site': 'GTSAC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (0, 0, None, None, 'GTSAC'),
        'ovhgseq': 'GTSAC',
    }
rest_dict['Tsp45I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tsp4CI>AC.GT)',
        'results': None,
        'site': 'ACNGT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (3, -3, None, None, 'ACNGT'),
        'ovhgseq': 'N',
    }
rest_dict['Tsp4CI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspARh3I>G[AG]ACGAC)|(?P<TspARh3I_as>GTCGT[CT]C)',
        'results': None,
        'site': 'GRACGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GRACGAC'),
        'ovhgseq': None,
    }
rest_dict['TspARh3I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspDTI>ATGAA)|(?P<TspDTI_as>TTCAT)',
        'results': None,
        'site': 'ATGAA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 16,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (16, 9, None, None, 'ATGAA'),
        'ovhgseq': 'NN',
    }
rest_dict['TspDTI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspEI>AATT)',
        'results': None,
        'site': 'AATT',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (0, 0, None, None, 'AATT'),
        'ovhgseq': 'AATT',
    }
rest_dict['TspEI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspGWI>ACGGA)|(?P<TspGWI_as>TCCGT)',
        'results': None,
        'site': 'ACGGA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 16,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': ('Q', 'X'),
        'scd5': None,
        'charac': (16, 9, None, None, 'ACGGA'),
        'ovhgseq': 'NN',
    }
rest_dict['TspGWI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspMI>CCCGGG)',
        'results': None,
        'site': 'CCCGGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCCGGG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['TspMI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TspRI>CA[CG]TG)',
        'results': None,
        'site': 'CASTG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 10,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (7, -7, None, None, 'CASTG'),
        'ovhgseq': 'NNCASTGNN',
    }
rest_dict['TspRI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TssI>GAG...CTC)',
        'results': None,
        'site': 'GAGNNNCTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAGNNNCTC'),
        'ovhgseq': None,
    }
rest_dict['TssI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TstI>CAC......TCC)|(?P<TstI_as>GGA......GTG)',
        'results': None,
        'site': 'CACNNNNNNTCC',
        'substrat': 'DNA',
        'fst3': -25,
        'fst5': -8,
        'freq': 4096,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 5,
        'scd3': 7,
        'suppl': (),
        'scd5': 24,
        'charac': (-8, -25, 24, 7, 'CACNNNNNNTCC'),
        'ovhgseq': 'NNNNN',
    }
rest_dict['TstI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<TsuI>GCGAC)|(?P<TsuI_as>GTCGC)',
        'results': None,
        'site': 'GCGAC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GCGAC'),
        'ovhgseq': None,
    }
rest_dict['TsuI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tth111I>GAC...GTC)',
        'results': None,
        'site': 'GACNNNGTC',
        'substrat': 'DNA',
        'fst3': -4,
        'fst5': 4,
        'freq': 4096,
        'size': 9,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('I', 'K', 'N', 'Q', 'V', 'X'),
        'scd5': None,
        'charac': (4, -4, None, None, 'GACNNNGTC'),
        'ovhgseq': 'N',
    }
rest_dict['Tth111I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Tth111II>CAA[AG]CA)|(?P<Tth111II_as>TG[CT]TTG)',
        'results': None,
        'site': 'CAARCA',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 17,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (17, 9, None, None, 'CAARCA'),
        'ovhgseq': 'NN',
    }
rest_dict['Tth111II'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaF11I>TCGTA)|(?P<UbaF11I_as>TACGA)',
        'results': None,
        'site': 'TCGTA',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 1024,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TCGTA'),
        'ovhgseq': None,
    }
rest_dict['UbaF11I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaF12I>CTAC...GTC)|(?P<UbaF12I_as>GAC...GTAG)',
        'results': None,
        'site': 'CTACNNNGTC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CTACNNNGTC'),
        'ovhgseq': None,
    }
rest_dict['UbaF12I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaF13I>GAG......CTGG)|(?P<UbaF13I_as>CCAG......CTC)',
        'results': None,
        'site': 'GAGNNNNNNCTGG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 16384,
        'size': 13,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'GAGNNNNNNCTGG'),
        'ovhgseq': None,
    }
rest_dict['UbaF13I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaF14I>CCA.....TCG)|(?P<UbaF14I_as>CGA.....TGG)',
        'results': None,
        'site': 'CCANNNNNTCG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CCANNNNNTCG'),
        'ovhgseq': None,
    }
rest_dict['UbaF14I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaF9I>TAC.....[AG]TGT)|(?P<UbaF9I_as>ACA[CT].....GTA)',
        'results': None,
        'site': 'TACNNNNNRTGT',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 8192,
        'size': 12,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'TACNNNNNRTGT'),
        'ovhgseq': None,
    }
rest_dict['UbaF9I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UbaPI>CGAACG)|(?P<UbaPI_as>CGTTCG)',
        'results': None,
        'site': 'CGAACG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGAACG'),
        'ovhgseq': None,
    }
rest_dict['UbaPI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UcoMSI>GAGCTC)',
        'results': None,
        'site': 'GAGCTC',
        'substrat': 'DNA',
        'fst3': -11,
        'fst5': -7,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': 7,
        'suppl': (),
        'scd5': 11,
        'charac': (-7, -11, 11, 7, 'GAGCTC'),
        'ovhgseq': 'NN',
    }
rest_dict['UcoMSI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<UnbI>GG.CC)',
        'results': None,
        'site': 'GGNCC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 256,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (0, 0, None, None, 'GGNCC'),
        'ovhgseq': 'GGNCC',
    }
rest_dict['UnbI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Van91I>CCA.....TGG)',
        'results': None,
        'site': 'CCANNNNNTGG',
        'substrat': 'DNA',
        'fst3': -7,
        'fst5': 7,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 3,
        'scd3': None,
        'suppl': ('B', 'K'),
        'scd5': None,
        'charac': (7, -7, None, None, 'CCANNNNNTGG'),
        'ovhgseq': 'NNN',
    }
rest_dict['Van91I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Vha464I>CTTAAG)',
        'results': None,
        'site': 'CTTAAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('V',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTTAAG'),
        'ovhgseq': 'TTAA',
    }
rest_dict['Vha464I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<VneI>GTGCAC)',
        'results': None,
        'site': 'GTGCAC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'GTGCAC'),
        'ovhgseq': 'TGCA',
    }
rest_dict['VneI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<VpaK11AI>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': 0,
        'fst5': 0,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -5,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (0, 0, None, None, 'GGWCC'),
        'ovhgseq': 'GGWCC',
    }
rest_dict['VpaK11AI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<VpaK11BI>GG[AT]CC)',
        'results': None,
        'site': 'GGWCC',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 512,
        'size': 5,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -3,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'GGWCC'),
        'ovhgseq': 'GWC',
    }
rest_dict['VpaK11BI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<VspI>ATTAAT)',
        'results': None,
        'site': 'ATTAAT',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B', 'I', 'R', 'V'),
        'scd5': None,
        'charac': (2, -2, None, None, 'ATTAAT'),
        'ovhgseq': 'TA',
    }
rest_dict['VspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Vtu19109I>CAC[AG]A[CT]C)|(?P<Vtu19109I_as>G[AG]T[CT]GTG)',
        'results': None,
        'site': 'CACRAYC',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 7,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CACRAYC'),
        'ovhgseq': None,
    }
rest_dict['Vtu19109I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<WviI>CAC[AG]AG)|(?P<WviI_as>CT[CT]GTG)',
        'results': None,
        'site': 'CACRAG',
        'substrat': 'DNA',
        'fst3': 19,
        'fst5': 27,
        'freq': 2048,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 2,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (27, 19, None, None, 'CACRAG'),
        'ovhgseq': 'NN',
    }
rest_dict['WviI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XagI>CCT.....AGG)',
        'results': None,
        'site': 'CCTNNNNNAGG',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 11,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -1,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
        'ovhgseq': 'N',
    }
rest_dict['XagI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XapI>[AG]AATT[CT])',
        'results': None,
        'site': 'RAATTY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'RAATTY'),
        'ovhgseq': 'AATT',
    }
rest_dict['XapI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XbaI>TCTAGA)',
        'results': None,
        'site': 'TCTAGA',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'C', 'I', 'J', 'K', 'M', 'N', 'Q', 'R', 'S', 'V', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'TCTAGA'),
        'ovhgseq': 'CTAG',
    }
rest_dict['XbaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XceI>[AG]CATG[CT])',
        'results': None,
        'site': 'RCATGY',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (5, -5, None, None, 'RCATGY'),
        'ovhgseq': 'CATG',
    }
rest_dict['XceI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XcmI>CCA.........TGG)',
        'results': None,
        'site': 'CCANNNNNNNNNTGG',
        'substrat': 'DNA',
        'fst3': -8,
        'fst5': 8,
        'freq': 4096,
        'size': 15,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': ('N',),
        'scd5': None,
        'charac': (8, -8, None, None, 'CCANNNNNNNNNTGG'),
        'ovhgseq': 'N',
    }
rest_dict['XcmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XhoI>CTCGAG)',
        'results': None,
        'site': 'CTCGAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B', 'J', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'X'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTCGAG'),
        'ovhgseq': 'TCGA',
    }
rest_dict['XhoI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XhoII>[AG]GATC[CT])',
        'results': None,
        'site': 'RGATCY',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'RGATCY'),
        'ovhgseq': 'GATC',
    }
rest_dict['XhoII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XmaI>CCCGGG)',
        'results': None,
        'site': 'CCCGGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('I', 'N', 'R', 'V'),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCCGGG'),
        'ovhgseq': 'CCGG',
    }
rest_dict['XmaI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XmaIII>CGGCCG)',
        'results': None,
        'site': 'CGGCCG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (1, -1, None, None, 'CGGCCG'),
        'ovhgseq': 'GGCC',
    }
rest_dict['XmaIII'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XmaJI>CCTAGG)',
        'results': None,
        'site': 'CCTAGG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -4,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CCTAGG'),
        'ovhgseq': 'CTAG',
    }
rest_dict['XmaJI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XmiI>GT[AC][GT]AC)',
        'results': None,
        'site': 'GTMKAC',
        'substrat': 'DNA',
        'fst3': -2,
        'fst5': 2,
        'freq': 1024,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('B',),
        'scd5': None,
        'charac': (2, -2, None, None, 'GTMKAC'),
        'ovhgseq': 'MK',
    }
rest_dict['XmiI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XmnI>GAA....TTC)',
        'results': None,
        'site': 'GAANNNNTTC',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 10,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('N', 'R'),
        'scd5': None,
        'charac': (5, -5, None, None, 'GAANNNNTTC'),
        'ovhgseq': '',
    }
rest_dict['XmnI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<XspI>CTAG)',
        'results': None,
        'site': 'CTAG',
        'substrat': 'DNA',
        'fst3': -1,
        'fst5': 1,
        'freq': 256,
        'size': 4,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': -2,
        'scd3': None,
        'suppl': ('K',),
        'scd5': None,
        'charac': (1, -1, None, None, 'CTAG'),
        'ovhgseq': 'TA',
    }
rest_dict['XspI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<YkrI>C)|(?P<YkrI_as>G)',
        'results': None,
        'site': 'C',
        'substrat': 'DNA',
        'fst3': 9,
        'fst5': 11,
        'freq': 4,
        'size': 1,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 1,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (11, 9, None, None, 'C'),
        'ovhgseq': 'N',
    }
rest_dict['YkrI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Yps3606I>CGGAAG)|(?P<Yps3606I_as>CTTCCG)',
        'results': None,
        'site': 'CGGAAG',
        'substrat': 'DNA',
        'fst3': None,
        'fst5': None,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': None,
        'scd3': None,
        'suppl': (),
        'scd5': None,
        'charac': (None, None, None, None, 'CGGAAG'),
        'ovhgseq': None,
    }
rest_dict['Yps3606I'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ZraI>GACGTC)',
        'results': None,
        'site': 'GACGTC',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I', 'N', 'V'),
        'scd5': None,
        'charac': (3, -3, None, None, 'GACGTC'),
        'ovhgseq': '',
    }
rest_dict['ZraI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<ZrmI>AGTACT)',
        'results': None,
        'site': 'AGTACT',
        'substrat': 'DNA',
        'fst3': -3,
        'fst5': 3,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 0,
        'scd3': None,
        'suppl': ('I',),
        'scd5': None,
        'charac': (3, -3, None, None, 'AGTACT'),
        'ovhgseq': '',
    }
rest_dict['ZrmI'] = _temp()


def _temp():
    return {
        'compsite': '(?P<Zsp2I>ATGCAT)',
        'results': None,
        'site': 'ATGCAT',
        'substrat': 'DNA',
        'fst3': -5,
        'fst5': 5,
        'freq': 4096,
        'size': 6,
        'opt_temp': 37,
        'dna': None,
        'inact_temp': 65,
        'ovhg': 4,
        'scd3': None,
        'suppl': ('I', 'V'),
        'scd5': None,
        'charac': (5, -5, None, None, 'ATGCAT'),
        'ovhgseq': 'TGCA',
    }
rest_dict['Zsp2I'] = _temp()

suppliers = {}


def _temp():
    return (
        'Life Technologies',
        ['BshTI', 'MluI', 'HpaII', 'MreI', 'BclI', 'SacI', 'PauI', 'BglI', 'SalI', 'MspI', 'ScaI', 'Bsu15I', 'Mva1269I', 'Bsp68I', 'LweI', 'SmiI', 'PteI', 'TscAI', 'NcoI', 'PsyI', 'BseJI', 'ClaI', 'MauBI', 'CaiI', 'Eco24I', 'CseI', 'Eco47III', 'Eco91I', 'DraI', 'BseXI', 'BstXI', 'RruI', 'Esp3I', 'BseSI', 'Cfr9I', 'AarI', 'OliI', 'PvuI', 'BspOI', 'DpnI', 'Hin6I', 'Van91I', 'Bst1107I', 'Bme1390I', 'BveI', 'Psp5II', 'TaqI', 'Eco52I', 'GsuI', 'KpnI', 'SspDI', 'SsiI', 'RseI', 'MlsI', 'NdeI', 'HapII', 'Cfr13I', 'MboII', 'SdaI', 'BmsI', 'BglII', 'TasI', 'AjuI', 'AloI', 'FspBI', 'SchI', 'PfoI', 'Bpu10I', 'BshNI', 'SacII', 'Acc65I', 'BmeT110I', 'XapI', 'TaaI', 'PscI', 'Bsp1407I', 'NruI', 'MvaI', 'PasI', 'Hin1II', 'Bsh1236I', 'MssI', 'CpoI', 'Eco130I', 'PspFI', 'TaiI', 'FspAI', 'BfmI', 'Eco47I', 'BoxI', 'RsaI', 'HincII', 'HpyF10VI', 'XbaI', 'Lsp1109I', 'AjiI', 'Bsp119I', 'MboI', 'AluI', 'SduI', 'SgsI', 'BseGI', 'Eco72I', 'BcnI', 'SgeI', 'Mph1103I', 'EcoRII', 'Alw21I', 'XagI', 'Hpy8I', 'PsuI', 'PaeI', 'SmaI', 'NheI', 'BplI', 'Ppu21I', 'SmoI', 'FaqI', 'AdeI', 'StuI', 'BcuI', 'BspTI', 'SphI', 'BseLI', 'AasI', 'PvuII', 'EheI', 'FokI', 'Hin1I', 'Alw26I', 'Cfr10I', 'SpeI', 'SgrDI', 'Eco31I', 'HinfI', 'Eam1105I', 'BsuRI', 'XmiI', 'Eam1104I', 'Ecl136II', 'XmaJI', 'SfaAI', 'HphI', 'Psp1406I', 'Csp6I', 'EcoO109I', 'BseMII', 'HindIII', 'EcoRV', 'AatII', 'BfuI', 'EcoRI', 'TauI', 'XhoI', 'Bsp143I', 'BspPI', 'MnlI', 'PfeI', 'Bpu1102I', 'MunI', 'Tru1I', 'BspLI', 'Eco105I', 'NsbI', 'PstI', 'LguI', 'VspI', 'Alw44I', 'SfiI', 'BpiI', 'XceI', 'BseMI', 'HaeIII', 'Kpn2I', 'Cfr42I', 'SatI', 'AccI', 'SspI', 'Eco32I', 'KflI', 'BseDI', 'KspAI', 'Eco81I', 'BauI', 'AanI', 'ApaI', 'SaqAI', 'EcoT22I', 'Eco88I', 'Eco57I', 'Eco147I', 'PacI', 'PdmI', 'BalI', 'CsiI', 'AfaI', 'Bsp120I', 'NotI', 'MbiI', 'BamHI', 'BfoI', 'TatI', 'HpaI', 'HpyF3I', 'Pfl23II', 'Bsh1285I', 'HhaI', 'NmuCI', 'BseNI', 'PagI', 'PdiI'],
    )
suppliers['B'] = _temp()


def _temp():
    return (
        'Minotech Biotechnology',
        ['SgrBI', 'BclI', 'BglI', 'SalI', 'PspPI', 'ScaI', 'SnaBI', 'BstEII', 'NcoI', 'BshFI', 'AsuII', 'BssAI', 'BseAI', 'TaqI', 'KpnI', 'BglII', 'NaeI', 'BseBI', 'NruI', 'RsaI', 'BsiSI', 'XbaI', 'MboI', 'AluI', 'SlaI', 'SseBI', 'SmaI', 'NheI', 'SstI', 'Sau3AI', 'SphI', 'PvuII', 'ApaLI', 'HinfI', 'MspCI', 'HindIII', 'EcoRV', 'EcoRI', 'BseCI', 'PstI', 'SfiI', 'SspI', 'CspAI', 'NotI', 'BamHI', 'HpaI', 'StyI'],
    )
suppliers['C'] = _temp()


def _temp():
    return (
        'Agilent Technologies',
        ['DpnI'],
    )
suppliers['E'] = _temp()


def _temp():
    return (
        'SibEnzyme Ltd.',
        ['AsuNHI', 'AgsI', 'MluI', 'CciI', 'BstHHI', 'HpaII', 'AhlI', 'KroI', 'PspN4I', 'BglI', 'SalI', 'PspEI', 'MspI', 'VneI', 'BstH2I', 'BisI', 'BmtI', 'PspXI', 'AsiGI', 'CciNI', 'Sfr274I', 'SmiI', 'Ksp22I', 'BstSFI', 'BssT1I', 'MspA1I', 'Bsp19I', 'Bse1I', 'AspS9I', 'AbsI', 'FauNDI', 'BstMWI', 'LmnI', 'AclWI', 'DraI', 'Bst2UI', 'AluBI', 'PsrI', 'BstACI', 'BstXI', 'BstDEI', 'GluI', 'AcoI', 'XmaI', 'BstF5I', 'BstMBI', 'BstENI', 'BssECI', 'FalI', 'EgeI', 'Ama87I', 'BstDSI', 'BstV2I', 'AjnI', 'Bsc4I', 'PalAI', 'Zsp2I', 'DseDI', 'BstAUI', 'Bpu14I', 'FaeI', 'TaqI', 'KpnI', 'BstSNI', 'AclI', 'MboII', 'BglII', 'PspPPI', 'SetI', 'AcsI', 'BstNSI', 'BseX3I', 'RsaNI', 'Bpu10I', 'Rsr2I', 'Acc65I', 'Bst2BI', 'NruI', 'Ple19I', 'TseFI', 'SspMI', 'PciI', 'MalI', 'Bse118I', 'BsuI', 'BsePI', 'BstMCI', 'Bme18I', 'RsaI', 'BssNAI', 'BstV1I', 'Bsp13I', 'Bst4CI', 'MabI', 'AsuHPI', 'BtrI', 'XbaI', 'ArsI', 'BstC8I', 'Psp124BI', 'GlaI', 'HgaI', 'BstX2I', 'AluI', 'ZraI', 'Bse21I', 'Sfr303I', 'BstSCI', 'Bse3DI', 'Bso31I', 'AccB7I', 'BstKTI', 'AccBSI', 'SmaI', 'SmiMI', 'BspACI', 'AspA2I', 'Bsp1720I', 'AspLEI', 'SphI', 'Mly113I', 'FriOI', 'PvuII', 'MfeI', 'ErhI', 'FokI', 'AsuC2I', 'GsaI', 'HinfI', 'BsuRI', 'PpsI', 'BstPAI', 'HspAI', 'RgaI', 'Fsp4HI', 'Kzo9I', 'Acc36I', 'DraIII', 'Acc16I', 'MspR9I', 'HindIII', 'EcoRV', 'PsiI', 'AatII', 'MroXI', 'EcoRI', 'ZrmI', 'BstFNI', 'BslFI', 'Bsa29I', 'MnlI', 'SbfI', 'PstI', 'Bse8I', 'FauI', 'VspI', 'PciSI', 'SfiI', 'Bst6I', 'BspFNI', 'Bbv12I', 'Tth111I', 'HaeIII', 'BstAPI', 'SspI', 'AfeI', 'PspOMI', 'BstMAI', 'BstSLI', 'ApaI', 'BlsI', 'Mox20I', 'FblI', 'BmuI', 'PcsI', 'BarI', 'PctI', 'FaiI', 'BpmI', 'PstNI', 'AcuI', 'AccB1I', 'PceI', 'PkrI', 'HpySE526I', 'Sse9I', 'Tru9I', 'MhlI', 'BstBAI', 'MteI', 'DriI', 'MroNI', 'AoxI', 'EcoICRI', 'FatI', 'BamHI', 'Psp6I', 'BstAFI', 'SfaNI', 'RigI', 'HpaI', 'PspCI', 'HindII', 'PspLI', 'AsiSI'],
    )
suppliers['I'] = _temp()


def _temp():
    return (
        'Nippon Gene Co., Ltd.',
        ['BssHII', 'AxyI', 'MluI', 'BclI', 'SacI', 'EcoT38I', 'BglI', 'SalI', 'MspI', 'ScaI', 'BstEII', 'NcoI', 'DraI', 'BstXI', 'SwaI', 'AvaI', 'TaqI', 'AseI', 'KpnI', 'Sau96I', 'HaeII', 'NdeI', 'MboII', 'AflII', 'BglII', 'AccII', 'SacII', 'NruI', 'NarI', 'RsaI', 'HincII', 'XbaI', 'AluI', 'ScrFI', 'EcoRII', 'SmaI', 'NheI', 'StuI', 'Sau3AI', 'SphI', 'FspI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'NciI', 'EcoO109I', 'HindIII', 'EcoRV', 'EcoRI', 'XhoI', 'Bsp1286I', 'AccIII', 'AvaII', 'PstI', 'BsmI', 'Alw44I', 'SfiI', 'HaeIII', 'NdeII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'AgeI', 'NspV', 'BalI', 'NotI', 'AcyI', 'BamHI', 'HpaI', 'StyI', 'HhaI'],
    )
suppliers['J'] = _temp()


def _temp():
    return (
        'Takara Bio Inc.',
        ['BssHII', 'PshBI', 'MluI', 'BspT107I', 'SacI', 'XspI', 'BglI', 'SalI', 'MspI', 'BstPI', 'ScaI', 'BanII', 'PmaCI', 'SnaBI', 'SmiI', 'BmgT120I', 'NcoI', 'ClaI', 'DraI', 'BstXI', 'PshAI', 'PvuI', 'DpnI', 'Van91I', 'Bst1107I', 'TaqI', 'EaeI', 'Eco52I', 'BspT104I', 'KpnI', 'HaeII', 'EcoO65I', 'NdeI', 'HapII', 'MboII', 'AflII', 'EcoT14I', 'BglII', 'NaeI', 'AccII', 'SacII', 'BmeT110I', 'Aor51HI', 'Bsp1407I', 'NruI', 'Sse8387I', 'CpoI', 'HincII', 'XbaI', 'MboI', 'AluI', 'BcnI', 'SmaI', 'NheI', 'StuI', 'Sau3AI', 'SphI', 'PvuII', 'MflI', 'FokI', 'Hin1I', 'ApaLI', 'Cfr10I', 'SpeI', 'HinfI', 'Eam1105I', 'Psp1406I', 'EcoO109I', 'HindIII', 'EcoRV', 'AatII', 'EcoRI', 'XhoI', 'VpaK11BI', 'Bsp1286I', 'AccIII', 'Bpu1102I', 'MunI', 'Aor13HI', 'NsbI', 'PstI', 'SfiI', 'BlnI', 'Tth111I', 'HaeIII', 'BciT130I', 'AccI', 'SspI', 'FbaI', 'Eco81I', 'ApaI', 'EcoT22I', 'BalI', 'DdeI', 'AfaI', 'NotI', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['K'] = _temp()


def _temp():
    return (
        'Roche Applied Science',
        ['BssHII', 'MluI', 'BclI', 'SacI', 'SalI', 'Asp718I', 'ScaI', 'SnaBI', 'NcoI', 'ClaI', 'Eco47III', 'DraI', 'BstXI', 'SwaI', 'PvuI', 'DpnI', 'TaqI', 'SexAI', 'KpnI', 'NdeI', 'BglII', 'MaeI', 'NruI', 'MvaI', 'NarI', 'RsaI', 'MaeII', 'AflIII', 'XbaI', 'MvnI', 'AluI', 'CfoI', 'SmaI', 'NheI', 'StuI', 'Sau3AI', 'BbrPI', 'SphI', 'MaeIII', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'DraIII', 'MluNI', 'HindIII', 'EcoRV', 'AatII', 'EcoRI', 'XhoI', 'MunI', 'PstI', 'BsmI', 'SfiI', 'BlnI', 'HaeIII', 'NdeII', 'AccI', 'NsiI', 'ApaI', 'SfuI', 'BfrI', 'KspI', 'Tru9I', 'DdeI', 'NotI', 'MroI', 'Asp700I', 'BamHI', 'HpaI', 'HindII'],
    )
suppliers['M'] = _temp()


def _temp():
    return (
        'New England Biolabs',
        ['BssHII', 'EciI', 'BsrFI', 'DpnII', 'AlwI', 'MluI', 'AlwNI', 'NgoMIV', 'HpaII', 'TspMI', 'BclI', 'MlyI', 'BsaWI', 'SacI', 'MwoI', 'BfaI', 'DrdI', 'BmgBI', 'BglI', 'SalI', 'MspI', 'ScaI', 'BanII', 'MslI', 'BmtI', 'PspXI', 'BsaBI', 'SnaBI', 'BstEII', 'TspRI', 'NcoI', 'MspA1I', 'BtgI', 'ClaI', 'BsaI', 'BsrBI', 'XmnI', 'DraI', 'Hpy166II', 'Hpy99I', 'StyD4I', 'BstXI', 'PspGI', 'BsiHKAI', 'BsoBI', 'BlpI', 'PshAI', 'XmaI', 'BtsIMutI', 'SwaI', 'AvaI', 'PvuI', 'DpnI', 'CspCI', 'PflFI', 'BpuEI', 'TaqI', 'EaeI', 'SexAI', 'BsrI', 'AseI', 'KpnI', 'Sau96I', 'BstNI', 'HaeII', 'AclI', 'ApoI', 'HpyCH4IV', 'NdeI', 'MboII', 'AflII', 'TseI', 'BglII', 'SmlI', 'NaeI', 'Bpu10I', 'SacII', 'Acc65I', 'BspQI', 'MseI', 'AvrII', 'NruI', 'BaeI', 'BtsCI', 'PciI', 'BcgI', 'BsaHI', 'SfoI', 'MspJI', 'NarI', 'Bsu36I', 'RsaI', 'HincII', 'AflIII', 'BspCNI', 'BsgI', 'XbaI', 'AbaSI', 'BfuAI', 'TfiI', 'PmlI', 'BbvI', 'MboI', 'HgaI', 'BanI', 'AluI', 'BaeGI', 'ZraI', 'Hpy188III', 'RsrII', 'BspMI', 'MluCI', 'AciI', 'ScrFI', 'MscI', 'BseYI', 'CviQI', 'BmrI', 'Hpy188I', 'SmaI', 'PleI', 'EcoNI', 'NheI', 'BccI', 'FspEI', 'BsiEI', 'StuI', 'Sau3AI', 'BcoDI', 'BsiWI', 'SphI', 'HpyAV', 'FspI', 'CviAII', 'PvuII', 'Eco53kI', 'MfeI', 'BsrDI', 'BssSI', 'FokI', 'ApaLI', 'ApeKI', 'SpeI', 'HinfI', 'BciVI', 'HinP1I', 'NciI', 'BceAI', 'HphI', 'BsmAI', 'DraIII', 'EcoO109I', 'HindIII', 'BtsI', 'SapI', 'PpuMI', 'EcoRV', 'PsiI', 'AatII', 'EcoRI', 'BsmFI', 'XhoI', 'Bsp1286I', 'PluTI', 'MnlI', 'AvaII', 'EagI', 'AscI', 'AhdI', 'NlaIII', 'SbfI', 'PstI', 'FauI', 'SfcI', 'BspEI', 'BsmI', 'SfiI', 'BstUI', 'BstZ17I', 'KasI', 'Tth111I', 'HaeIII', 'BsmBI', 'XcmI', 'LpnPI', 'BstAPI', 'AccI', 'SspI', 'HpyCH4III', 'BsrGI', 'AfeI', 'SrfI', 'SgrAI', 'NsiI', 'BspHI', 'BstYI', 'PspOMI', 'PmeI', 'FseI', 'ApaI', 'BseRI', 'MmeI', 'AgeI', 'BtgZI', 'BpmI', 'EarI', 'CviKI_1', 'AcuI', 'BfuCI', 'NspI', 'PacI', 'BstBI', 'HpyCH4V', 'NlaIV', 'BbsI', 'DdeI', 'NotI', 'BsaXI', 'FatI', 'BamHI', 'BslI', 'BspDI', 'PaeR7I', 'SfaNI', 'HpaI', 'BsaJI', 'BbvCI', 'Fnu4HI', 'Cac8I', 'Tsp45I', 'StyI', 'PflMI', 'HhaI', 'AsiSI', 'AleI', 'NmeAIII', 'BsaAI'],
    )
suppliers['N'] = _temp()


def _temp():
    return (
        'Toyobo Biochemicals',
        ['MluI', 'BclI', 'SacI', 'BglI', 'SalI', 'ScaI', 'NcoI', 'PvuI', 'DpnI', 'KpnI', 'BglII', 'SacII', 'HincII', 'AluI', 'MscI', 'SmaI', 'NheI', 'SphI', 'PvuII', 'SpeI', 'HinfI', 'HindIII', 'EcoRV', 'EcoRI', 'XhoI', 'PstI', 'SfiI', 'HaeIII', 'PacI', 'DdeI', 'NotI', 'MroI', 'BamHI'],
    )
suppliers['O'] = _temp()


def _temp():
    return (
        'Molecular Biology Resources - CHIMERx',
        ['BssHII', 'MluI', 'HpaII', 'SacI', 'BglI', 'SalI', 'MspI', 'ScaI', 'NcoI', 'ClaI', 'CviJI', 'DraI', 'BstXI', 'AcvI', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'KpnI', 'NdeI', 'MboII', 'BglII', 'SacII', 'NruI', 'NarI', 'TaqII', 'RsaI', 'HincII', 'XbaI', 'TspGWI', 'MboI', 'AluI', 'RsrII', 'SmaI', 'NheI', 'StuI', 'SphI', 'PvuII', 'SpeI', 'HinfI', 'BsiHKCI', 'HindIII', 'EcoRV', 'EcoRI', 'XhoI', 'MnlI', 'PinAI', 'PstI', 'SfiI', 'Tth111I', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'TspDTI', 'BalI', 'DdeI', 'NotI', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['Q'] = _temp()


def _temp():
    return (
        'Promega Corporation',
        ['BssHII', 'MluI', 'HpaII', 'BclI', 'SacI', 'BglI', 'SalI', 'MspI', 'ScaI', 'SnaBI', 'BstEII', 'NcoI', 'MspA1I', 'ClaI', 'XmnI', 'Eco47III', 'DraI', 'BstXI', 'XmaI', 'PvuI', 'DpnI', 'TaqI', 'KpnI', 'HaeII', 'NdeI', 'MboII', 'BglII', 'SacII', 'NruI', 'CspI', 'NarI', 'RsaI', 'Hsp92II', 'HincII', 'XbaI', 'MboI', 'BanI', 'AluI', 'CfoI', 'SmaI', 'NheI', 'StuI', 'Sau3AI', 'SphI', 'PvuII', 'SpeI', 'HinfI', 'NciI', 'HindIII', 'SgfI', 'EcoRV', 'EcoRI', 'XhoI', 'AccIII', 'AvaII', 'PstI', 'VspI', 'BstZI', 'SfiI', 'Hsp92I', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'AgeI', 'BalI', 'Tru9I', 'DdeI', 'NotI', 'EcoICRI', 'BamHI', 'HpaI', 'HhaI'],
    )
suppliers['R'] = _temp()


def _temp():
    return (
        'Sigma Chemical Corporation',
        ['HpaII', 'BclI', 'SacI', 'SalI', 'MspI', 'ScaI', 'BstEII', 'NcoI', 'ClaI', 'DraI', 'PvuI', 'DpnI', 'TaqI', 'KpnI', 'NdeI', 'BglII', 'MvaI', 'RsaI', 'XbaI', 'AluI', 'CfoI', 'SmaI', 'NheI', 'Sau3AI', 'SphI', 'PvuII', 'SpeI', 'HindIII', 'EcoRV', 'EcoRI', 'XhoI', 'EclXI', 'PstI', 'BsmI', 'SfiI', 'BlnI', 'HaeIII', 'AccI', 'NsiI', 'ApaI', 'KspI', 'DdeI', 'NotI', 'BamHI', 'HpaI'],
    )
suppliers['S'] = _temp()


def _temp():
    return (
        'Vivantis Technologies',
        ['BssMI', 'AsuNHI', 'MluI', 'BstHHI', 'HpaII', 'AhlI', 'BglI', 'SalI', 'PspEI', 'MspI', 'VneI', 'BstH2I', 'BmtI', 'AsiGI', 'CciNI', 'Sfr274I', 'SmiI', 'Ksp22I', 'BssT1I', 'MspA1I', 'Bsp19I', 'Bse1I', 'AspS9I', 'BmcAI', 'FauNDI', 'DraI', 'Bst2UI', 'Vha464I', 'BstXI', 'BstDEI', 'XmaI', 'BstF5I', 'BstMBI', 'BstENI', 'Ama87I', 'BstDSI', 'BstV2I', 'Zsp2I', 'DseDI', 'BstAUI', 'Bpu14I', 'TaqI', 'KpnI', 'BstSNI', 'AclI', 'MboII', 'BmrFI', 'BglII', 'AcsI', 'BstNSI', 'BmeRI', 'BseX3I', 'Bpu10I', 'Rsr2I', 'Acc65I', 'BtuMI', 'Bse118I', 'BsnI', 'BmiI', 'BsePI', 'BstMCI', 'Bme18I', 'RsaI', 'BssNAI', 'Bsp13I', 'Bst4CI', 'AsuHPI', 'XbaI', 'Psp124BI', 'BstX2I', 'AluI', 'ZraI', 'Bse21I', 'Sfr303I', 'BpuMI', 'Bse3DI', 'Bso31I', 'AccB7I', 'AccBSI', 'SmaI', 'SmiMI', 'AspA2I', 'Bsp1720I', 'AspLEI', 'SphI', 'FriOI', 'PvuII', 'BshVI', 'FokI', 'HinfI', 'BstPAI', 'HspAI', 'DraIII', 'Acc16I', 'HindIII', 'EcoRV', 'AatII', 'MroXI', 'EcoRI', 'DinI', 'BstFNI', 'AfiI', 'MnlI', 'SbfI', 'PstI', 'Bse8I', 'VspI', 'SfiI', 'Bst6I', 'Msp20I', 'Bbv12I', 'Tth111I', 'SspI', 'PspOMI', 'BstMAI', 'ApaI', 'FblI', 'PctI', 'AccB1I', 'BssNI', 'PceI', 'Sse9I', 'Tru9I', 'MhlI', 'BstBAI', 'MroNI', 'EcoICRI', 'BamHI', 'SfaNI', 'HpaI', 'PspCI', 'HindII'],
    )
suppliers['V'] = _temp()


def _temp():
    return (
        'EURx Ltd.',
        ['BssHII', 'MluI', 'HpaII', 'BspTNI', 'SacI', 'BglI', 'SalI', 'MspI', 'ScaI', 'BanII', 'NcoI', 'ClaI', 'CviJI', 'DraI', 'BstXI', 'AcvI', 'AvaI', 'PvuI', 'DpnI', 'TaqI', 'SinI', 'KpnI', 'NdeI', 'MboII', 'BglII', 'SacII', 'NruI', 'NarI', 'TaqII', 'RsaI', 'HincII', 'XbaI', 'BspANI', 'TspGWI', 'MboI', 'AluI', 'RsrII', 'SmaI', 'NheI', 'StuI', 'SphI', 'PvuII', 'FokI', 'SpeI', 'HinfI', 'BsiHKCI', 'HindIII', 'EcoRV', 'EcoRI', 'XhoI', 'MnlI', 'AvaII', 'PinAI', 'PstI', 'BspMAI', 'SfiI', 'Tth111I', 'HaeIII', 'AccI', 'SspI', 'NsiI', 'ApaI', 'MmeI', 'TspDTI', 'BalI', 'DdeI', 'NotI', 'BamHI', 'BsuTUI', 'HpaI', 'HhaI'],
    )
suppliers['X'] = _temp()


def _temp():
    return (
        'SinaClon BioScience Co.',
        ['NcoI', 'BstXI', 'KpnI', 'RsaI', 'BsiSI', 'MboI', 'AluI', 'SlaI', 'SmaI', 'FokI', 'HinfI', 'HindIII', 'EcoRI', 'BamHI'],
    )
suppliers['Y'] = _temp()

typedict = {}


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NmeDI'],
    )
typedict['type130'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['UcoMSI'],
    )
typedict['type132'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['RdeGBIII'],
    )
typedict['type142'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['FalI', 'BplI'],
    )
typedict['type143'] = _temp()


def _temp():
    return (
        ('Palindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BdaI', 'AlfI'],
    )
typedict['type144'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Sen13311III', 'SpoDI', 'OspHL35III', 'Cgl13032I', 'Pal408I', 'EsaSSI', 'Pse18267I', 'HpyUM032XIV', 'Hpy99XIV_mut1', 'Cdu23823II', 'RflFIII', 'Pdi8503III', 'Pme5II', 'Cgl13032II', 'Yps3606I', 'CjeFV', 'Bsu7003I', 'Psp10HII', 'Lsp48III', 'HpyAXVI_mut1', 'BscGI', 'Bsp3004IV', 'SpnRII', 'EcoE1140I', 'PliMI', 'Ecl35734I', 'Pac19842II', 'Sno506I', 'Hpy99XIV', 'Aco12261II', 'AspJHL3II', 'Sth20745III', 'Cdi11397I', 'Mba11I', 'TspARh3I', 'RdeGBI', 'Jma19592II', 'Vtu19109I', 'CjeFIII', 'FtnUV', 'AhyYL17I', 'Hpy99XXII', 'DrdII', 'PmeS132I', 'Lba2029III', 'Sen1736II', 'HpyAXVI_mut2', 'AchA6III', 'BanLI', 'HbaII', 'NhaXI', 'RpaTI', 'Cau10061II', 'Cal14237I', 'Esp3007I', 'BloAII', 'Csp2014I', 'Ssp6803IV', 'Cba16038I', 'SenTFIV', 'GauT27I', 'Pdu1735I', 'HpyAXIV', 'KpnNIH30III', 'CcrNAIII', 'Psp0357II', 'MtuHN878II', 'Lmo911II', 'Lsp6406VI', 'Gba708II', 'MkaDII', 'Jma19592I', 'Awo1030IV', 'Saf8902III', 'BfaSII', 'Mcr10I', 'Cla11845III', 'MspI7II', 'Rba2021I', 'Lmo370I', 'Nal45188II', 'AbaCIII', 'CjeNII', 'Ssp714II', 'Aba6411II', 'HpyUM037X', 'AspDUT2V', 'Pst14472I', 'Sbo46I', 'Sty13348III', 'EcoMII', 'Cma23826I', 'Hpy99XIII', 'Cly7489II', 'CalB3II', 'Bag18758I', 'Cba13II', 'Asu14238IV', 'HpyUM032XIII_mut1', 'Bce3081I'],
    )
typedict['type146'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['UbaF14I', 'CjeP659IV', 'PsuGI', 'UbaPI', 'CjuII', 'AlwFI', 'BspGI', 'Pfl1108I', 'UbaF13I', 'AbaUMB2I', 'RlaI', 'PenI', 'UbaF12I', 'BspNCI', 'TsuI', 'UbaF9I', 'FinI', 'UbaF11I', 'BmgI'],
    )
typedict['type148'] = _temp()


def _temp():
    return (
        ('Palindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['MjaIV', 'HpyUM032XIII'],
    )
typedict['type2'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['MlyI', 'BmgBI', 'BsrBI'],
    )
typedict['type209'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NgoAVII'],
    )
typedict['type210'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SchI', 'BtrI', 'AjiI', 'AccBSI', 'MbiI'],
    )
typedict['type211'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CdiI', 'SspD5I'],
    )
typedict['type212'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AciI', 'BspACI', 'BssSI', 'BbvCI'],
    )
typedict['type221'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SsiI', 'Bst2BI', 'PspFI', 'BseYI', 'BauI'],
    )
typedict['type223'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SimI', 'GdiII', 'BsiI'],
    )
typedict['type224'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AlwI', 'Esp3I', 'Bpu10I', 'Lsp1109I', 'BfuAI', 'BbvI', 'HgaI', 'BspMI', 'BccI', 'BcoDI', 'FokI', 'Alw26I', 'Eco31I', 'BceAI', 'BsmAI', 'BsmFI', 'FauI', 'BsmBI', 'BtgZI'],
    )
typedict['type225'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['StsI', 'BscAI'],
    )
typedict['type226'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BspTNI', 'LweI', 'BsaI', 'CseI', 'AclWI', 'BseXI', 'BstV2I', 'AarI', 'BveI', 'BmsI', 'BspQI', 'MspJI', 'BstV1I', 'Bso31I', 'PleI', 'FaqI', 'FspEI', 'PpsI', 'Eam1104I', 'Acc36I', 'SapI', 'BspPI', 'BslFI', 'LguI', 'PciSI', 'Bst6I', 'BpiI', 'LpnPI', 'BstMAI', 'EarI', 'BbsI', 'SfaNI'],
    )
typedict['type227'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SgrTI', 'Sth132I', 'BbvII', 'BinI', 'AspBHI', 'Bbr7I', 'BspD6I', 'BcefI', 'AceIII', 'Ksp632I'],
    )
typedict['type228'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['GsaI'],
    )
typedict['type235'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BstF5I', 'BpuEI', 'BsrI', 'MboII', 'TaqII', 'BspCNI', 'BsgI', 'TspGWI', 'BmrI', 'HpyAV', 'HphI', 'BseMII', 'MnlI', 'BseRI', 'MmeI', 'Eco57I', 'BpmI', 'AcuI', 'NmeAIII'],
    )
typedict['type237'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['MaqI', 'RpaBI', 'DraRI', 'SdeAI', 'RceI', 'WviI', 'BfiI', 'CstMI', 'PspOMII', 'TaqIII', 'CchII', 'PlaDI', 'SstE37I', 'RpaB5I', 'CdpI', 'CchIII', 'Tth111II', 'CjeNIII', 'BsbI', 'NlaCI', 'AquII', 'AquIV', 'ApyPI', 'RpaI', 'PspPRI', 'AquIII', 'RdeGBII'],
    )
typedict['type238'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['EciI', 'Mva1269I', 'Bse1I', 'LmnI', 'BtsIMutI', 'GsuI', 'BtsCI', 'BsuI', 'AsuHPI', 'AbaSI', 'BseGI', 'Bse3DI', 'BsrDI', 'BciVI', 'BtsI', 'BfuI', 'BsmI', 'BseMI', 'TspDTI', 'BmuI', 'PctI', 'BseNI'],
    )
typedict['type239'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BmeDI', 'Bce83I', 'Hin4II', 'TsoI', 'Eco57MI', 'YkrI', 'RleAI'],
    )
typedict['type240'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BceSIV'],
    )
typedict['type274'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['CspCI', 'AloI', 'BcgI'],
    )
typedict['type285'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['TstI', 'NgoAVIII', 'PpiI', 'SdeOSI', 'CjeI'],
    )
typedict['type286'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PsrI', 'AjuI', 'BaeI', 'ArsI', 'BarI', 'BsaXI'],
    )
typedict['type287'] = _temp()


def _temp():
    return (
        ('NonPalindromic', 'TwoCuts', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['CjePI', 'Bsp24I', 'Hin4I'],
    )
typedict['type288'] = _temp()


def _temp():
    return (
        ('Palindromic', 'NoCut', 'Unknown', 'NotDefined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NhoI', 'CjuI', 'AvaIII', 'TssI', 'SnaI', 'HgiEII'],
    )
typedict['type4'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['ScaI', 'SnaBI', 'MspA1I', 'CviJI', 'DraI', 'AluBI', 'PshAI', 'SwaI', 'NaeI', 'SfoI', 'RsaI', 'HincII', 'BstC8I', 'PmlI', 'AluI', 'Hpy8I', 'SmaI', 'FspI', 'PvuII', 'BsuRI', 'EcoRV', 'BstUI', 'HaeIII', 'SspI', 'BalI', 'NlaIV', 'HpaI', 'Cac8I', 'HindII', 'BsaAI'],
    )
typedict['type65'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['FnuDII', 'EsaBC3I', 'CviRI'],
    )
typedict['type66'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PspN4I', 'MslI', 'Bsp68I', 'PmaCI', 'BsaBI', 'SmiI', 'BseJI', 'BshFI', 'BmcAI', 'XmnI', 'Eco47III', 'Hpy166II', 'AcvI', 'RruI', 'EgeI', 'OliI', 'DpnI', 'Bst1107I', 'BstSNI', 'RseI', 'MlsI', 'AccII', 'BtuMI', 'Aor51HI', 'NruI', 'Bsh1236I', 'MalI', 'MssI', 'BsnI', 'FspAI', 'BmiI', 'BoxI', 'BssNAI', 'BspANI', 'GlaI', 'MvnI', 'ZraI', 'Eco72I', 'MscI', 'SseBI', 'SmiMI', 'Ppu21I', 'StuI', 'BbrPI', 'Eco53kI', 'EheI', 'BstPAI', 'Ecl136II', 'Acc16I', 'MluNI', 'PsiI', 'MroXI', 'ZrmI', 'DinI', 'BstFNI', 'BspLI', 'Eco105I', 'NsbI', 'Bse8I', 'BspFNI', 'BstZ17I', 'Msp20I', 'AfeI', 'SrfI', 'Eco32I', 'KspAI', 'AanI', 'PmeI', 'Mox20I', 'FaiI', 'Eco147I', 'CviKI_1', 'PdmI', 'HpyCH4V', 'PceI', 'BstBAI', 'AfaI', 'Asp700I', 'EcoICRI', 'PspCI', 'PdiI', 'AleI'],
    )
typedict['type67'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Blunt', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['NspBII', 'HaeI', 'SciI', 'LpnI', 'AhaIII', 'Sth302II', 'MstI'],
    )
typedict['type68'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BssHII', 'BsrFI', 'DpnII', 'MluI', 'NgoMIV', 'HpaII', 'TspMI', 'BclI', 'BsaWI', 'SalI', 'MspI', 'Bsu15I', 'NcoI', 'ClaI', 'XmaI', 'Cfr9I', 'TaqI', 'EaeI', 'AseI', 'AclI', 'ApoI', 'HpyCH4IV', 'NdeI', 'HapII', 'MseI', 'BsaHI', 'XbaI', 'MboI', 'CviQI', 'NheI', 'Sau3AI', 'CviAII', 'MfeI', 'ApaLI', 'Cfr10I', 'HinP1I', 'HspAI', 'HindIII', 'EcoRI', 'XhoI', 'BseCI', 'MunI', 'EagI', 'AscI', 'VspI', 'KasI', 'Kpn2I', 'SgrAI', 'BspHI', 'BstYI', 'AgeI', 'BfuCI', 'Sse9I', 'NotI', 'FatI', 'BamHI', 'PaeR7I'],
    )
typedict['type77'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['XmaIII', 'CfrI', 'XhoII'],
    )
typedict['type78'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['BssMI', 'AsuNHI', 'PshBI', 'BshTI', 'CciI', 'MreI', 'AhlI', 'XspI', 'KroI', 'BfaI', 'PauI', 'Asp718I', 'VneI', 'PspXI', 'AsiGI', 'CciNI', 'Sfr274I', 'PteI', 'Ksp22I', 'Bsp19I', 'MauBI', 'AbsI', 'AsuII', 'FauNDI', 'Vha464I', 'BstACI', 'AcoI', 'BstMBI', 'BssAI', 'BseAI', 'Hin6I', 'PalAI', 'BstAUI', 'Bpu14I', 'Eco52I', 'BspT104I', 'SspDI', 'AflII', 'BglII', 'TasI', 'AcsI', 'BseX3I', 'FspBI', 'RsaNI', 'Acc65I', 'AvrII', 'MaeI', 'XapI', 'PscI', 'Bsp1407I', 'SspMI', 'PciI', 'Bse118I', 'NarI', 'BsePI', 'MaeII', 'Bsp13I', 'BsiSI', 'Bsp119I', 'BstX2I', 'SlaI', 'SgsI', 'MluCI', 'PsuI', 'AspA2I', 'BcuI', 'BspTI', 'BsiWI', 'Mly113I', 'MflI', 'BshVI', 'Hin1I', 'SpeI', 'SgrDI', 'XmaJI', 'MspCI', 'Psp1406I', 'Kzo9I', 'Csp6I', 'Bsp143I', 'Bsa29I', 'AccIII', 'Tru1I', 'Aor13HI', 'PinAI', 'EclXI', 'BspEI', 'BstZI', 'Alw44I', 'Hsp92I', 'BlnI', 'NdeII', 'BsrGI', 'CspAI', 'FbaI', 'PspOMI', 'SaqAI', 'SfuI', 'NspV', 'BfrI', 'BstBI', 'BssNI', 'HpySE526I', 'Tru9I', 'Bsp120I', 'MroI', 'MroNI', 'AoxI', 'AcyI', 'BsuTUI', 'BspDI', 'BstAFI', 'TatI', 'Pfl23II', 'PspLI', 'PagI'],
    )
typedict['type79'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SelI', 'BspLU11I', 'SplI', 'TspEI', 'Asi256I', 'Ppu10I', 'Sse232I', 'BetI', 'BspMII'],
    )
typedict['type80'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['PspPI', 'AspS9I', 'StyD4I', 'PspGI', 'BsoBI', 'BlpI', 'BssECI', 'AjnI', 'AvaI', 'SexAI', 'SinI', 'Sau96I', 'BstNI', 'Cfr13I', 'TseI', 'MvaI', 'AflIII', 'TfiI', 'BanI', 'RsrII', 'BcnI', 'ScrFI', 'EcoRII', 'EcoNI', 'ApeKI', 'HinfI', 'NciI', 'Fsp4HI', 'EcoO109I', 'PpuMI', 'AvaII', 'Tth111I', 'AccI', 'DdeI', 'BsaJI', 'Fnu4HI', 'Tsp45I'],
    )
typedict['type81'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['HgiCI', 'EcoHI'],
    )
typedict['type82'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AxyI', 'BspT107I', 'PspEI', 'BisI', 'BstPI', 'BstSFI', 'BstEII', 'BmgT120I', 'BssT1I', 'PsyI', 'BtgI', 'Eco91I', 'Bst2UI', 'BstDEI', 'GluI', 'BstENI', 'Ama87I', 'BstDSI', 'PflFI', 'Bme1390I', 'Psp5II', 'EcoO65I', 'BmrFI', 'EcoT14I', 'PspPPI', 'SmlI', 'BseBI', 'PfoI', 'BshNI', 'Rsr2I', 'BmeT110I', 'PasI', 'TseFI', 'CpoI', 'Eco130I', 'CspI', 'BfmI', 'Eco47I', 'Bsu36I', 'Bme18I', 'MabI', 'Hpy188III', 'Bse21I', 'BstSCI', 'BpuMI', 'SgeI', 'XagI', 'SmoI', 'Bsp1720I', 'MaeIII', 'ErhI', 'AsuC2I', 'BsiHKCI', 'XmiI', 'MspR9I', 'VpaK11BI', 'PfeI', 'Bpu1102I', 'SfcI', 'SatI', 'BciT130I', 'KflI', 'BseDI', 'Eco81I', 'Eco88I', 'FblI', 'AccB1I', 'CsiI', 'MteI', 'Psp6I', 'HpyF3I', 'StyI', 'NmuCI'],
    )
typedict['type83'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov5', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['SanDI', 'DsaI', 'SauI', 'DraII', 'UnbI', 'VpaK11AI', 'SfeI', 'CauII', 'Hpy178III', 'AsuI', 'SecI', 'EspI', 'Sse8647I'],
    )
typedict['type84'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SacI', 'KpnI', 'HaeII', 'SacII', 'AatII', 'PluTI', 'NlaIII', 'PstI', 'Cfr42I', 'FseI', 'ApaI', 'NspI', 'HhaI', 'AsiSI'],
    )
typedict['type89'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['PabI', 'McaTI'],
    )
typedict['type90'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['SgrBI', 'BstHHI', 'BstH2I', 'BmtI', 'PvuI', 'BspOI', 'Zsp2I', 'FaeI', 'SdaI', 'BstNSI', 'Ple19I', 'Hin1II', 'Sse8387I', 'TaiI', 'Hsp92II', 'Psp124BI', 'Sfr303I', 'Mph1103I', 'CfoI', 'PaeI', 'BstKTI', 'SstI', 'AspLEI', 'SphI', 'SfaAI', 'RgaI', 'SgfI', 'SbfI', 'BspMAI', 'XceI', 'NsiI', 'EcoT22I', 'PacI', 'KspI', 'BfoI', 'RigI'],
    )
typedict['type91'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Defined', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['ChaI'],
    )
typedict['type92'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AgsI', 'MwoI', 'EcoT38I', 'BanII', 'TspRI', 'Hpy99I', 'BstXI', 'Bsc4I', 'BaeGI', 'Hpy188I', 'DraIII', 'Bsp1286I', 'AhdI', 'SfiI', 'XcmI', 'BslI'],
    )
typedict['type93'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Dep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['BthCI', 'HauII'],
    )
typedict['type94'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Commercially_available', 'AbstractCut', 'RestrictionType'),
        ['AlwNI', 'DrdI', 'BglI', 'TscAI', 'CaiI', 'BstMWI', 'Eco24I', 'BsiHKAI', 'BseSI', 'Van91I', 'DseDI', 'SetI', 'BmeRI', 'TaaI', 'BstMCI', 'HpyF10VI', 'Bst4CI', 'SduI', 'Alw21I', 'AccB7I', 'AdeI', 'BsiEI', 'BseLI', 'FriOI', 'AasI', 'Eam1105I', 'TauI', 'AfiI', 'Bbv12I', 'BstAPI', 'HpyCH4III', 'BstSLI', 'BlsI', 'PcsI', 'PstNI', 'PkrI', 'MhlI', 'DriI', 'Bsh1285I', 'PflMI'],
    )
typedict['type95'] = _temp()


def _temp():
    return (
        ('Palindromic', 'OneCut', 'Ov3', 'Ambiguous', 'Meth_Undep', 'Not_available', 'AbstractCut', 'RestrictionType'),
        ['Nli3877I', 'Psp03I', 'BsiYI', 'ApaBI', 'Tsp4CI', 'FmuI', 'McrI', 'HgiJII', 'PssI', 'HgiAI'],
    )
typedict['type96'] = _temp()

del _temp
