/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.NameClassPairWithControls;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;

class LdapNamingEnumeration
implements NamingEnumeration,
ReferralEnumeration {
    protected Name listArg;
    private boolean cleaned = false;
    private LdapResult res;
    private LdapClient enumClnt;
    private Continuation cont;
    private Vector entries = null;
    private int limit = 0;
    private int posn = 0;
    protected LdapCtx homeCtx;
    private LdapReferralException refEx = null;
    private NamingException errEx = null;
    private static final String defaultClassName = DirContext.class.getName();
    private boolean more = true;
    private boolean hasMoreCalled = false;

    LdapNamingEnumeration(LdapCtx homeCtx, LdapResult answer, Name listArg, Continuation cont) throws NamingException {
        if (answer.status != 0 && answer.status != 4 && answer.status != 3 && answer.status != 11 && answer.status != 10 && answer.status != 9) {
            NamingException e = new NamingException(LdapClient.getErrorMessage(answer.status, answer.errorMessage));
            throw cont.fillInException(e);
        }
        this.res = answer;
        this.entries = answer.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.listArg = listArg;
        this.cont = cont;
        if (answer.refEx != null) {
            this.refEx = answer.refEx;
        }
        this.homeCtx = homeCtx;
        homeCtx.incEnumCount();
        this.enumClnt = homeCtx.clnt;
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            this.cleanup();
            return null;
        }
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            this.cleanup();
            return false;
        }
    }

    private void getNextBatch() throws NamingException {
        this.res = this.homeCtx.getSearchReply(this.enumClnt, this.res);
        if (this.res == null) {
            this.posn = 0;
            this.limit = 0;
            return;
        }
        this.entries = this.res.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.posn = 0;
        if (this.res.status != 0 || this.res.status == 0 && this.res.referrals != null) {
            try {
                this.homeCtx.processReturnCode(this.res, this.listArg);
            }
            catch (LimitExceededException e) {
                this.setNamingException(e);
            }
            catch (PartialResultException e) {
                this.setNamingException(e);
            }
        }
        if (this.res.refEx != null) {
            this.refEx = this.refEx == null ? this.res.refEx : this.refEx.appendUnprocessedReferrals(this.res.refEx);
            this.res.refEx = null;
        }
        if (this.res.resControls != null) {
            this.homeCtx.respCtls = this.res.resControls;
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        if (this.hasMoreCalled) {
            return this.more;
        }
        this.hasMoreCalled = true;
        if (!this.more) {
            return false;
        }
        this.more = this.hasMoreImpl();
        return this.more;
    }

    public Object next() throws NamingException {
        if (!this.hasMoreCalled) {
            this.hasMore();
        }
        this.hasMoreCalled = false;
        return this.nextImpl();
    }

    private boolean hasMoreImpl() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn < this.limit) {
            return true;
        }
        try {
            return this.hasMoreReferrals();
        }
        catch (LdapReferralException e) {
            this.cleanup();
            throw e;
        }
        catch (LimitExceededException e) {
            this.cleanup();
            throw e;
        }
        catch (PartialResultException e) {
            this.cleanup();
            throw e;
        }
        catch (NamingException e) {
            this.cleanup();
            PartialResultException pre = new PartialResultException();
            pre.setRootCause(e);
            throw pre;
        }
    }

    private Object nextImpl() throws NamingException {
        try {
            return this.nextAux();
        }
        catch (NamingException e) {
            this.cleanup();
            throw this.cont.fillInException(e);
        }
    }

    private Object nextAux() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn >= this.limit) {
            this.cleanup();
            throw new NoSuchElementException("invalid enumeration handle");
        }
        LdapEntry result = (LdapEntry)this.entries.elementAt(this.posn++);
        return this.createItem(result.DN, result.attributes, result.respCtls);
    }

    protected String getAtom(String dn) {
        try {
            LdapName parsed = new LdapName(dn);
            return parsed.get(parsed.size() - 1);
        }
        catch (NamingException e) {
            return dn;
        }
    }

    protected NameClassPair createItem(String dn, Attributes attrs, Vector respCtls) throws NamingException {
        String className = null;
        Attribute attr = attrs.get(Obj.JAVA_ATTRIBUTES[2]);
        className = attr != null ? (String)attr.get() : defaultClassName;
        CompositeName cn = new CompositeName();
        cn.add(this.getAtom(dn));
        NameClassPair ncp = respCtls != null ? new NameClassPairWithControls(cn.toString(), className, this.homeCtx.convertControls(respCtls)) : new NameClassPair(cn.toString(), className);
        ncp.setNameInNamespace(dn);
        return ncp;
    }

    @Override
    public void appendUnprocessedReferrals(LdapReferralException ex) {
        this.refEx = this.refEx != null ? this.refEx.appendUnprocessedReferrals(ex) : ex.appendUnprocessedReferrals(this.refEx);
    }

    void setNamingException(NamingException e) {
        this.errEx = e;
    }

    protected LdapNamingEnumeration getReferredResults(LdapReferralContext refCtx) throws NamingException {
        return (LdapNamingEnumeration)refCtx.list(this.listArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMoreReferrals() throws NamingException {
        if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
            if (this.homeCtx.handleReferrals == 2) {
                throw (NamingException)this.refEx.fillInStackTrace();
            }
            while (true) {
                LdapReferralContext refCtx = (LdapReferralContext)this.refEx.getReferralContext(this.homeCtx.envprops, this.homeCtx.reqCtls);
                try {
                    this.update(this.getReferredResults(refCtx));
                }
                catch (LdapReferralException re) {
                    if (this.errEx == null) {
                        this.errEx = re.getNamingException();
                    }
                    this.refEx = re;
                    continue;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
            return this.hasMoreImpl();
        }
        this.cleanup();
        if (this.errEx != null) {
            throw this.errEx;
        }
        return false;
    }

    protected void update(LdapNamingEnumeration ne) {
        this.homeCtx.decEnumCount();
        this.homeCtx = ne.homeCtx;
        this.enumClnt = ne.enumClnt;
        ne.homeCtx = null;
        this.posn = ne.posn;
        this.limit = ne.limit;
        this.res = ne.res;
        this.entries = ne.entries;
        this.refEx = ne.refEx;
        this.listArg = ne.listArg;
    }

    protected void finalize() {
        this.cleanup();
    }

    protected void cleanup() {
        if (this.cleaned) {
            return;
        }
        if (this.enumClnt != null) {
            this.enumClnt.clearSearchReply(this.res, this.homeCtx.reqCtls);
        }
        this.enumClnt = null;
        this.cleaned = true;
        if (this.homeCtx != null) {
            this.homeCtx.decEnumCount();
            this.homeCtx = null;
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }
}

