/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound;

import dguitar.adaptors.song.SongEvent;
import dguitar.adaptors.song.SongMessage;
import dguitar.adaptors.song.SongTrack;
import dguitar.adaptors.song.event.SongEventImpl;
import dguitar.adaptors.song.event.SongNoteOffMessage;
import dguitar.adaptors.song.event.SongNoteOnMessage;
import dguitar.adaptors.song.event.SongTieMessage;
import dguitar.players.sound.PerformanceEvent;
import dguitar.players.sound.PerformanceNoteEvent;
import java.util.Iterator;
import java.util.List;

public class EventStream {
    SongTrack track;
    int virtualTrackIndex;
    PerformanceEvent first;
    PerformanceEvent last;
    int lastEventEndOffset;
    int lastEventLocation;
    SongEvent lastNoteOnEvent;

    public EventStream(SongTrack songTrack, int v) {
        this.track = songTrack;
        this.virtualTrackIndex = v;
        this.first = null;
        this.last = null;
    }

    public void addEvents(List events, int location) {
        Iterator it = events.iterator();
        while (it.hasNext()) {
            PerformanceNoteEvent perfEvent;
            SongEvent event = (SongEvent)it.next();
            int baseTime = event.getTime();
            SongMessage message = event.getMessage();
            if (message instanceof SongNoteOnMessage) {
                this.closeOpenNote();
                perfEvent = new PerformanceNoteEvent(this, baseTime + location, event);
                this.connect(perfEvent);
                this.lastNoteOnEvent = event;
                SongNoteOnMessage noteOn = (SongNoteOnMessage)message;
                this.lastEventEndOffset = baseTime + noteOn.getDuration();
                this.lastEventLocation = location;
                continue;
            }
            if (!(message instanceof SongTieMessage)) continue;
            perfEvent = new PerformanceNoteEvent(this, baseTime + location, event);
            this.connect(perfEvent);
            SongTieMessage tie = (SongTieMessage)message;
            this.lastEventEndOffset = baseTime + tie.getDuration();
            this.lastEventLocation = location;
        }
    }

    private void closeOpenNote() {
        if (this.lastNoteOnEvent != null) {
            SongNoteOnMessage noteOn = (SongNoteOnMessage)this.lastNoteOnEvent.getMessage();
            SongNoteOffMessage snom = new SongNoteOffMessage(noteOn);
            SongEventImpl snoe = new SongEventImpl(this.lastEventEndOffset, snom);
            snoe.setVirtualTrack(this.lastNoteOnEvent.getVirtualTrack());
            PerformanceNoteEvent perfEvent2 = new PerformanceNoteEvent(this, this.lastEventEndOffset + this.lastEventLocation, snoe);
            this.connect(perfEvent2);
            this.lastNoteOnEvent = null;
        }
    }

    private void connect(PerformanceEvent perfEvent) {
        if (this.last != null) {
            this.last.setNext(perfEvent);
        }
        this.last = perfEvent;
        if (this.first == null) {
            this.first = perfEvent;
        }
    }

    public PerformanceEvent getFirst() {
        return this.first;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public int getVirtualTrackIndex() {
        return this.virtualTrackIndex;
    }

    public void close() {
        this.closeOpenNote();
    }
}

