/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgParser;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelStreams;

public class SimpleModel
extends MovAvgModel {
    protected static final ParseField NAME_FIELD = new ParseField("simple", new String[0]);
    public static final MovAvgModelStreams.Stream STREAM = new MovAvgModelStreams.Stream(){

        @Override
        public MovAvgModel readResult(StreamInput in) throws IOException {
            return new SimpleModel();
        }

        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }
    };

    @Override
    public boolean canBeMinimized() {
        return false;
    }

    @Override
    public MovAvgModel neighboringModel() {
        return new SimpleModel();
    }

    @Override
    public MovAvgModel clone() {
        return new SimpleModel();
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, this.next(values));
        return predictions;
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        double avg = 0.0;
        for (Number v : values) {
            avg += v.doubleValue();
        }
        return avg / (double)values.size();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
    }

    public static class SimpleModelBuilder
    implements MovAvgModelBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgParser.MODEL.getPreferredName(), NAME_FIELD.getPreferredName());
            return builder;
        }
    }

    public static class SimpleModelParser
    extends MovAvgModel.AbstractModelParser {
        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize, ParseFieldMatcher parseFieldMatcher) throws ParseException {
            this.checkUnrecognizedParams(settings);
            return new SimpleModel();
        }
    }
}

