/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.UndoEventReceiver;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.hooks.PermanentMindMapNodeHookAdapter;
import freemind.view.mindmapview.MultipleImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeSet;

public class HierarchicalIcons
extends PermanentMindMapNodeHookAdapter
implements UndoEventReceiver {
    private HashMap nodeIconSets = new HashMap();

    @Override
    public void shutdownMapHook() {
        MindMapNode root = this.getMindMapController().getRootNode();
        this.removeIcons(root);
        super.shutdownMapHook();
    }

    private void removeIcons(MindMapNode node) {
        node.setStateIcon(this.getName(), null);
        this.getMindMapController().nodeRefresh(node);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.removeIcons(child);
        }
    }

    private void setStyle(MindMapNode node) {
        TreeSet storedIconSet;
        TreeSet iconSet = new TreeSet();
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.addAccumulatedIconsToTreeSet(child, iconSet, (TreeSet)this.nodeIconSets.get(child));
        }
        for (MindIcon icon : node.getIcons()) {
            iconSet.remove(icon.getName());
        }
        boolean dirty = true;
        if (this.nodeIconSets.containsKey(node) && (storedIconSet = (TreeSet)this.nodeIconSets.get(node)).equals(iconSet)) {
            dirty = false;
        }
        this.nodeIconSets.put(node, iconSet);
        if (dirty) {
            if (iconSet.size() > 0) {
                MultipleImage image = new MultipleImage(0.75);
                for (String iconName : iconSet) {
                    MindIcon icon = MindIcon.factory(iconName);
                    image.addImage(icon.getIcon());
                }
                node.setStateIcon(this.getName(), image);
            } else {
                node.setStateIcon(this.getName(), null);
            }
            this.getMindMapController().nodeRefresh(node);
        }
    }

    private void addAccumulatedIconsToTreeSet(MindMapNode child, TreeSet iconSet, TreeSet childsTreeSet) {
        for (MindIcon icon : child.getIcons()) {
            iconSet.add(icon.getName());
        }
        if (childsTreeSet == null) {
            return;
        }
        for (String iconName : childsTreeSet) {
            iconSet.add(iconName);
        }
    }

    @Override
    public void onAddChildren(MindMapNode newChildNode) {
        this.logger.finest("onAddChildren " + newChildNode);
        super.onAddChild(newChildNode);
        this.setStyleRecursive(newChildNode);
    }

    @Override
    public void onRemoveChildren(MindMapNode removedChild, MindMapNode oldDad) {
        this.logger.finest("onRemoveChildren " + removedChild);
        super.onRemoveChildren(removedChild, oldDad);
        this.setStyleRecursive(oldDad);
    }

    @Override
    public void onUpdateChildrenHook(MindMapNode updatedNode) {
        super.onUpdateChildrenHook(updatedNode);
        this.setStyleRecursive(updatedNode);
    }

    @Override
    public void onUpdateNodeHook() {
        super.onUpdateNodeHook();
        this.setStyle(this.getNode());
    }

    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.gatherLeavesAndSetStyle(node);
        this.gatherLeavesAndSetParentsStyle(node);
    }

    private void gatherLeavesAndSetStyle(MindMapNode node) {
        if (node.getChildCount() == 0) {
            this.setStyle(node);
            return;
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.gatherLeavesAndSetStyle(child);
        }
    }

    private void gatherLeavesAndSetParentsStyle(MindMapNode node) {
        if (node.getChildCount() == 0) {
            if (node.getParentNode() != null) {
                this.setStyleRecursive(node.getParentNode());
            }
            return;
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.gatherLeavesAndSetParentsStyle(child);
        }
    }

    private void setStyleRecursive(MindMapNode node) {
        this.setStyle(node);
        if (node.getParentNode() != null) {
            this.setStyleRecursive(node.getParentNode());
        }
    }
}

