/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotWithKey;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileCollectionSnapshotImpl
implements FileCollectionSnapshot {
    final Map<String, IncrementalFileSnapshot> snapshots;
    final List<TreeSnapshot> treeSnapshots;

    public FileCollectionSnapshotImpl(List<TreeSnapshot> treeSnapshots) {
        this.treeSnapshots = ImmutableList.copyOf(treeSnapshots);
        this.snapshots = new HashMap<String, IncrementalFileSnapshot>();
        for (TreeSnapshot treeSnapshot : treeSnapshots) {
            this.addSnapshots(treeSnapshot.getFileSnapshots());
        }
    }

    public FileCollectionSnapshotImpl(Map<String, IncrementalFileSnapshot> snapshots) {
        this.snapshots = snapshots;
        this.treeSnapshots = null;
    }

    private void addSnapshots(Collection<FileSnapshotWithKey> fileSnapshots) {
        for (FileSnapshotWithKey fileSnapshotWithKey : fileSnapshots) {
            this.snapshots.put(fileSnapshotWithKey.getKey(), fileSnapshotWithKey.getIncrementalFileSnapshot());
        }
    }

    public List<File> getFiles() {
        ArrayList files = Lists.newArrayList();
        for (Map.Entry<String, IncrementalFileSnapshot> entry : this.snapshots.entrySet()) {
            if (entry.getValue() instanceof DirSnapshot) continue;
            files.add(new File(entry.getKey()));
        }
        return files;
    }

    @Override
    public Map<String, IncrementalFileSnapshot> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public FilesSnapshotSet getSnapshot() {
        return new FilesSnapshotSet(){

            public FileSnapshot findSnapshot(File file) {
                IncrementalFileSnapshot s = FileCollectionSnapshotImpl.this.snapshots.get(file.getAbsolutePath());
                if (s instanceof FileSnapshot) {
                    return (FileSnapshot)((Object)s);
                }
                return null;
            }
        };
    }

    @Override
    public Collection<Long> getTreeSnapshotIds() {
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        if (this.treeSnapshots != null) {
            for (TreeSnapshot treeSnapshot : this.treeSnapshots) {
                if (!treeSnapshot.isShareable() || treeSnapshot.getAssignedId() == null || treeSnapshot.getAssignedId() == -1L) continue;
                snapshotIds.add(treeSnapshot.getAssignedId());
            }
        }
        return snapshotIds;
    }

    @Override
    public boolean isEmpty() {
        return this.snapshots.isEmpty();
    }

    @Override
    public FileCollectionSnapshot.ChangeIterator<String> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, Set<FileCollectionSnapshot.ChangeFilter> filters) {
        final HashMap<String, IncrementalFileSnapshot> otherSnapshots = new HashMap<String, IncrementalFileSnapshot>(oldSnapshot.getSnapshots());
        final Iterator<String> currentFiles = this.snapshots.keySet().iterator();
        final boolean includeAdded = !filters.contains((Object)FileCollectionSnapshot.ChangeFilter.IgnoreAddedFiles);
        return new FileCollectionSnapshot.ChangeIterator<String>(){
            private Iterator<String> removedFiles;

            @Override
            public boolean next(ChangeListener<String> listener) {
                while (currentFiles.hasNext()) {
                    String currentFile = (String)currentFiles.next();
                    IncrementalFileSnapshot otherFile = (IncrementalFileSnapshot)otherSnapshots.remove(currentFile);
                    if (otherFile == null) {
                        if (!includeAdded) continue;
                        listener.added(currentFile);
                        return true;
                    }
                    if (FileCollectionSnapshotImpl.this.snapshots.get(currentFile).isContentUpToDate(otherFile)) continue;
                    listener.changed(currentFile);
                    return true;
                }
                if (this.removedFiles == null) {
                    this.removedFiles = otherSnapshots.keySet().iterator();
                }
                if (this.removedFiles.hasNext()) {
                    listener.removed(this.removedFiles.next());
                    return true;
                }
                return false;
            }
        };
    }
}

