/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Transformer;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.CancellableModelBuilderBackedModelProducer;
import org.gradle.tooling.internal.consumer.connection.InternalBuildActionAdapter;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.connection.PluginClasspathInjectionSupportedCheckModelProducer;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancellableConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ActionRunner actionRunner;
    private final ModelProducer modelProducer;

    public CancellableConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R21VersionDetails(delegate.getMetaData().getVersion()));
        ExceptionTransformer exceptionTransformer = new ExceptionTransformer();
        InternalCancellableConnection connection = (InternalCancellableConnection)((Object)delegate);
        this.modelProducer = this.createModelProducer(connection, modelMapping, adapter, exceptionTransformer);
        this.actionRunner = new CancellableActionRunner(connection, adapter, exceptionTransformer);
    }

    protected ModelProducer createModelProducer(InternalCancellableConnection connection, ModelMapping modelMapping, ProtocolToModelAdapter adapter, Transformer<RuntimeException, RuntimeException> exceptionTransformer) {
        return new PluginClasspathInjectionSupportedCheckModelProducer(this.getVersionDetails().getVersion(), new CancellableModelBuilderBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, connection, exceptionTransformer));
    }

    @Override
    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    @Override
    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CancellableActionRunner
    implements ActionRunner {
        private final InternalCancellableConnection executor;
        private final ProtocolToModelAdapter adapter;
        private final Transformer<RuntimeException, RuntimeException> exceptionTransformer;

        private CancellableActionRunner(InternalCancellableConnection executor, ProtocolToModelAdapter adapter, Transformer<RuntimeException, RuntimeException> exceptionTransformer) {
            this.executor = executor;
            this.adapter = adapter;
            this.exceptionTransformer = exceptionTransformer;
        }

        @Override
        public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
            BuildResult<T> result;
            try {
                try {
                    result = this.executor.run(new InternalBuildActionAdapter<T>(action, this.adapter), new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
                }
                catch (RuntimeException e) {
                    throw this.exceptionTransformer.transform(e);
                }
            }
            catch (InternalBuildActionFailureException e) {
                throw new BuildActionFailureException("The supplied build action failed with an exception.", e.getCause());
            }
            return result.getModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionTransformer
    implements Transformer<RuntimeException, RuntimeException> {
        private ExceptionTransformer() {
        }

        @Override
        public RuntimeException transform(RuntimeException e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!"org.gradle.api.BuildCancelledException".equals(t.getClass().getName()) && !"org.gradle.tooling.BuildCancelledException".equals(t.getClass().getName())) continue;
                return new InternalBuildCancelledException(e.getCause());
            }
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R21VersionDetails
    extends VersionDetails {
        private R21VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsTaskDisplayName() {
            return true;
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return true;
        }

        @Override
        public boolean supportsCancellation() {
            return true;
        }
    }
}

