/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class MultipolygonBuilder {
    private static final ForkJoinPool THREAD_POOL = Utils.newForkJoinPool("multipolygon_creation.numberOfThreads", "multipolygon-builder-%d", 5);
    public final List<JoinedPolygon> outerWays;
    public final List<JoinedPolygon> innerWays;

    public MultipolygonBuilder(List<JoinedPolygon> list, List<JoinedPolygon> list2) {
        this.outerWays = list;
        this.innerWays = list2;
    }

    public MultipolygonBuilder() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> collection) {
        try {
            List<JoinedPolygon> list = MultipolygonBuilder.joinWays(collection);
            return this.makeFromPolygons(list);
        }
        catch (JoinedPolygonCreationException joinedPolygonCreationException) {
            Main.debug(joinedPolygonCreationException);
            return joinedPolygonCreationException.getMessage();
        }
    }

    public static Pair<List<JoinedPolygon>, List<JoinedPolygon>> joinWays(Relation relation) {
        CheckParameterUtil.ensureThat(relation.isMultipolygon(), "multipolygon.isMultipolygon");
        Map map = relation.getMembers().stream().filter(RelationMember::isWay).collect(Collectors.groupingBy(RelationMember::getRole, Collectors.mapping(RelationMember::getWay, Collectors.toSet())));
        List<JoinedPolygon> list = MultipolygonBuilder.joinWays(map.getOrDefault("outer", Collections.emptySet()));
        List<JoinedPolygon> list2 = MultipolygonBuilder.joinWays(map.getOrDefault("inner", Collections.emptySet()));
        return Pair.create(list, list2);
    }

    public static List<JoinedPolygon> joinWays(Collection<Way> collection) {
        Object object;
        ArrayList<JoinedPolygon> arrayList = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> multiMap = new MultiMap<Node, Way>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : collection) {
            if (way.getNodesCount() < 2) {
                throw new JoinedPolygonCreationException(I18n.tr("Cannot add a way with only {0} nodes.", way.getNodesCount()));
            }
            if (way.isClosed()) {
                object = new JoinedPolygon(way);
                arrayList.add((JoinedPolygon)object);
                hashSet.add(way);
                continue;
            }
            multiMap.put(way.lastNode(), way);
            multiMap.put(way.firstNode(), way);
        }
        for (Way way : collection) {
            if (hashSet.contains(way)) continue;
            object = way.firstNode();
            ArrayList<Way> arrayList2 = new ArrayList<Way>();
            ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
            Way way2 = way;
            Object object2 = object;
            while (true) {
                boolean bl = object2 == way2.lastNode();
                Node node = bl ? way2.firstNode() : way2.lastNode();
                arrayList2.add(way2);
                arrayList3.add(bl);
                if (node == object) break;
                Set set = multiMap.get(node);
                if (set.size() != 2) {
                    throw new JoinedPolygonCreationException(I18n.tr("Each node must connect exactly 2 ways", new Object[0]));
                }
                Way way3 = null;
                for (Way way4 : set) {
                    if (way4 == way2) continue;
                    way3 = way4;
                }
                way2 = way3;
                object2 = node;
            }
            hashSet.addAll(arrayList2);
            arrayList.add(new JoinedPolygon(arrayList2, arrayList3));
        }
        return arrayList;
    }

    private String makeFromPolygons(List<JoinedPolygon> list) {
        List<PolygonLevel> list2 = MultipolygonBuilder.findOuterWaysMultiThread(list);
        if (list2 == null) {
            return I18n.tr("There is an intersection between ways.", new Object[0]);
        }
        this.outerWays.clear();
        this.innerWays.clear();
        for (PolygonLevel polygonLevel : list2) {
            if (polygonLevel.level % 2 == 0) {
                this.outerWays.add(polygonLevel.outerWay);
                continue;
            }
            this.innerWays.add(polygonLevel.outerWay);
        }
        return null;
    }

    private static Pair<Boolean, List<JoinedPolygon>> findInnerWaysCandidates(JoinedPolygon joinedPolygon, Collection<JoinedPolygon> collection) {
        boolean bl = true;
        ArrayList<JoinedPolygon> arrayList = new ArrayList<JoinedPolygon>();
        for (JoinedPolygon joinedPolygon2 : collection) {
            if (joinedPolygon2 == joinedPolygon || !joinedPolygon.bounds.intersects(joinedPolygon2.bounds)) continue;
            Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(joinedPolygon.area, joinedPolygon2.area);
            if (polygonIntersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                bl = false;
                break;
            }
            if (polygonIntersection == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                arrayList.add(joinedPolygon2);
                continue;
            }
            if (polygonIntersection != Geometry.PolygonIntersection.CROSSING) continue;
            return null;
        }
        return new Pair<Boolean, List<JoinedPolygon>>(bl, arrayList);
    }

    private static List<PolygonLevel> findOuterWaysMultiThread(List<JoinedPolygon> list) {
        return THREAD_POOL.invoke(new Worker(list, 0, list.size(), new ArrayList<PolygonLevel>(), Math.max(32, list.size() / THREAD_POOL.getParallelism() / 3)));
    }

    private static class Worker
    extends RecursiveTask<List<PolygonLevel>> {
        private static final long serialVersionUID = 1L;
        private final transient List<JoinedPolygon> input;
        private final int from;
        private final int to;
        private final transient List<PolygonLevel> output;
        private final int directExecutionTaskSize;

        Worker(List<JoinedPolygon> list, int n, int n2, List<PolygonLevel> list2, int n3) {
            this.input = list;
            this.from = n;
            this.to = n2;
            this.output = list2;
            this.directExecutionTaskSize = n3;
        }

        private static List<PolygonLevel> findOuterWaysRecursive(int n, List<JoinedPolygon> list) {
            ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
            for (JoinedPolygon joinedPolygon : list) {
                if (Worker.processOuterWay(n, list, arrayList, joinedPolygon) != null) continue;
                return null;
            }
            return arrayList;
        }

        private static List<PolygonLevel> processOuterWay(int n, List<JoinedPolygon> list, List<PolygonLevel> list2, JoinedPolygon joinedPolygon) {
            Pair pair = MultipolygonBuilder.findInnerWaysCandidates(joinedPolygon, list);
            if (pair == null) {
                return null;
            }
            if (((Boolean)pair.a).booleanValue()) {
                PolygonLevel polygonLevel = new PolygonLevel(joinedPolygon, n);
                if (!((List)pair.b).isEmpty()) {
                    List<PolygonLevel> list3 = Worker.findOuterWaysRecursive(n + 1, (List)pair.b);
                    if (list3 == null) {
                        return null;
                    }
                    list2.addAll(list3);
                    for (PolygonLevel polygonLevel2 : list3) {
                        if (polygonLevel2.level != n + 1) continue;
                        polygonLevel.innerWays.add(polygonLevel2.outerWay);
                    }
                }
                list2.add(polygonLevel);
            }
            return list2;
        }

        @Override
        protected List<PolygonLevel> compute() {
            if (this.to - this.from <= this.directExecutionTaskSize) {
                return this.computeDirectly();
            }
            ArrayList<Worker> arrayList = new ArrayList<Worker>();
            for (int i = this.from; i < this.to; i += this.directExecutionTaskSize) {
                arrayList.add(new Worker(this.input, i, Math.min(i + this.directExecutionTaskSize, this.to), new ArrayList<PolygonLevel>(), this.directExecutionTaskSize));
            }
            for (ForkJoinTask forkJoinTask : ForkJoinTask.invokeAll(arrayList)) {
                List list = (List)forkJoinTask.join();
                if (list == null) {
                    return null;
                }
                this.output.addAll(list);
            }
            return this.output;
        }

        List<PolygonLevel> computeDirectly() {
            for (int i = this.from; i < this.to; ++i) {
                if (Worker.processOuterWay(0, this.input, this.output, this.input.get(i)) != null) continue;
                return null;
            }
            return this.output;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }

    public static class JoinedPolygonCreationException
    extends RuntimeException {
        public JoinedPolygonCreationException(String string) {
            super(string);
        }
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        PolygonLevel(JoinedPolygon joinedPolygon, int n) {
            this.outerWay = joinedPolygon;
            this.level = n;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;
        public final Area area;
        public final Rectangle bounds;

        public JoinedPolygon(List<Way> list, List<Boolean> list2) {
            this.ways = list;
            this.reversed = list2;
            this.nodes = this.getNodes();
            this.area = Geometry.getArea(this.nodes);
            this.bounds = this.area.getBounds();
        }

        public JoinedPolygon(Way way) {
            this(Collections.singletonList(way), Collections.singletonList(Boolean.FALSE));
        }

        public List<Node> getNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < this.ways.size(); ++i) {
                int n;
                Way way = this.ways.get(i);
                boolean bl = this.reversed.get(i);
                if (!bl) {
                    for (n = 0; n < way.getNodesCount() - 1; ++n) {
                        arrayList.add(way.getNode(n));
                    }
                    continue;
                }
                for (n = way.getNodesCount() - 1; n > 0; --n) {
                    arrayList.add(way.getNode(n));
                }
            }
            return arrayList;
        }
    }
}

