/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;

public class NoteData {
    private long newNoteId = -1L;
    private final Storage<Note> noteList;
    private Note selectedNote;
    private Comparator<Note> comparator = DEFAULT_COMPARATOR;
    public static final Comparator<Note> DEFAULT_COMPARATOR = (note, note2) -> {
        if (note.getId() < 0L && note2.getId() > 0L) {
            return 1;
        }
        if (note.getId() > 0L && note2.getId() < 0L) {
            return -1;
        }
        if (note.getState() == Note.State.CLOSED && note2.getState() == Note.State.OPEN) {
            return 1;
        }
        if (note.getState() == Note.State.OPEN && note2.getState() == Note.State.CLOSED) {
            return -1;
        }
        return Long.compare(Math.abs(note.getId()), Math.abs(note2.getId()));
    };
    public static final Comparator<Note> DATE_COMPARATOR = (note, note2) -> note.getCreatedAt().compareTo(note2.getCreatedAt());
    public static final Comparator<Note> USER_COMPARATOR = (note, note2) -> {
        String string;
        String string2 = note.getFirstComment().getUser().getName();
        if (string2.equals(string = note2.getFirstComment().getUser().getName())) {
            return note.getCreatedAt().compareTo(note2.getCreatedAt());
        }
        return note.getFirstComment().getUser().getName().compareTo(note2.getFirstComment().getUser().getName());
    };
    public static final Comparator<Note> LAST_ACTION_COMPARATOR = (note, note2) -> {
        Date date = note.getComments().get(note.getComments().size() - 1).getCommentTimestamp();
        Date date2 = note2.getComments().get(note2.getComments().size() - 1).getCommentTimestamp();
        return date.compareTo(date2);
    };

    public NoteData(Collection<Note> collection) {
        this.noteList = new Storage();
        if (collection != null) {
            for (Note note : collection) {
                this.noteList.add(note);
                if (note.getId() > this.newNoteId) continue;
                this.newNoteId = note.getId() - 1L;
            }
        }
    }

    public Collection<Note> getNotes() {
        return Collections.unmodifiableCollection(this.noteList);
    }

    public Collection<Note> getSortedNotes() {
        ArrayList<Note> arrayList = new ArrayList<Note>(this.noteList);
        arrayList.sort(this.comparator);
        return arrayList;
    }

    public Note getSelectedNote() {
        return this.selectedNote;
    }

    public void setSelectedNote(Note note) {
        this.selectedNote = note;
        if (Main.map != null) {
            Main.map.noteDialog.selectionChanged();
            Main.map.mapView.repaint();
        }
    }

    public synchronized boolean isModified() {
        for (Note note : this.noteList) {
            if (note.getId() < 0L) {
                return true;
            }
            for (NoteComment noteComment : note.getComments()) {
                if (!noteComment.isNew()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotes(Collection<Note> collection) {
        for (Note note : collection) {
            if (!this.noteList.contains(note)) {
                this.noteList.add(note);
            } else {
                Note note2 = this.noteList.get(note);
                boolean bl = note2.getComments().stream().anyMatch(NoteComment::isNew);
                if (!bl) {
                    this.noteList.put(note);
                } else {
                    Main.info("Keeping existing note id={0} with uncommitted changes", String.valueOf(note.getId()));
                }
            }
            if (note.getId() > this.newNoteId) continue;
            this.newNoteId = note.getId() - 1L;
        }
        this.dataUpdated();
    }

    public synchronized void createNote(LatLon latLon, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Comment can not be blank when creating a note");
        }
        Note note = new Note(latLon);
        note.setCreatedAt(new Date());
        note.setState(Note.State.OPEN);
        note.setId(this.newNoteId--);
        NoteComment noteComment = new NoteComment(new Date(), NoteData.getCurrentUser(), string, NoteComment.Action.OPENED, true);
        note.addComment(noteComment);
        if (Main.isDebugEnabled()) {
            Main.debug("Created note {0} with comment: {1}", note.getId(), string);
        }
        this.noteList.add(note);
        this.dataUpdated();
    }

    public synchronized void addCommentToNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to modify must be in layer");
        }
        if (note.getState() == Note.State.CLOSED) {
            throw new IllegalStateException("Cannot add a comment to a closed note");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("Adding comment to note {0}: {1}", note.getId(), string);
        }
        NoteComment noteComment = new NoteComment(new Date(), NoteData.getCurrentUser(), string, NoteComment.Action.COMMENTED, true);
        note.addComment(noteComment);
        this.dataUpdated();
    }

    public synchronized void closeNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to close must be in layer");
        }
        if (note.getState() != Note.State.OPEN) {
            throw new IllegalStateException("Cannot close a note that isn't open");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("closing note {0} with comment: {1}", note.getId(), string);
        }
        NoteComment noteComment = new NoteComment(new Date(), NoteData.getCurrentUser(), string, NoteComment.Action.CLOSED, true);
        note.addComment(noteComment);
        note.setState(Note.State.CLOSED);
        note.setClosedAt(new Date());
        this.dataUpdated();
    }

    public synchronized void reOpenNote(Note note, String string) {
        if (!this.noteList.contains(note)) {
            throw new IllegalArgumentException("Note to reopen must be in layer");
        }
        if (note.getState() != Note.State.CLOSED) {
            throw new IllegalStateException("Cannot reopen a note that isn't closed");
        }
        if (Main.isDebugEnabled()) {
            Main.debug("reopening note {0} with comment: {1}", note.getId(), string);
        }
        NoteComment noteComment = new NoteComment(new Date(), NoteData.getCurrentUser(), string, NoteComment.Action.REOPENED, true);
        note.addComment(noteComment);
        note.setState(Note.State.OPEN);
        this.dataUpdated();
    }

    private void dataUpdated() {
        if (Main.isDisplayingMapView()) {
            Main.map.noteDialog.setNotes(this.getSortedNotes());
            Main.map.mapView.repaint();
        }
    }

    private static User getCurrentUser() {
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        return User.createOsmUser(josmUserIdentityManager.getUserId(), josmUserIdentityManager.getUserName());
    }

    public synchronized void updateNotes(Map<Note, Note> map) {
        for (Map.Entry<Note, Note> entry : map.entrySet()) {
            boolean bl;
            Note note = entry.getKey();
            Note note2 = entry.getValue();
            boolean bl2 = bl = note.hashCode() != note2.hashCode();
            if (bl) {
                this.noteList.removeElem(note);
            }
            note.updateWith(note2);
            if (!bl) continue;
            this.noteList.add(note);
        }
        this.dataUpdated();
    }

    public Comparator<Note> getCurrentSortMethod() {
        return this.comparator;
    }

    public void setSortMethod(Comparator<Note> comparator) {
        this.comparator = comparator;
        this.dataUpdated();
    }
}

