/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = TagConflictResolverModel.class.getName() + ".numConflicts";
    private transient TagCollection tags;
    private List<String> displayedKeys;
    private final Set<String> keysWithConflicts = new HashSet<String>();
    private transient Map<String, MultiValueResolutionDecision> decisions;
    private int numConflicts = 0;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean showTagsWithConflictsOnly;
    private boolean showTagsWithMultiValuesOnly;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void setNumConflicts(int n) {
        int n2 = this.numConflicts;
        this.numConflicts = n;
        if (n2 != this.numConflicts) {
            this.support.firePropertyChange(NUM_CONFLICTS_PROP, n2, this.numConflicts);
        }
    }

    protected void refreshNumConflicts() {
        this.setNumConflicts((int)this.decisions.values().stream().filter(multiValueResolutionDecision -> !multiValueResolutionDecision.isDecided()).count());
    }

    protected void sort() {
        this.displayedKeys.sort((string, string2) -> {
            if (this.decisions.get(string).isDecided() && !this.decisions.get(string2).isDecided()) {
                return 1;
            }
            if (!this.decisions.get(string).isDecided() && this.decisions.get(string2).isDecided()) {
                return -1;
            }
            return string.compareTo((String)string2);
        });
    }

    public void rebuild() {
        if (this.tags == null) {
            return;
        }
        for (String iterator : this.tags.getKeys()) {
            MultiValueResolutionDecision multiValueResolutionDecision = new MultiValueResolutionDecision(this.tags.getTagsFor(iterator));
            if (this.decisions.get(iterator) != null) continue;
            this.decisions.put(iterator, multiValueResolutionDecision);
        }
        this.displayedKeys.clear();
        Set<String> set = this.tags.getKeys();
        if (this.showTagsWithConflictsOnly) {
            set.retainAll(this.keysWithConflicts);
            if (this.showTagsWithMultiValuesOnly) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!this.decisions.get(string).canKeepAll()) continue;
                    hashSet.add(string);
                }
                set.retainAll(hashSet);
            }
            for (String string : this.tags.getKeys()) {
                if (this.decisions.get(string).isDecided() || set.contains(string)) continue;
                set.add(string);
            }
        }
        this.displayedKeys.addAll((Collection<String>)set);
        this.refreshNumConflicts();
        this.sort();
        GuiHelper.runInEDTAndWait(this::fireTableDataChanged);
    }

    public void populate(TagCollection tagCollection, Set<String> set) {
        CheckParameterUtil.ensureParameterNotNull(tagCollection, "tags");
        this.tags = tagCollection;
        this.displayedKeys = new ArrayList<String>();
        if (set != null) {
            this.keysWithConflicts.addAll(set);
        }
        this.decisions = new HashMap<String, MultiValueResolutionDecision>();
        this.rebuild();
    }

    public final String getKey(int n) {
        return this.displayedKeys.get(n);
    }

    @Override
    public int getRowCount() {
        if (this.displayedKeys == null) {
            return 0;
        }
        return this.displayedKeys.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getDecision(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        MultiValueResolutionDecision multiValueResolutionDecision = this.getDecision(n);
        if (object instanceof String) {
            multiValueResolutionDecision.keepOne((String)object);
        } else if (object instanceof MultiValueDecisionType) {
            MultiValueDecisionType multiValueDecisionType = (MultiValueDecisionType)((Object)object);
            switch (multiValueDecisionType) {
                case KEEP_NONE: {
                    multiValueResolutionDecision.keepNone();
                    break;
                }
                case KEEP_ALL: {
                    multiValueResolutionDecision.keepAll();
                    break;
                }
                case SUM_ALL_NUMERIC: {
                    multiValueResolutionDecision.sumAllNumeric();
                    break;
                }
            }
        }
        GuiHelper.runInEDTAndWait(this::fireTableDataChanged);
        this.refreshNumConflicts();
    }

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public TagCollection getResolution() {
        TagCollection tagCollection = new TagCollection();
        for (String string : this.displayedKeys) {
            tagCollection.add(this.decisions.get(string).getResolution());
        }
        return tagCollection;
    }

    public TagCollection getAllResolutions() {
        TagCollection tagCollection = new TagCollection();
        for (MultiValueResolutionDecision multiValueResolutionDecision : this.decisions.values()) {
            tagCollection.add(multiValueResolutionDecision.getResolution());
        }
        return tagCollection;
    }

    public MultiValueResolutionDecision getDecision(int n) {
        return this.decisions.get(this.getKey(n));
    }

    public void setShowTagsWithConflictsOnly(boolean bl) {
        this.showTagsWithConflictsOnly = bl;
        this.rebuild();
    }

    public void setShowTagsWithMultiValuesOnly(boolean bl) {
        this.showTagsWithMultiValuesOnly = bl;
        this.rebuild();
    }

    public void prepareDefaultTagDecisions() {
        for (MultiValueResolutionDecision multiValueResolutionDecision : this.decisions.values()) {
            List<String> list = multiValueResolutionDecision.getValues();
            list.remove("");
            if (list.size() != 1) continue;
            multiValueResolutionDecision.keepOne(list.get(0));
        }
        this.rebuild();
    }

    public final Set<String> getKeysWithConflicts() {
        return new HashSet<String>(this.keysWithConflicts);
    }
}

