/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.range;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.range.IntRangeLayout;

@GeneratedBy(value=IntRangeLayout.class)
public class IntRangeLayoutImpl
extends BasicObjectLayoutImpl
implements IntRangeLayout {
    public static final IntRangeLayout INSTANCE = new IntRangeLayoutImpl();
    protected static final Shape.Allocator INT_RANGE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EXCLUDED_END_IDENTIFIER = new HiddenKey("excludedEnd");
    protected static final Property EXCLUDED_END_PROPERTY = Property.create(EXCLUDED_END_IDENTIFIER, INT_RANGE_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create(BEGIN_IDENTIFIER, INT_RANGE_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create(END_IDENTIFIER, INT_RANGE_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected IntRangeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createIntRangeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new IntRangeType(logicalClass, metaClass)).addProperty(EXCLUDED_END_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createIntRange(DynamicObjectFactory factory, boolean excludedEnd, int begin, int end) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (IntRangeLayoutImpl.createsIntRange(factory));
        assert (factory.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        assert (factory.getShape().hasProperty(BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty(END_IDENTIFIER));
        return factory.newInstance(excludedEnd, begin, end);
    }

    @Override
    public boolean isIntRange(Object object) {
        return object instanceof DynamicObject && this.isIntRange((DynamicObject)object);
    }

    @Override
    public boolean isIntRange(DynamicObject object) {
        return IntRangeLayoutImpl.isIntRange(object.getShape().getObjectType());
    }

    private static boolean isIntRange(ObjectType objectType) {
        return objectType instanceof IntRangeType;
    }

    private static boolean createsIntRange(DynamicObjectFactory factory) {
        return IntRangeLayoutImpl.isIntRange(factory.getShape().getObjectType());
    }

    @Override
    public boolean getExcludedEnd(DynamicObject object) {
        assert (this.isIntRange(object));
        assert (object.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        return (Boolean)EXCLUDED_END_PROPERTY.get(object, this.isIntRange(object));
    }

    @Override
    public int getBegin(DynamicObject object) {
        assert (this.isIntRange(object));
        assert (object.getShape().hasProperty(BEGIN_IDENTIFIER));
        return (Integer)BEGIN_PROPERTY.get(object, this.isIntRange(object));
    }

    @Override
    public int getEnd(DynamicObject object) {
        assert (this.isIntRange(object));
        assert (object.getShape().hasProperty(END_IDENTIFIER));
        return (Integer)END_PROPERTY.get(object, this.isIntRange(object));
    }

    public static class IntRangeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public IntRangeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public IntRangeType setLogicalClass(DynamicObject logicalClass) {
            return new IntRangeType(logicalClass, this.metaClass);
        }

        @Override
        public IntRangeType setMetaClass(DynamicObject metaClass) {
            return new IntRangeType(this.logicalClass, metaClass);
        }
    }
}

