/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.DeclarationContext;

public class GetCurrentVisibilityNode
extends RubyNode {
    public GetCurrentVisibilityNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public Visibility execute(VirtualFrame frame) {
        return DeclarationContext.findVisibility(frame);
    }

    @CompilerDirectives.TruffleBoundary
    public static Visibility getVisibilityFromNameAndFrame(String name, Frame frame) {
        if (ModuleOperations.isMethodPrivateFromName(name)) {
            return Visibility.PRIVATE;
        }
        return DeclarationContext.findVisibility(frame);
    }
}

