/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.protobuf.AbstractMessageLite;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.FieldSet;
import org.jetbrains.kotlin.protobuf.GeneratedMessage;
import org.jetbrains.kotlin.protobuf.Internal;
import org.jetbrains.kotlin.protobuf.InvalidProtocolBufferException;
import org.jetbrains.kotlin.protobuf.LazyField;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageOrBuilder;
import org.jetbrains.kotlin.protobuf.TextFormat;
import org.jetbrains.kotlin.protobuf.UninitializedMessageException;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;
import org.jetbrains.kotlin.protobuf.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    private int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        for (Descriptors.FieldDescriptor fieldDescriptor : this.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || this.hasField(fieldDescriptor)) continue;
            return false;
        }
        for (Map.Entry entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                for (Message element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> findInitializationErrors() {
        return Builder.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
    }

    private static String delimitWithCommas(List<String> parts) {
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(part);
        }
        return result.toString();
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        boolean isMessageSet = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            if (isMessageSet && field.isExtension() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field.isRepeated()) {
                output.writeMessageSetExtension(field.getNumber(), (Message)value);
                continue;
            }
            FieldSet.writeField(field, value, output);
        }
        UnknownFieldSet unknownFields = this.getUnknownFields();
        if (isMessageSet) {
            unknownFields.writeAsMessageSetTo(output);
        } else {
            unknownFields.writeTo(output);
        }
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        boolean isMessageSet = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            if (isMessageSet && field.isExtension() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field.isRepeated()) {
                size += CodedOutputStream.computeMessageSetExtensionSize(field.getNumber(), (Message)value);
                continue;
            }
            size += FieldSet.computeFieldSize(field, value);
        }
        UnknownFieldSet unknownFields = this.getUnknownFields();
        size = isMessageSet ? (size += unknownFields.getSerializedSizeAsMessageSet()) : (size += unknownFields.getSerializedSize());
        this.memoizedSize = size;
        return size;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message otherMessage = (Message)other;
        if (this.getDescriptorForType() != otherMessage.getDescriptorForType()) {
            return false;
        }
        return this.getAllFields().equals(otherMessage.getAllFields()) && this.getUnknownFields().equals(otherMessage.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int hash = 41;
        hash = 19 * hash + this.getDescriptorForType().hashCode();
        hash = this.hashFields(hash, this.getAllFields());
        hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    protected int hashFields(int hash, Map<Descriptors.FieldDescriptor, Object> map) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            hash = 37 * hash + field.getNumber();
            if (field.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                hash = 53 * hash + value.hashCode();
                continue;
            }
            if (field.isRepeated()) {
                List list = (List)value;
                hash = 53 * hash + AbstractMessage.hashEnumList(list);
                continue;
            }
            hash = 53 * hash + AbstractMessage.hashEnum((Internal.EnumLite)value);
        }
        return hash;
    }

    protected static int hashLong(long n) {
        return (int)(n ^ n >>> 32);
    }

    protected static int hashBoolean(boolean b) {
        return b ? 1231 : 1237;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    protected static int hashEnum(Internal.EnumLite e) {
        return e.getNumber();
    }

    protected static int hashEnumList(List<? extends Internal.EnumLite> list) {
        int hash = 1;
        for (Internal.EnumLite enumLite : list) {
            hash = 31 * hash + AbstractMessage.hashEnum(enumLite);
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType>
    implements Message.Builder {
        @Override
        public abstract BuilderType clone();

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return Builder.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
        }

        public BuilderType mergeFrom(Message other) {
            if (other.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : other.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field = entry.getKey();
                if (field.isRepeated()) {
                    for (Object element : (List)entry.getValue()) {
                        this.addRepeatedField(field, element);
                    }
                    continue;
                }
                if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message existingValue = (Message)this.getField(field);
                    if (existingValue == existingValue.getDefaultInstanceForType()) {
                        this.setField(field, entry.getValue());
                        continue;
                    }
                    this.setField(field, existingValue.newBuilderForType().mergeFrom(existingValue).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(field, entry.getValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input) throws IOException {
            return (BuilderType)this.mergeFrom(input, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            int tag;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((tag = input.readTag()) != 0 && Builder.mergeFieldFrom(input, unknownFields, extensionRegistry, this.getDescriptorForType(), this, null, tag)) {
            }
            this.setUnknownFields(unknownFields.build());
            return (BuilderType)this;
        }

        private static void addRepeatedField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field, Object value) {
            if (builder != null) {
                builder.addRepeatedField(field, value);
            } else {
                extensions.addRepeatedField(field, value);
            }
        }

        private static void setField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field, Object value) {
            if (builder != null) {
                builder.setField(field, value);
            } else {
                extensions.setField(field, value);
            }
        }

        private static boolean hasOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field) {
            if (builder != null) {
                return builder.hasField(field);
            }
            return extensions.hasField(field);
        }

        private static Message getOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field) {
            if (builder != null) {
                return (Message)builder.getField(field);
            }
            return (Message)extensions.getField(field);
        }

        private static void mergeOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field, Message.Builder subBuilder) {
            Message originalMessage = Builder.getOriginalMessage(builder, extensions, field);
            if (originalMessage != null) {
                subBuilder.mergeFrom(originalMessage);
            }
        }

        static boolean mergeFieldFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, int tag) throws IOException {
            Descriptors.FieldDescriptor field;
            if (type.getOptions().getMessageSetWireFormat() && tag == WireFormat.MESSAGE_SET_ITEM_TAG) {
                Builder.mergeMessageSetExtensionFromCodedStream(input, unknownFields, extensionRegistry, type, builder, extensions);
                return true;
            }
            int wireType = WireFormat.getTagWireType(tag);
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            Message defaultInstance = null;
            if (type.isExtensionNumber(fieldNumber)) {
                if (extensionRegistry instanceof ExtensionRegistry) {
                    ExtensionRegistry.ExtensionInfo extension = ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(type, fieldNumber);
                    if (extension == null) {
                        field = null;
                    } else {
                        field = extension.descriptor;
                        defaultInstance = extension.defaultInstance;
                        if (defaultInstance == null && field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            throw new IllegalStateException("Message-typed extension lacked default instance: " + field.getFullName());
                        }
                    }
                } else {
                    field = null;
                }
            } else {
                field = builder != null ? type.findFieldByNumber(fieldNumber) : null;
            }
            boolean unknown = false;
            boolean packed = false;
            if (field == null) {
                unknown = true;
            } else if (wireType == FieldSet.getWireFormatForFieldType(field.getLiteType(), false)) {
                packed = false;
            } else if (field.isPackable() && wireType == FieldSet.getWireFormatForFieldType(field.getLiteType(), true)) {
                packed = true;
            } else {
                unknown = true;
            }
            if (unknown) {
                return unknownFields.mergeFieldFrom(tag, input);
            }
            if (packed) {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (field.getLiteType() == WireFormat.FieldType.ENUM) {
                    while (input.getBytesUntilLimit() > 0) {
                        int rawValue = input.readEnum();
                        Descriptors.EnumValueDescriptor value = field.getEnumType().findValueByNumber(rawValue);
                        if (value == null) {
                            return true;
                        }
                        Builder.addRepeatedField(builder, extensions, field, value);
                    }
                } else {
                    while (input.getBytesUntilLimit() > 0) {
                        Object value = FieldSet.readPrimitiveField(input, field.getLiteType());
                        Builder.addRepeatedField(builder, extensions, field, value);
                    }
                }
                input.popLimit(limit);
            } else {
                Object value;
                switch (field.getType()) {
                    case GROUP: {
                        Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field);
                        if (!field.isRepeated()) {
                            Builder.mergeOriginalMessage(builder, extensions, field, subBuilder);
                        }
                        input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                        value = subBuilder.buildPartial();
                        break;
                    }
                    case MESSAGE: {
                        Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field);
                        if (!field.isRepeated()) {
                            Builder.mergeOriginalMessage(builder, extensions, field, subBuilder);
                        }
                        input.readMessage(subBuilder, extensionRegistry);
                        value = subBuilder.buildPartial();
                        break;
                    }
                    case ENUM: {
                        int rawValue = input.readEnum();
                        value = field.getEnumType().findValueByNumber(rawValue);
                        if (value != null) break;
                        unknownFields.mergeVarintField(fieldNumber, rawValue);
                        return true;
                    }
                    default: {
                        value = FieldSet.readPrimitiveField(input, field.getLiteType());
                    }
                }
                if (field.isRepeated()) {
                    Builder.addRepeatedField(builder, extensions, field, value);
                } else {
                    Builder.setField(builder, extensions, field, value);
                }
            }
            return true;
        }

        private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            int tag;
            int typeId = 0;
            ByteString rawBytes = null;
            ExtensionRegistry.ExtensionInfo extension = null;
            while ((tag = input.readTag()) != 0) {
                if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                    typeId = input.readUInt32();
                    if (typeId == 0 || !(extensionRegistry instanceof ExtensionRegistry)) continue;
                    extension = ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(type, typeId);
                    continue;
                }
                if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                    if (typeId != 0 && extension != null && ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                        Builder.eagerlyMergeMessageSetExtension(input, extension, extensionRegistry, builder, extensions);
                        rawBytes = null;
                        continue;
                    }
                    rawBytes = input.readBytes();
                    continue;
                }
                if (input.skipField(tag)) continue;
                break;
            }
            input.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
            if (rawBytes != null && typeId != 0) {
                if (extension != null) {
                    Builder.mergeMessageSetExtensionFromBytes(rawBytes, extension, extensionRegistry, builder, extensions);
                } else if (rawBytes != null) {
                    unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(rawBytes).build());
                }
            }
        }

        private static void eagerlyMergeMessageSetExtension(CodedInputStream input, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            Descriptors.FieldDescriptor field = extension.descriptor;
            Message value = null;
            if (Builder.hasOriginalMessage(builder, extensions, field)) {
                Message originalMessage = Builder.getOriginalMessage(builder, extensions, field);
                Message.Builder subBuilder = originalMessage.toBuilder();
                input.readMessage(subBuilder, extensionRegistry);
                value = subBuilder.buildPartial();
            } else {
                value = input.readMessage(extension.defaultInstance.getParserForType(), extensionRegistry);
            }
            if (builder != null) {
                builder.setField(field, value);
            } else {
                extensions.setField(field, value);
            }
        }

        private static void mergeMessageSetExtensionFromBytes(ByteString rawBytes, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            Descriptors.FieldDescriptor field = extension.descriptor;
            boolean hasOriginalValue = Builder.hasOriginalMessage(builder, extensions, field);
            if (hasOriginalValue || ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                Message value = null;
                if (hasOriginalValue) {
                    Message originalMessage = Builder.getOriginalMessage(builder, extensions, field);
                    Message.Builder subBuilder = originalMessage.toBuilder();
                    subBuilder.mergeFrom(rawBytes, extensionRegistry);
                    value = subBuilder.buildPartial();
                } else {
                    value = extension.defaultInstance.getParserForType().parsePartialFrom(rawBytes, extensionRegistry);
                }
                Builder.setField(builder, extensions, field, value);
            } else {
                LazyField lazyField = new LazyField(extension.defaultInstance, extensionRegistry, rawBytes);
                if (builder != null) {
                    if (builder instanceof GeneratedMessage.ExtendableBuilder) {
                        builder.setField(field, lazyField);
                    } else {
                        builder.setField(field, lazyField.getValue());
                    }
                } else {
                    extensions.setField(field, lazyField);
                }
            }
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFields) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFields).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(Builder.findMissingFields(message));
        }

        private static List<String> findMissingFields(MessageOrBuilder message) {
            ArrayList<String> results = new ArrayList<String>();
            Builder.findMissingFields(message, "", results);
            return results;
        }

        private static void findMissingFields(MessageOrBuilder message, String prefix, List<String> results) {
            for (Descriptors.FieldDescriptor fieldDescriptor : message.getDescriptorForType().getFields()) {
                if (!fieldDescriptor.isRequired() || message.hasField(fieldDescriptor)) continue;
                results.add(prefix + fieldDescriptor.getName());
            }
            for (Map.Entry entry : message.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
                Object value = entry.getValue();
                if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                if (field.isRepeated()) {
                    int i = 0;
                    for (Object element : (List)value) {
                        Builder.findMissingFields((MessageOrBuilder)element, Builder.subMessagePrefix(prefix, field, i++), results);
                    }
                    continue;
                }
                if (!message.hasField(field)) continue;
                Builder.findMissingFields((MessageOrBuilder)value, Builder.subMessagePrefix(prefix, field, -1), results);
            }
        }

        private static String subMessagePrefix(String prefix, Descriptors.FieldDescriptor field, int index) {
            StringBuilder result = new StringBuilder(prefix);
            if (field.isExtension()) {
                result.append('(').append(field.getFullName()).append(')');
            } else {
                result.append(field.getName());
            }
            if (index != -1) {
                result.append('[').append(index).append(']');
            }
            result.append('.');
            return result.toString();
        }

        @Override
        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(InputStream input) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input));
        }

        @Override
        public BuilderType mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input, extensionRegistry));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input) throws IOException {
            return super.mergeDelimitedFrom(input);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return super.mergeDelimitedFrom(input, extensionRegistry);
        }
    }
}

