/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class NegotiateScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NegotiateScheme.class);
    private String challenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int NEGOTIATING = 3;
    private static final int ESTABLISHED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private GSSContext context = null;
    private int state;
    byte[] token = new byte[0];

    protected void init(String server) throws GSSException {
        LOG.debug((Object)("init " + server));
        Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName("HTTP/" + server, null);
        this.context = manager.createContext(serverName, krb5Oid, null, 0);
        this.context.requestMutualAuth(true);
        this.context.requestCredDeleg(true);
        this.state = 1;
    }

    public NegotiateScheme() {
        this.state = 0;
    }

    public NegotiateScheme(String challenge) {
        LOG.debug((Object)("enter NegotiateScheme(" + challenge + ")"));
        this.processChallenge(challenge);
    }

    public void processChallenge(String challenge) {
        LOG.debug((Object)("enter processChallenge(challenge=\"" + challenge + "\")"));
        if (challenge.startsWith("Negotiate")) {
            if (!this.isComplete()) {
                this.state = 3;
            }
            this.token = challenge.startsWith("Negotiate ") ? new Base64().decode(challenge.substring(10).getBytes()) : new byte[0];
        }
    }

    public boolean isComplete() {
        LOG.debug((Object)"enter isComplete()");
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        LOG.debug((Object)("enter getID(): " + this.challenge));
        return this.challenge;
    }

    public String getParameter(String name) {
        LOG.debug((Object)("enter getParameter(" + name + ")"));
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        LOG.info((Object)"enter isConnectionBased()");
        return true;
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new AuthenticationException("method not supported by Negotiate scheme");
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        LOG.debug((Object)"enter NegotiateScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("Negotiation authentication process has not been initiated");
        }
        try {
            try {
                if (this.context == null) {
                    LOG.info((Object)("host: " + method.getURI().getHost()));
                    this.init(method.getURI().getHost());
                }
            }
            catch (URIException urie) {
                LOG.error((Object)urie.getMessage());
                this.state = Integer.MAX_VALUE;
                throw new AuthenticationException(urie.getMessage());
            }
            this.token = this.context.initSecContext(this.token, 0, this.token.length);
            LOG.info((Object)("got token, sending " + this.token.length + " to server"));
        }
        catch (GSSException gsse) {
            LOG.fatal((Object)gsse.getMessage());
            this.state = Integer.MAX_VALUE;
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new CredentialsNotAvailableException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new AuthChallengeException(gsse.getMessage(), (Throwable)gsse);
            }
            throw new AuthenticationException(gsse.getMessage());
        }
        return "Negotiate " + new String(new Base64().encode(this.token));
    }
}

