/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zaproxy.zap.ZapHttpConnection;
import org.zaproxy.zap.network.ZapHttpParser;

public class ZapGetMethod
extends GetMethod {
    private static final Log LOG = LogFactory.getLog(ZapGetMethod.class);
    private Socket upgradedSocket;
    private InputStream inputStream;

    public ZapGetMethod() {
    }

    public ZapGetMethod(String string) {
        super(string);
    }

    protected void readResponse(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        boolean bl = false;
        while (this.getStatusLine() == null) {
            this.readStatusLine(httpState, httpConnection);
            this.processStatusLine(httpState, httpConnection);
            this.readResponseHeaders(httpState, httpConnection);
            this.processResponseHeaders(httpState, httpConnection);
            int n = this.statusLine.getStatusCode();
            if (n == 101) {
                LOG.debug((Object)"Retrieved HTTP status code '101 Switching Protocols'. Keep connection open!");
                if (!(httpConnection instanceof ZapHttpConnection)) continue;
                bl = true;
                httpConnection.setHttpConnectionManager(null);
                continue;
            }
            if (n < 100 || n >= 200) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Discarding unexpected response: " + this.statusLine.toString()));
            }
            this.statusLine = null;
        }
        if (httpConnection instanceof ZapHttpConnection) {
            ZapHttpConnection zapHttpConnection = (ZapHttpConnection)httpConnection;
            this.upgradedSocket = zapHttpConnection.getSocket();
            this.inputStream = zapHttpConnection.getResponseInputStream();
        }
        if (!bl) {
            this.readResponseBody(httpState, httpConnection);
            this.processResponseBody(httpState, httpConnection);
        }
    }

    public Socket getUpgradedConnection() {
        return this.upgradedSocket;
    }

    public InputStream getUpgradedInputStream() {
        return this.inputStream;
    }

    public void releaseConnection() {
        String string;
        Header header = this.getResponseHeader("content-type");
        if (header != null && (string = header.getValue()) != null && string.equals("text/event-stream")) {
            return;
        }
        super.releaseConnection();
    }

    protected void readResponseHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        this.getResponseHeaderGroup().clear();
        Header[] headerArray = ZapHttpParser.parseHeaders(httpConnection.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headerArray);
    }
}

