/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.warmer;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class IndexWarmerMissingException
extends ElasticsearchException {
    private final String[] names;

    public IndexWarmerMissingException(String ... names) {
        super("index_warmer " + Arrays.toString(names) + " missing", new Object[0]);
        this.names = names;
    }

    public String[] names() {
        return this.names;
    }

    public IndexWarmerMissingException(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
    }
}

