/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentCache;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.DefaultClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSrcUpdateFactory
implements Factory<DefaultClassPath> {
    private final PersistentCache cache;
    private final GradleLauncher gradleLauncher;
    private BuildSrcBuildListenerFactory listenerFactory;
    private static final Logger LOGGER = Logging.getLogger(BuildSrcUpdateFactory.class);

    public BuildSrcUpdateFactory(PersistentCache cache, GradleLauncher gradleLauncher, BuildSrcBuildListenerFactory listenerFactory) {
        this.cache = cache;
        this.gradleLauncher = gradleLauncher;
        this.listenerFactory = listenerFactory;
    }

    public DefaultClassPath create() {
        File markerFile = new File(this.cache.getBaseDir(), "built.bin");
        boolean rebuild = !markerFile.exists();
        BuildSrcBuildListenerFactory.Listener listener = this.listenerFactory.create(rebuild);
        this.gradleLauncher.addListener(listener);
        this.gradleLauncher.run();
        Collection<File> classpath = listener.getRuntimeClasspath();
        LOGGER.debug("Gradle source classpath is: {}", classpath);
        try {
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return new DefaultClassPath(classpath);
    }
}

