#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: postgresql-binary
version: 0.9.1
id: postgresql-binary-0.9.1-DD8zQnk2avL9zlSqXVTZ6c
key: postgresql-binary-0.9.1-DD8zQnk2avL9zlSqXVTZ6c
license: MIT
copyright: (c) 2014, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/postgresql-binary
synopsis: Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.
    .
    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql "hasql">
    is based on this library.
    .
    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.4
    with the @integer_datetimes@ setting off and on.
category: PostgreSQL, Database, Codecs, Parsing
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoder
    PostgreSQL.Binary.Encoder
hidden-modules: PostgreSQL.Binary.Prelude
                PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
                PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
                PostgreSQL.Binary.BuilderPrim
abi: 9f4db1a74420825d15de7c53bbd9f3d6
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/postgresql-binary-0.9.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/postgresql-binary-0.9.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/postgresql-binary-0.9.1
hs-libraries: HSpostgresql-binary-0.9.1-DD8zQnk2avL9zlSqXVTZ6c
depends:
    aeson-0.11.2.0-1oWMNtvIfKMGa0C5QxOdH8 base-4.9.0.0
    base-prelude-1.0.1.1-50PByGWQp6O3J1SglYyZmP
    binary-parser-0.5.2-EDprLoBQcOu94TGhdmaB5o bytestring-0.10.8.1
    foldl-1.2.1-C8E5tabgEltAqBa6qUkd7Q
    loch-th-0.2.1-HeAYtId6vjrGaOk8hiaVQf
    placeholders-0.1-Jaw2KlzCEKg3F0WJS0H8eo
    scientific-0.3.4.9-Ghl8M4Ey2fMI7e1yk2TuuH
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0 uuid-1.3.12-C8CM0ftJ7269LD0G5N3lCE
    vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
haddock-interfaces: /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock
haddock-html: /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
