/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractElementManipulator<T extends PsiElement>
implements ElementManipulator<T> {
    @Override
    public T handleContentChange(@NotNull T element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/AbstractElementManipulator", "handleContentChange"));
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/AbstractElementManipulator", "getRangeInElement"));
        }
        TextRange textRange = new TextRange(0, element.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/AbstractElementManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

