// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Conic_HeaderFile
#define _Geom_Conic_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom_Conic.hxx>

#include <gp_Ax2.hxx>
#include <Geom_Curve.hxx>
#include <Standard_Real.hxx>
#include <GeomAbs_Shape.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class Standard_ConstructionError;
class Standard_RangeError;
class Standard_DomainError;
class gp_Ax1;
class gp_Pnt;
class gp_Ax2;


//! The abstract class Conic describes the common
//! behavior of conic curves in 3D space and, in
//! particular, their general characteristics. The Geom
//! package provides four concrete classes of conics:
//! Geom_Circle, Geom_Ellipse, Geom_Hyperbola and Geom_Parabola.
//! A conic is positioned in space with a right-handed
//! coordinate system (gp_Ax2 object), where:
//! - the origin is the center of the conic (or the apex in
//! the case of a parabola),
//! - the origin, "X Direction" and "Y Direction" define the
//! plane of the conic.
//! This coordinate system is the local coordinate
//! system of the conic.
//! The "main Direction" of this coordinate system is the
//! vector normal to the plane of the conic. The axis, of
//! which the origin and unit vector are respectively the
//! origin and "main Direction" of the local coordinate
//! system, is termed the "Axis" or "main Axis" of the conic.
//! The "main Direction" of the local coordinate system
//! gives an explicit orientation to the conic, determining
//! the direction in which the parameter increases along
//! the conic. The "X Axis" of the local coordinate system
//! also defines the origin of the parameter of the conic.
class Geom_Conic : public Geom_Curve
{

public:

  
  //! Changes the orientation of the conic's plane. The normal
  //! axis to the plane is A1. The XAxis and the YAxis are recomputed.
  //!
  //! raised if the A1 is parallel to the XAxis of the conic.
  Standard_EXPORT   void SetAxis (const gp_Ax1& A1) ;
  
  //! changes the location point of the conic.
  Standard_EXPORT   void SetLocation (const gp_Pnt& P) ;
  
  //! changes the local coordinate system of the conic.
  Standard_EXPORT   void SetPosition (const gp_Ax2& A2) ;
  
  //! Returns the "main Axis" of this conic. This axis is
  //! normal to the plane of the conic.
  Standard_EXPORT   gp_Ax1 Axis()  const;
  

  //! Returns the eccentricity value of the conic e.
  //! e = 0 for a circle
  //! 0 < e < 1 for an ellipse  (e = 0 if MajorRadius = MinorRadius)
  //! e > 1 for a hyperbola
  //! e = 1 for a parabola
  //! Exceptions
  //! Standard_DomainError in the case of a hyperbola if
  //! its major radius is null.
  Standard_EXPORT virtual   Standard_Real Eccentricity()  const = 0;
  

  //! Returns the location point of the conic.
  //! For the circle, the ellipse and the hyperbola it is the center of
  //! the conic. For the parabola it is the Apex of the parabola.
  Standard_EXPORT   gp_Pnt Location()  const;
  

  //! Returns the local coordinates system of the conic.
  //! The main direction of the Axis2Placement is normal to the
  //! plane of the conic. The X direction of the Axis2placement
  //! is in the plane of the conic and corresponds to the origin
  //! for the conic's parametric value u.
  Standard_EXPORT  const  gp_Ax2& Position()  const;
  

  //! Returns the XAxis of the conic.
  //! This axis defines the origin of parametrization of the conic.
  //! This axis is perpendicular to the Axis of the conic.
  //! This axis and the Yaxis define the plane of the conic.
  Standard_EXPORT   gp_Ax1 XAxis()  const;
  

  //! Returns the YAxis of the conic.
  //! The YAxis is perpendicular to the Xaxis.
  //! This axis and the Xaxis define the plane of the conic.
  Standard_EXPORT   gp_Ax1 YAxis()  const;
  

  //! Reverses the direction of parameterization of <me>.
  //! The local coordinate system of the conic is modified.
  Standard_EXPORT   void Reverse() ;
  
  //! Returns the  parameter on the  reversed  curve for
  //! the point of parameter U on <me>.
  Standard_EXPORT virtual   Standard_Real ReversedParameter (const Standard_Real U)  const = 0;
  
  //! The continuity of the conic is Cn.
  Standard_EXPORT   GeomAbs_Shape Continuity()  const;
  
  //! Returns True.
  //! Raised if N < 0.
  Standard_EXPORT   Standard_Boolean IsCN (const Standard_Integer N)  const;




  DEFINE_STANDARD_RTTI(Geom_Conic)

protected:


  gp_Ax2 pos;


private: 




};







#endif // _Geom_Conic_HeaderFile
