/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.core.Database;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.fuzz.io.OpenSession;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;

public class CommandLineInterpreter {
    private JBroFuzzWindow mWindow;
    private OpenSession os;

    public int process(String[] args) throws NoSuchFuzzerException {
        String inputFileName = "";
        String url = "";
        String request = "";
        String fuzzers = "";
        String encoder = "";
        String prefix = "";
        String suffix = "";
        int fuzzersStart = -1;
        int fuzzersEnd = -1;
        int fuzzerNumber = -1;
        int returnValue = -1;
        boolean result = false;
        boolean doNotFuzz = true;
        int j = 0;
        while (j < args.length) {
            if (!args[j].equals("-dDB")) {
                args[j].equals("--dumpDB");
            }
            if (args[j].equals("-e") || args[j].equals("--encoder")) {
                encoder = args[j + 1];
            }
            if (args[j].equals("-f") || args[j].equals("--fuzzer")) {
                fuzzers = args[j + 1];
            }
            if (args[j].equals("-fe") || args[j].equals("--fuzzerEnd")) {
                try {
                    fuzzersEnd = Integer.valueOf(args[j + 1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (args[j].equals("-fs") || args[j].equals("--fuzzerStart")) {
                try {
                    fuzzersStart = Integer.valueOf(args[j + 1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (args[j].equals("-fn") || args[j].equals("--fuzzerNumber")) {
                try {
                    fuzzerNumber = Integer.valueOf(args[j + 1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (args[j].equals("-h") || args[j].equals("--help")) {
                this.printHelp();
                System.exit(0);
            } else if (args[j].equals("-i") || args[j].equals("--input")) {
                inputFileName = args[j + 1];
            } else {
                if (args[j].equals("-n") || args[j].equals("--no-execute")) {
                    returnValue = -1;
                    return returnValue;
                }
                if (args[j].equals("-p") || args[j].equals("--perfix")) {
                    prefix = args[j + 1];
                } else if (args[j].equals("-r") || args[j].equals("--request")) {
                    request = args[j + 1];
                } else if (args[j].equals("-R") || args[j].equals("--run")) {
                    doNotFuzz = false;
                } else if (args[j].equals("-s") || args[j].equals("--showResults")) {
                    result = true;
                } else if (args[j].equals("-su") || args[j].equals("--suffix")) {
                    suffix = args[j + 1];
                } else if (args[j].equals("-u") || args[j].equals("--url")) {
                    url = args[j + 1];
                } else if (!(j <= 0 || args[j - 1].equals("-i") || args[j - 1].equals("--input") || args[j - 1].equals("-o") || args[j - 1].equals("--output"))) {
                    System.out.println("jbrofuzz: Unrecognized option '" + args[j] + "'");
                    this.printHelp();
                    System.exit(0);
                }
            }
            ++j;
        }
        this.mWindow = new JBroFuzzWindow(new JBroFuzz());
        if (inputFileName.length() > 0 && !inputFileName.equals("")) {
            this.os = new OpenSession(this.mWindow, inputFileName);
        }
        if (url.length() > 0 || !url.endsWith("")) {
            this.mWindow.getPanelFuzzing().setTextURL(url);
        }
        if (request.length() > 0 || !request.endsWith("")) {
            this.mWindow.getPanelFuzzing().setTextRequest(request);
        }
        if (fuzzers.length() > 0 || !fuzzers.endsWith("") && fuzzersStart >= 0 && fuzzersEnd >= 0 && fuzzersEnd >= fuzzersStart) {
            Database db = new Database();
            this.mWindow.getJBroFuzz().setDatabase(db);
            String fuzzerId = this.mWindow.getJBroFuzz().getDatabase().getIdFromName(fuzzers);
            if (fuzzerId.length() == 0) {
                throw new NoSuchFuzzerException(fuzzers);
            }
            this.mWindow.getPanelFuzzing().getFuzzersPanel().addFuzzer(fuzzerId, fuzzersStart, fuzzersEnd);
        }
        if (fuzzerNumber > 0 && encoder.length() > 0 && suffix.length() > 0 && prefix.length() > 0) {
            this.mWindow.getPanelFuzzing().getTransformsPanel().addTransform(fuzzerNumber, encoder, prefix, suffix);
        }
        if (!doNotFuzz) {
            int c = this.mWindow.getTp().getSelectedIndex();
            AbstractPanel p = (AbstractPanel)this.mWindow.getTp().getComponent(c);
            p = (AbstractPanel)this.mWindow.getTp().getComponent(c);
            p.start();
            p.stop();
            if (this.mWindow.getPanelFuzzing().isStopped()) {
                p.stop();
            }
        } else {
            returnValue = -1;
        }
        if (result) {
            JBroFuzzWindow.createAndShowGUI(this.os.getmWindow());
        } else {
            JBroFuzzWindow.createAndShowGUI(this.mWindow);
        }
        return returnValue;
    }

    public void printHelp() {
        String helpfileloc = "help/command-line-help.txt";
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader a = new BufferedReader(new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream(helpfileloc)));
            while ((line = a.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            System.out.println(sb.toString());
        }
        catch (IOException e) {
            System.out.println("Help file not found");
            System.exit(0);
        }
    }
}

