/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.common;

import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public abstract class VersionedAbstractParam
extends AbstractParam {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected static final String VERSION_ATTRIBUTE = "[@version]";
    protected static final int NO_CONFIG_VERSION = -1;
    protected static final int ERROR_READING_CONFIG_VERSION = -2;

    @Override
    protected void parse() {
        this.updateConfigFile();
        this.parseImpl();
    }

    protected abstract void parseImpl();

    protected void updateConfigFile() {
        int n = this.readConfigFileVersion();
        if (!this.isLatestConfigVersion(n)) {
            this.updateConfigsFromVersion(n);
        }
    }

    protected int readConfigFileVersion() {
        try {
            return this.getConfig().getInt(this.getConfigVersionKey(), -1);
        }
        catch (ConversionException conversionException) {
            this.logger.error((Object)("Error while getting the version of the configurations: " + conversionException.getMessage()), (Throwable)conversionException);
            return -2;
        }
    }

    protected abstract String getConfigVersionKey();

    protected boolean isLatestConfigVersion(int n) {
        return n == this.getCurrentVersion();
    }

    protected abstract int getCurrentVersion();

    protected void updateConfigsFromVersion(int n) {
        if (this.isLatestConfigVersion(n)) {
            return;
        }
        if (n == -2) {
            this.logger.warn((Object)"Configurations might not be in expected state, errors might happen...");
            return;
        }
        if (n != -1) {
            if (n > this.getCurrentVersion()) {
                this.logger.warn((Object)("Configurations will not be updated, file version (v" + n + ") is greater than the version of running code (v" + this.getCurrentVersion() + "), errors might happen..."));
                return;
            }
            this.logger.info((Object)("Updating configurations from v" + n + " to v" + this.getCurrentVersion()));
        }
        this.updateConfigsImpl(n);
        this.getConfig().setProperty(this.getConfigVersionKey(), (Object)this.getCurrentVersion());
    }

    protected abstract void updateConfigsImpl(int var1);
}

